/*
 * Decompiled with CFR 0.152.
 */
package com.barribob.MaelstromMod.entity.entities.gauntlet;

import com.barribob.MaelstromMod.entity.entities.EntityLeveledMob;
import com.barribob.MaelstromMod.entity.entities.gauntlet.IGauntletAction;
import com.barribob.MaelstromMod.init.ModBBAnimations;
import com.barribob.MaelstromMod.util.ModUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;

public class SummonMobsAction
implements IGauntletAction {
    private final Runnable spawningAlgorithm;
    private final EntityLeveledMob entity;
    private final Entity fistHitbox;
    private boolean isDefending;

    public SummonMobsAction(Runnable spawningAlgorithm, EntityLeveledMob entity, Entity fistHitbox) {
        this.spawningAlgorithm = spawningAlgorithm;
        this.entity = entity;
        this.fistHitbox = fistHitbox;
    }

    @Override
    public void doAction() {
        ModBBAnimations.animation((EntityLivingBase)this.entity, "gauntlet.summon", false);
        int closeFistTime = 10;
        int openFistTime = 210;
        int summoningTime = openFistTime - closeFistTime;
        this.entity.addEvent(() -> {
            this.isDefending = true;
            this.fistHitbox.field_70130_N = 2.5f;
            this.fistHitbox.field_70131_O = 2.0f;
        }, closeFistTime);
        this.entity.addEvent(() -> {
            this.isDefending = false;
            this.fistHitbox.field_70130_N = 0.0f;
            this.fistHitbox.field_70131_O = 0.0f;
        }, openFistTime);
        int spawnInterval = Math.max(1, summoningTime / this.entity.getMobConfig().getInt("mobs_per_spawn"));
        for (int i = closeFistTime; i < summoningTime; i += spawnInterval) {
            this.entity.addEvent(this.spawningAlgorithm, i);
        }
    }

    @Override
    public void update() {
        if (this.isDefending) {
            this.entity.field_70170_p.func_72960_a((Entity)this.entity, ModUtils.SECOND_PARTICLE_BYTE);
        }
    }

    @Override
    public boolean isImmuneToDamage() {
        return this.isDefending;
    }

    @Override
    public int attackLength() {
        return 210;
    }
}

