/*
 * Decompiled with CFR 0.152.
 */
package com.barribob.MaelstromMod.entity.entities.gauntlet;

import com.barribob.MaelstromMod.entity.entities.EntityLeveledMob;
import com.barribob.MaelstromMod.entity.entities.EntityMaelstromMob;
import com.barribob.MaelstromMod.entity.entities.gauntlet.ComboPunchAction;
import com.barribob.MaelstromMod.entity.entities.gauntlet.EntityAbstractMaelstromGauntlet;
import com.barribob.MaelstromMod.entity.entities.gauntlet.FireballThrowAction;
import com.barribob.MaelstromMod.entity.entities.gauntlet.IGauntletAction;
import com.barribob.MaelstromMod.entity.entities.gauntlet.LaserAction;
import com.barribob.MaelstromMod.entity.entities.gauntlet.PunchAction;
import com.barribob.MaelstromMod.entity.entities.gauntlet.SummonMobsAction;
import com.barribob.MaelstromMod.entity.projectile.Projectile;
import com.barribob.MaelstromMod.entity.projectile.ProjectileCrimsonWanderer;
import com.barribob.MaelstromMod.entity.projectile.ProjectileMegaFireball;
import com.barribob.MaelstromMod.util.ModRandom;
import com.barribob.MaelstromMod.util.ModUtils;
import com.barribob.MaelstromMod.util.handlers.ParticleManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntityAlternativeMaelstromGauntletStage2
extends EntityAbstractMaelstromGauntlet {
    private final IGauntletAction summonAttack;
    private final List<IGauntletAction> attacks;
    private final double maxLaserDistance = this.getMobConfig().getDouble("max_laser_distance");
    private final double maxFireballDistance = this.getMobConfig().getDouble("max_fireball_distance");

    public EntityAlternativeMaelstromGauntletStage2(World worldIn) {
        super(worldIn);
        this.healthScaledAttackFactor = 0.2;
        Supplier<Vec3d> position = () -> this.func_70638_az() == null ? null : this.func_70638_az().func_174791_d();
        PunchAction swirlPunchAttack = new PunchAction("gauntlet.swirl_punch", position, this::summonWanderersAndSmoke, this, (Entity)this.fist);
        this.summonAttack = new SummonMobsAction(this::spawnMob, this, (Entity)this.fist);
        LaserAction laserAttack = new LaserAction(this, 39, vec3d -> {});
        FireballThrowAction<EntityAlternativeMaelstromGauntletStage2> fireballAttack = new FireballThrowAction<EntityAlternativeMaelstromGauntletStage2>(target -> target.func_174824_e(1.0f), this::generateFireball, this);
        PunchAction punchAttack = new PunchAction("gauntlet.punch", position, () -> {}, this, (Entity)this.fist);
        ModRandom.RandomCollection<IGauntletAction> punchAttacks = ModRandom.choice(new IGauntletAction[]{punchAttack, swirlPunchAttack}, this.field_70146_Z, new double[]{2.0, 1.0});
        ComboPunchAction comboPunchAttack = new ComboPunchAction(punchAttacks, this);
        this.attacks = new ArrayList<IGauntletAction>(Arrays.asList(swirlPunchAttack, laserAttack, this.summonAttack, fireballAttack, comboPunchAttack));
    }

    private void spawnMob() {
        if (!this.trySpawnMob(true)) {
            this.trySpawnMob(false);
        }
    }

    private boolean trySpawnMob(boolean findGround) {
        EntityLeveledMob mob = ModUtils.spawnMob(this.field_70170_p, this.func_180425_c(), this.getLevel(), this.getMobConfig().getConfig(findGround ? "summoning_algorithm" : "aerial_summoning_algorithm"), findGround);
        return mob != null;
    }

    private Projectile generateFireball() {
        ProjectileMegaFireball fireball = new ProjectileMegaFireball(this.field_70170_p, (EntityLivingBase)this, this.getAttack() * this.getConfigFloat("fireball_damage"), null, false);
        fireball.setTravelRange((float)this.maxFireballDistance);
        return fireball;
    }

    private void summonWanderersAndSmoke() {
        int chance;
        this.field_70170_p.func_72960_a((Entity)this, ModUtils.THIRD_PARTICLE_BYTE);
        int n = chance = this.func_70638_az() != null && this.func_70638_az().field_70122_E ? 4 : 2;
        if (this.field_70146_Z.nextInt(chance) == 0) {
            this.summonCrimsonWanderer();
        }
    }

    @Override
    protected IGauntletAction getNextAttack(EntityLivingBase target, float distanceSq, IGauntletAction previousAction) {
        int numMinions = (int)ModUtils.getEntitiesInBox((Entity)this, this.func_174813_aQ().func_186662_g(50.0)).stream().filter(EntityMaelstromMob::isMaelstromMob).count();
        double summonWeight = previousAction == this.summonAttack || numMinions > 3 ? 0.0 : 0.8;
        double fireballWeight = (double)distanceSq < Math.pow(this.maxFireballDistance, 2.0) ? 1.0 : 0.0;
        double laserWeight = (double)distanceSq < Math.pow(this.maxLaserDistance, 2.0) ? 1.0 : 0.0;
        double punchWeight = ModUtils.canEntityBeSeen((Entity)this, (Entity)target) ? Math.sqrt(distanceSq) / 25.0 : 3.0;
        double comboPunchWeight = 0.8;
        double[] weights = new double[]{punchWeight, laserWeight, summonWeight, fireballWeight, comboPunchWeight};
        return ModRandom.choice(this.attacks, this.field_70146_Z, weights).next();
    }

    private void summonCrimsonWanderer() {
        ProjectileCrimsonWanderer shrapnel = new ProjectileCrimsonWanderer(this.field_70170_p, (EntityLivingBase)this, this.getAttack() * 0.5f);
        Vec3d lookVec = ModUtils.getLookVec(this.getPitch(), this.field_70177_z);
        Vec3d shrapnelPos = this.func_174791_d().func_178787_e(ModRandom.randVec().func_186678_a(3.0)).func_178788_d(lookVec.func_186678_a(6.0));
        ModUtils.setEntityPosition(shrapnel, shrapnelPos);
        shrapnel.func_189654_d(false);
        shrapnel.setTravelRange(50.0f);
        this.field_70170_p.func_72838_d((Entity)shrapnel);
        ModUtils.setEntityVelocity(shrapnel, lookVec.func_186678_a(0.35));
    }

    @Override
    public void func_70103_a(byte id) {
        if (id == ModUtils.THIRD_PARTICLE_BYTE) {
            for (int i = 0; i < 10; ++i) {
                Vec3d lookVec = ModUtils.getLookVec(this.getPitch(), this.field_70177_z);
                Vec3d pos = ModRandom.randVec().func_186678_a(3.0).func_178787_e(this.func_174791_d()).func_178788_d(lookVec.func_186678_a(3.0));
                ParticleManager.spawnFluff(this.field_70170_p, pos, Vec3d.field_186680_a, lookVec.func_186678_a(0.1));
            }
        }
        super.func_70103_a(id);
    }
}

