/*
 * Decompiled with CFR 0.152.
 */
package com.barribob.MaelstromMod.entity.entities.gauntlet;

import com.barribob.MaelstromMod.entity.entities.EntityLeveledMob;
import com.barribob.MaelstromMod.entity.entities.EntityMaelstromMob;
import com.barribob.MaelstromMod.entity.entities.gauntlet.EntityAbstractMaelstromGauntlet;
import com.barribob.MaelstromMod.entity.entities.gauntlet.EntityAlternativeMaelstromGauntletStage2;
import com.barribob.MaelstromMod.entity.entities.gauntlet.FireballThrowAction;
import com.barribob.MaelstromMod.entity.entities.gauntlet.IGauntletAction;
import com.barribob.MaelstromMod.entity.entities.gauntlet.LaserAction;
import com.barribob.MaelstromMod.entity.entities.gauntlet.PunchAction;
import com.barribob.MaelstromMod.entity.entities.gauntlet.SummonMobsAction;
import com.barribob.MaelstromMod.entity.projectile.Projectile;
import com.barribob.MaelstromMod.entity.projectile.ProjectileCrimsonWanderer;
import com.barribob.MaelstromMod.entity.projectile.ProjectileMegaFireball;
import com.barribob.MaelstromMod.util.ModRandom;
import com.barribob.MaelstromMod.util.ModUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntityAlternativeMaelstromGauntletStage1
extends EntityAbstractMaelstromGauntlet {
    private final IGauntletAction summonAttack;
    private final double fireballHealth;
    private final double lazerHealth;
    private final double spawnHealth;
    private final double maxLaserDistance;
    private final double maxFireballDistance;
    List<IGauntletAction> attacks;

    public EntityAlternativeMaelstromGauntletStage1(World worldIn) {
        super(worldIn);
        this.summonAttack = new SummonMobsAction(this::spawnMob, this, (Entity)this.fist);
        this.fireballHealth = this.getMobConfig().getDouble("use_fireball_at_health");
        this.lazerHealth = this.getMobConfig().getDouble("use_lazer_at_health");
        this.spawnHealth = this.getMobConfig().getDouble("use_spawning_at_health");
        this.maxLaserDistance = this.getMobConfig().getDouble("max_laser_distance");
        this.maxFireballDistance = this.getMobConfig().getDouble("max_fireball_distance");
        Supplier<Vec3d> position = () -> this.func_70638_az() == null ? null : this.func_70638_az().func_174791_d();
        PunchAction punchAttack = new PunchAction("gauntlet.punch", position, () -> {}, this, (Entity)this.fist);
        LaserAction laserAttack = new LaserAction(this, 39, vec3d -> {});
        FireballThrowAction<EntityAlternativeMaelstromGauntletStage1> fireballAttack = new FireballThrowAction<EntityAlternativeMaelstromGauntletStage1>(target -> target.func_174824_e(1.0f), this::generateFireball, this);
        this.attacks = new ArrayList<IGauntletAction>(Arrays.asList(punchAttack, laserAttack, this.summonAttack, fireballAttack));
    }

    private void spawnMob() {
        if (!this.trySpawnMob(true)) {
            this.trySpawnMob(false);
        }
    }

    private boolean trySpawnMob(boolean findGround) {
        EntityLeveledMob mob = ModUtils.spawnMob(this.field_70170_p, this.func_180425_c(), this.getLevel(), this.getMobConfig().getConfig(findGround ? "summoning_algorithm" : "aerial_summoning_algorithm"), findGround);
        return mob != null;
    }

    private Projectile generateFireball() {
        ProjectileMegaFireball fireball = new ProjectileMegaFireball(this.field_70170_p, (EntityLivingBase)this, this.getAttack() * this.getConfigFloat("fireball_damage"), null, false);
        fireball.setTravelRange((float)this.maxFireballDistance);
        return fireball;
    }

    @Override
    protected IGauntletAction getNextAttack(EntityLivingBase target, float distanceSq, IGauntletAction previousAction) {
        int numMinions = (int)ModUtils.getEntitiesInBox((Entity)this, this.func_174813_aQ().func_186662_g(50.0)).stream().filter(EntityMaelstromMob::isMaelstromMob).count();
        double defendWeight = previousAction == this.summonAttack || numMinions > 3 || (double)this.func_110143_aJ() > this.spawnHealth ? 0.0 : 0.8;
        double fireballWeight = (double)distanceSq < Math.pow(this.maxFireballDistance, 2.0) && (double)this.func_110143_aJ() < this.fireballHealth ? 1.0 : 0.0;
        double laserWeight = (double)distanceSq < Math.pow(this.maxLaserDistance, 2.0) && (double)this.func_110143_aJ() < this.lazerHealth ? 1.0 : 0.0;
        double punchWeight = ModUtils.canEntityBeSeen((Entity)this, (Entity)target) ? Math.sqrt(distanceSq) / 25.0 : 3.0;
        double[] weights = new double[]{punchWeight, laserWeight, defendWeight, fireballWeight};
        return ModRandom.choice(this.attacks, this.field_70146_Z, weights).next();
    }

    @Override
    public void func_70645_a(DamageSource cause) {
        EntityAlternativeMaelstromGauntletStage2 secondStage = new EntityAlternativeMaelstromGauntletStage2(this.field_70170_p);
        secondStage.func_82149_j((Entity)this);
        secondStage.func_70034_d(this.field_70759_as);
        if (!this.field_70170_p.field_72995_K) {
            secondStage.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)this)), null);
            secondStage.setLevel(this.getLevel());
            secondStage.setElement(this.getElement());
            secondStage.func_70624_b(this.func_70638_az());
            this.field_70170_p.func_72838_d((Entity)secondStage);
            for (int i = 0; i < 30; ++i) {
                this.summonCrimsonWanderer();
            }
        }
        this.func_70107_b(0.0, 0.0, 0.0);
        super.func_70645_a(cause);
    }

    private void summonCrimsonWanderer() {
        ProjectileCrimsonWanderer shrapnel = new ProjectileCrimsonWanderer(this.field_70170_p, (EntityLivingBase)this, this.getAttack() * 0.5f);
        Vec3d shrapnelPos = this.func_174791_d().func_178787_e(ModRandom.randVec().func_72432_b().func_186678_a(4.0));
        ModUtils.setEntityPosition(shrapnel, shrapnelPos);
        shrapnel.func_189654_d(false);
        shrapnel.setTravelRange(30.0f);
        this.field_70170_p.func_72838_d((Entity)shrapnel);
        Vec3d vel = ModUtils.direction(this.func_174824_e(1.0f), shrapnelPos).func_186678_a(0.1);
        ModUtils.setEntityVelocity(shrapnel, vel);
    }
}

