/*
 * Decompiled with CFR 0.152.
 */
package com.barribob.MaelstromMod.entity.entities.gauntlet;

import com.barribob.MaelstromMod.entity.entities.EntityLeveledMob;
import com.barribob.MaelstromMod.entity.entities.gauntlet.IGauntletAction;
import com.barribob.MaelstromMod.init.ModBBAnimations;
import com.barribob.MaelstromMod.util.ModDamageSource;
import com.barribob.MaelstromMod.util.ModUtils;
import java.util.function.Function;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.DamageSource;

public class DefendAction
implements IGauntletAction {
    private final EntityLeveledMob entity;
    private boolean isDefending;

    public DefendAction(EntityLeveledMob entity) {
        this.entity = entity;
    }

    @Override
    public void doAction() {
        ModBBAnimations.animation((EntityLivingBase)this.entity, "gauntlet.defend", false);
        this.entity.addEvent(() -> {
            this.isDefending = true;
            this.entity.field_70131_O = 2.0f;
        }, 5);
        this.entity.addEvent(() -> {
            this.isDefending = false;
            this.entity.field_70131_O = 4.0f;
        }, 22);
    }

    @Override
    public void update() {
        if (this.isDefending) {
            DamageSource source = ModDamageSource.builder().type("mm:mobMaelstrom").directEntity((Entity)this.entity).stoppedByArmorNotShields().element(this.entity.getElement()).build();
            Function<Entity, Float> kineticDamage = e -> Float.valueOf(this.entity.getAttack() * (float)ModUtils.getEntityVelocity(e).func_72433_c());
            ModUtils.handleAreaImpact(1.0f, kineticDamage, (Entity)this.entity, this.entity.func_174824_e(1.0f), source, 1.0f, 0, false);
        }
    }

    @Override
    public boolean isImmuneToDamage() {
        return this.isDefending;
    }

    @Override
    public int attackLength() {
        return 23;
    }

    @Override
    public int attackCooldown() {
        return 20;
    }
}

