/*
 * Decompiled with CFR 0.152.
 */
package com.barribob.MaelstromMod.entity.entities;

import com.barribob.MaelstromMod.entity.action.ActionDarkMissile;
import com.barribob.MaelstromMod.entity.action.ActionThrowPotion;
import com.barribob.MaelstromMod.entity.ai.EntityAIRangedAttack;
import com.barribob.MaelstromMod.entity.animation.AnimationWitchFlail;
import com.barribob.MaelstromMod.entity.entities.EntityMaelstromMob;
import com.barribob.MaelstromMod.entity.util.ComboAttack;
import com.barribob.MaelstromMod.util.ModRandom;
import com.barribob.MaelstromMod.util.handlers.LootTableHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.BossInfo;
import net.minecraft.world.BossInfoServer;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityMaelstromWitch
extends EntityMaelstromMob {
    private final BossInfoServer bossInfo = new BossInfoServer(this.func_145748_c_(), BossInfo.Color.PURPLE, BossInfo.Overlay.NOTCHED_12);
    private final ComboAttack attackHandler = new ComboAttack();
    private final byte lingeringPotions = (byte)4;
    private final byte rapidPotions = (byte)5;
    private final byte throwWood = (byte)6;
    private EntityAIRangedAttack rangedAttack;
    private EntityAIRangedAttack rageRangedAttack;
    private final float threshold = this.func_110138_aP() * 0.3f;
    private boolean isRaged = false;

    public EntityMaelstromWitch(World worldIn) {
        super(worldIn);
        this.healthScaledAttackFactor = 0.2;
        this.func_70105_a(0.9f, 1.8f);
        if (!worldIn.field_72995_K) {
            this.attackHandler.setAttack((byte)4, new ActionThrowPotion((Item)Items.field_185156_bI));
            this.attackHandler.setAttack((byte)5, new ActionThrowPotion((Item)Items.field_185155_bH));
            this.attackHandler.setAttack((byte)6, new ActionDarkMissile());
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void initAnimation() {
        this.attackHandler.setAttack((byte)4, new ActionThrowPotion((Item)Items.field_185156_bI), () -> new AnimationWitchFlail());
        this.attackHandler.setAttack((byte)5, new ActionThrowPotion((Item)Items.field_185155_bH), () -> new AnimationWitchFlail());
        this.attackHandler.setAttack((byte)6, new ActionDarkMissile(), () -> new AnimationWitchFlail());
        this.currentAnimation = new AnimationWitchFlail();
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.rangedAttack = new EntityAIRangedAttack<EntityMaelstromWitch>(this, 1.0, 60, 30.0f, 12.0f, 0.4f);
        this.rageRangedAttack = new EntityAIRangedAttack<EntityMaelstromWitch>(this, 1.0, 35, 30.0f, 12.0f, 0.4f);
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)this.rangedAttack);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
        if (this.isSwingingArms() && this.field_70173_aa % 3 == 0 && this.func_70638_az() != null) {
            this.attackHandler.getCurrentAttackAction().performAction(this, this.func_70638_az());
        }
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (source.func_82725_o()) {
            return false;
        }
        float prevHealth = this.func_110143_aJ();
        boolean flag = super.func_70097_a(source, amount);
        if (prevHealth > this.threshold && this.func_110143_aJ() < this.threshold && this.rangedAttack != null) {
            this.field_70714_bg.func_85156_a((EntityAIBase)this.rangedAttack);
            this.field_70714_bg.func_75776_a(4, (EntityAIBase)this.rageRangedAttack);
            this.isRaged = true;
        }
        return flag;
    }

    public void func_82196_d(EntityLivingBase target, float distanceFactor) {
    }

    @Override
    public void func_184724_a(boolean swingingArms) {
        super.func_184724_a(swingingArms);
        if (swingingArms) {
            Byte[] attack = new Byte[]{(byte)4, (byte)5, (byte)6};
            this.attackHandler.setCurrentAttack(ModRandom.choice(attack));
            this.field_70170_p.func_72960_a((Entity)this, this.attackHandler.getCurrentAttack());
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id >= 4 && id <= 6) {
            this.currentAnimation = this.attackHandler.getAnimation(id);
            this.getCurrentAnimation().startAnimation();
        } else {
            super.func_70103_a(id);
        }
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187920_gt;
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187923_gw;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187921_gu;
    }

    @Override
    protected ResourceLocation func_184647_J() {
        return LootTableHandler.SWAMP_BOSS;
    }

    protected float func_70647_i() {
        return 0.6f;
    }

    public void func_96094_a(String name) {
        super.func_96094_a(name);
        this.bossInfo.func_186739_a(this.func_145748_c_());
    }

    public void func_184178_b(EntityPlayerMP player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(EntityPlayerMP player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a("raged", this.isRaged);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("raged")) {
            this.isRaged = compound.func_74767_n("raged");
            if (this.isRaged && this.rangedAttack != null) {
                this.field_70714_bg.func_85156_a((EntityAIBase)this.rangedAttack);
                this.field_70714_bg.func_75776_a(4, (EntityAIBase)this.rageRangedAttack);
            }
        }
    }
}

