/*
 * Decompiled with CFR 0.152.
 */
package com.barribob.MaelstromMod.entity.entities;

import com.barribob.MaelstromMod.entity.action.ActionAerialTeleport;
import com.barribob.MaelstromMod.entity.action.ActionRayAttack;
import com.barribob.MaelstromMod.entity.action.ActionRingAttack;
import com.barribob.MaelstromMod.entity.action.ActionRuneAttack;
import com.barribob.MaelstromMod.entity.adjustment.MovingRuneAdjustment;
import com.barribob.MaelstromMod.entity.ai.AIAerialTimedAttack;
import com.barribob.MaelstromMod.entity.ai.EntityAIWanderWithGroup;
import com.barribob.MaelstromMod.entity.ai.FlyingMoveHelper;
import com.barribob.MaelstromMod.entity.entities.EntityMaelstromMob;
import com.barribob.MaelstromMod.entity.projectile.Projectile;
import com.barribob.MaelstromMod.entity.projectile.ProjectileHomingFlame;
import com.barribob.MaelstromMod.entity.projectile.ProjectileMaelstromRune;
import com.barribob.MaelstromMod.entity.projectile.ProjectileStatueMaelstromMissile;
import com.barribob.MaelstromMod.entity.util.IAttack;
import com.barribob.MaelstromMod.entity.util.TimedAttackInitiator;
import com.barribob.MaelstromMod.init.ModBBAnimations;
import com.barribob.MaelstromMod.util.ModColors;
import com.barribob.MaelstromMod.util.ModRandom;
import com.barribob.MaelstromMod.util.ModUtils;
import com.barribob.MaelstromMod.util.handlers.LootTableHandler;
import com.barribob.MaelstromMod.util.handlers.ParticleManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.pathfinding.PathNavigateFlying;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.BossInfo;
import net.minecraft.world.BossInfoServer;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityMaelstromStatueOfNirvana
extends EntityMaelstromMob
implements IAttack {
    private final BossInfoServer bossInfo = new BossInfoServer(this.func_145748_c_(), BossInfo.Color.PURPLE, BossInfo.Overlay.NOTCHED_20);
    private static boolean doTeleportNext;
    Consumer<EntityLivingBase> previousAttack;
    public Supplier<Projectile> maelstromFlame = () -> {
        ProjectileHomingFlame projectile = new ProjectileHomingFlame(this.field_70170_p, (EntityLivingBase)this, this.getAttack() * this.getConfigFloat("homing_projectile_damage"));
        projectile.func_189654_d(true);
        projectile.setTravelRange(40.0f);
        return projectile;
    };
    Supplier<Projectile> maelstromRune = () -> new ProjectileMaelstromRune(this.field_70170_p, (EntityLivingBase)this, this.getAttack() * this.getConfigFloat("maelstrom_rune_damage"));
    Supplier<Projectile> maelstromMissile = () -> new ProjectileStatueMaelstromMissile(this.field_70170_p, (EntityLivingBase)this, this.getAttack() * this.getConfigFloat("maelstrom_missile_damage"));
    private final Consumer<EntityLivingBase> teleportAttack = target -> new ActionAerialTeleport(ModColors.PURPLE).performAction(this, (EntityLivingBase)target);
    private final Consumer<EntityLivingBase> rayAttack = target -> {
        ModBBAnimations.animation((EntityLivingBase)this, "statue.fireball", false);
        this.addEvent(() -> {
            new ActionRayAttack(this.maelstromMissile, 1.1f).performAction(this, (EntityLivingBase)target);
            new ActionRayAttack(this.maelstromMissile, 1.1f).performAction(this, (EntityLivingBase)target);
            this.func_184185_a(SoundEvents.field_187606_E, 1.0f, ModRandom.getFloat(0.2f) + 1.3f);
        }, 22);
    };
    private final Consumer<EntityLivingBase> runeAttack = target -> {
        ModBBAnimations.animation((EntityLivingBase)this, "statue.runes", false);
        this.addEvent(() -> new ActionRuneAttack(this.maelstromRune, new MovingRuneAdjustment((Entity)target)).performAction(this, (EntityLivingBase)target), 12);
    };
    private final Consumer<EntityLivingBase> ringAttack = target -> {
        ModBBAnimations.animation((EntityLivingBase)this, "statue.summon", false);
        this.addEvent(() -> new ActionRingAttack(this.maelstromFlame).performAction(this, (EntityLivingBase)target), 15);
        this.func_184185_a(SoundEvents.field_193790_di, 2.5f, 1.0f + ModRandom.getFloat(0.2f));
    };

    public EntityMaelstromStatueOfNirvana(World worldIn) {
        super(worldIn);
        this.field_70765_h = new FlyingMoveHelper((EntityLiving)this);
        this.field_70699_by = new PathNavigateFlying((EntityLiving)this, worldIn);
        this.func_70105_a(1.6f, 3.6f);
        this.healthScaledAttackFactor = 0.2;
        if (!this.field_70170_p.field_72995_K) {
            this.initNirvanaAI();
        }
    }

    private void initNirvanaAI() {
        float attackDistance = (float)this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111126_e();
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new AIAerialTimedAttack((EntityLiving)this, attackDistance, 20.0f, 30.0f, new TimedAttackInitiator<EntityMaelstromStatueOfNirvana>(this, 80)));
    }

    @Override
    protected AxisAlignedBB getTargetableArea(double targetDistance) {
        return this.func_174813_aQ().func_186662_g(targetDistance);
    }

    @Override
    protected boolean func_70692_ba() {
        return false;
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        ModUtils.removeTaskOfType(this.field_70714_bg, EntityAIWanderWithGroup.class);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
        if (!this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_72960_a((Entity)this, ModUtils.PARTICLE_BYTE);
        }
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.field_70146_Z.nextInt(8) == 0 && amount > 1.0f) {
            doTeleportNext = true;
        }
        return super.func_70097_a(source, amount);
    }

    @Override
    public int startAttack(EntityLivingBase target, float distanceSq, boolean strafingBackwards) {
        boolean canSee = this.field_70170_p.func_147447_a(target.func_174824_e(1.0f), this.func_174824_e(1.0f), false, true, false) == null;
        ArrayList<Consumer> attacks = new ArrayList<Consumer>(Arrays.asList(this.rayAttack, this.runeAttack, this.ringAttack, this.teleportAttack));
        boolean i = this.previousAttack != this.ringAttack;
        double[] weights = new double[]{1.0, 1.0, (double)i, canSee ? 0.0 : 2.0};
        this.previousAttack = ModRandom.choice(attacks, this.field_70146_Z, weights).next();
        if (doTeleportNext) {
            this.previousAttack = this.teleportAttack;
            doTeleportNext = false;
        }
        this.previousAttack.accept(target);
        return 50;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == ModUtils.PARTICLE_BYTE) {
            ParticleManager.spawnEffect(this.field_70170_p, ModRandom.randVec().func_178787_e(this.func_174791_d()), ModColors.PURPLE);
        } else if (id == ModUtils.SECOND_PARTICLE_BYTE) {
            ModUtils.performNTimes(3, i -> ModUtils.circleCallback((float)i.intValue() * 0.5f + 1.0f, 30, pos -> {
                ParticleManager.spawnSwirl(this.field_70170_p, this.func_174791_d().func_178787_e(pos), ModColors.PURPLE, Vec3d.field_186680_a, ModRandom.range(10, 15));
                ParticleManager.spawnSwirl(this.field_70170_p, this.func_174791_d().func_178787_e(ModUtils.rotateVector2(pos, ModUtils.yVec(1.0), 90.0)), ModColors.PURPLE, Vec3d.field_186680_a, ModRandom.range(10, 15));
            }));
        }
        super.func_70103_a(id);
    }

    public void func_96094_a(@Nonnull String name) {
        super.func_96094_a(name);
        this.bossInfo.func_186739_a(this.func_145748_c_());
    }

    public void func_184178_b(@Nonnull EntityPlayerMP player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(@Nonnull EntityPlayerMP player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187772_dn;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187766_dk;
    }

    @Override
    protected ResourceLocation func_184647_J() {
        return LootTableHandler.GOLDEN_BOSS;
    }

    public void func_82196_d(@Nonnull EntityLivingBase target, float distanceFactor) {
    }

    public void func_191986_a(float strafe, float vertical, float forward) {
        ModUtils.aerialTravel((EntityLivingBase)this, strafe, vertical, forward);
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    protected void func_184231_a(double y, boolean onGroundIn, @Nonnull IBlockState state, @Nonnull BlockPos pos) {
    }

    public boolean func_70617_f_() {
        return false;
    }
}

