/*
 * Decompiled with CFR 0.152.
 */
package com.barribob.MaelstromMod.entity.entities;

import com.barribob.MaelstromMod.Main;
import com.barribob.MaelstromMod.config.ModConfig;
import com.barribob.MaelstromMod.entity.ai.EntityAIAvoidCrowding;
import com.barribob.MaelstromMod.entity.ai.EntityAIFollowAttackers;
import com.barribob.MaelstromMod.entity.ai.EntityAIWanderWithGroup;
import com.barribob.MaelstromMod.entity.entities.EntityLeveledMob;
import com.barribob.MaelstromMod.util.Element;
import com.barribob.MaelstromMod.util.ModRandom;
import com.barribob.MaelstromMod.util.ModUtils;
import com.barribob.MaelstromMod.util.handlers.LootTableHandler;
import com.barribob.MaelstromMod.util.handlers.ParticleManager;
import com.google.common.base.Predicate;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveIndoors;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityRegistry;

public abstract class EntityMaelstromMob
extends EntityLeveledMob
implements IRangedAttackMob,
IMob {
    private int entityCount = 0;
    private final int ticker = 0;
    private static final DataParameter<Boolean> SWINGING_ARMS = EntityDataManager.func_187226_a(EntityLeveledMob.class, (DataSerializer)DataSerializers.field_187198_h);
    public static final Predicate<Entity> CAN_TARGET = entity -> {
        ResourceLocation registryName;
        EntityEntry entry;
        boolean isConfigFriend = false;
        if (entity != null && (entry = EntityRegistry.getEntry(entity.getClass())) != null && (registryName = entry.getRegistryName()) != null) {
            isConfigFriend = Main.maelstromFriendsConfig.getStringList("maelstrom_friends").contains(registryName.toString());
        }
        return !(entity instanceof EntityMaelstromMob) && !isConfigFriend;
    };

    public static boolean isMaelstromMob(Entity entity) {
        return !CAN_TARGET.apply((Object)entity);
    }

    public EntityMaelstromMob(World worldIn) {
        super(worldIn);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIFollowAttackers(this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIAvoidCrowding(this, 1.0));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWanderWithGroup(this, 1.0));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMoveIndoors((EntityCreature)this));
        if (!this.func_70005_c_().toLowerCase().contains("statue") && !this.func_70005_c_().toLowerCase().contains("gauntlet")) {
            this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIOpenDoor((EntityLiving)this, true));
        }
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget<EntityPlayer>((EntityCreature)this, EntityPlayer.class, 1, true, false, null){

            @Nonnull
            protected AxisAlignedBB func_188511_a(double targetDistance) {
                return EntityMaelstromMob.this.getTargetableArea(targetDistance);
            }
        });
        if (ModConfig.entities.attackAll) {
            this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget<EntityLiving>((EntityCreature)this, EntityLiving.class, 10, true, false, CAN_TARGET){

                @Nonnull
                protected AxisAlignedBB func_188511_a(double targetDistance) {
                    return EntityMaelstromMob.this.getTargetableArea(targetDistance);
                }
            });
        }
    }

    protected AxisAlignedBB getTargetableArea(double targetDistance) {
        return this.func_174813_aQ().func_72314_b(targetDistance, 4.0, targetDistance);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.23f);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(20.0);
    }

    public SoundCategory func_184176_by() {
        return SoundCategory.HOSTILE;
    }

    protected SoundEvent func_184184_Z() {
        return SoundEvents.field_187593_cC;
    }

    protected SoundEvent func_184181_aa() {
        return SoundEvents.field_187591_cB;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187741_cz;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187738_cy;
    }

    protected SoundEvent func_184588_d(int heightIn) {
        return heightIn > 4 ? SoundEvents.field_187735_cx : SoundEvents.field_187589_cA;
    }

    protected ResourceLocation func_184647_J() {
        if (this.getElement().equals((Object)Element.AZURE)) {
            return LootTableHandler.AZURE_MAELSTROM;
        }
        if (this.getElement().equals((Object)Element.GOLDEN)) {
            return LootTableHandler.GOLDEN_MAELSTROM;
        }
        if (this.getElement().equals((Object)Element.CRIMSON)) {
            return LootTableHandler.CRIMSON_MAELSTROM;
        }
        return LootTableHandler.MAELSTROM;
    }

    public boolean func_70601_bi() {
        if (this.field_70170_p.field_73011_w.getDimension() != 111 || this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL) {
            return false;
        }
        List players = this.field_70170_p.field_73010_i;
        this.entityCount = this.field_70170_p.func_72872_a(EntityMaelstromMob.class, new AxisAlignedBB(this.func_180425_c()).func_186662_g(64.0)).size();
        if (this.entityCount <= 8) {
            for (int i = 0; i < players.size(); ++i) {
                EntityPlayerMP player = (EntityPlayerMP)players.get(i);
                NBTTagCompound entityData = player.getEntityData();
                if (!entityData.func_74764_b("Torgo|DarkTimer") || entityData.func_74762_e("Torgo|DarkTimer") < 10 || !(((EntityPlayer)players.get(i)).func_70032_d((Entity)this) <= 32.0f)) continue;
                return super.func_70601_bi();
            }
        }
        return false;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL) {
            this.func_70106_y();
        }
    }

    protected boolean func_146066_aG() {
        return false;
    }

    public void func_70656_aK() {
        if (this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 20; ++i) {
                double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                ParticleManager.spawnMaelstromLargeSmoke(this.field_70170_p, this.field_70146_Z, new Vec3d(this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N - d0 * 10.0, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O) - d1 * 10.0, this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N - d2 * 10.0));
            }
        } else {
            this.field_70170_p.func_72960_a((Entity)this, (byte)20);
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (!CAN_TARGET.apply((Object)source.func_76346_g())) {
            return false;
        }
        return super.func_70097_a(source, amount);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SWINGING_ARMS, (Object)false);
    }

    public boolean isSwingingArms() {
        return (Boolean)this.field_70180_af.func_187225_a(SWINGING_ARMS);
    }

    public void func_184724_a(boolean swingingArms) {
        this.field_70180_af.func_187227_b(SWINGING_ARMS, (Object)swingingArms);
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
    }

    protected float getManaExp() {
        return Math.round(this.func_110138_aP() * 0.05f);
    }

    protected void func_70609_aI() {
        ++this.field_70725_aQ;
        if (this.field_70725_aQ == 20) {
            if (!this.field_70170_p.field_72995_K && (this.func_70684_aJ() || this.field_70718_bc > 0 && this.func_146066_aG() && this.field_70170_p.func_82736_K().func_82766_b("doMobLoot"))) {
                int j;
                int i = this.func_70693_a(this.field_70717_bb);
                for (i = ForgeEventFactory.getExperienceDrop((EntityLivingBase)this, (EntityPlayer)this.field_70717_bb, (int)i); i > 0; i -= j) {
                    j = EntityXPOrb.func_70527_a((int)i);
                    this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, j));
                }
            }
            this.func_70106_y();
            this.field_70170_p.func_72960_a((Entity)this, ModUtils.MAELSTROM_PARTICLE_BYTE);
        }
    }

    @Override
    public void func_70103_a(byte id) {
        if (id == ModUtils.MAELSTROM_PARTICLE_BYTE) {
            for (int i = 0; i < 20; ++i) {
                ParticleManager.spawnMaelstromLargeSmoke(this.field_70170_p, this.field_70146_Z, this.func_174791_d().func_178787_e(ModRandom.gaussVec().func_186678_a(0.5).func_178787_e(ModUtils.yVec(1.0))));
            }
        }
        super.func_70103_a(id);
    }

    protected boolean func_70692_ba() {
        return true;
    }
}

