/*
 * Decompiled with CFR 0.152.
 */
package com.barribob.MaelstromMod.entity.entities;

import com.barribob.MaelstromMod.Main;
import com.barribob.MaelstromMod.entity.ai.AIFuryDive;
import com.barribob.MaelstromMod.entity.ai.AIPassiveCircle;
import com.barribob.MaelstromMod.entity.ai.AIRandomFly;
import com.barribob.MaelstromMod.entity.ai.FlyingMoveHelper;
import com.barribob.MaelstromMod.entity.entities.EntityMaelstromMob;
import com.barribob.MaelstromMod.entity.util.IAcceleration;
import com.barribob.MaelstromMod.init.ModBBAnimations;
import com.barribob.MaelstromMod.packets.MessageModParticles;
import com.barribob.MaelstromMod.particle.EnumModParticles;
import com.barribob.MaelstromMod.util.ModColors;
import com.barribob.MaelstromMod.util.ModDamageSource;
import com.barribob.MaelstromMod.util.ModUtils;
import com.barribob.MaelstromMod.util.handlers.SoundsHandler;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.init.SoundEvents;
import net.minecraft.pathfinding.PathNavigateFlying;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class EntityMaelstromFury
extends EntityMaelstromMob
implements IAcceleration {
    Vec3d acceleration = Vec3d.field_186680_a;

    public EntityMaelstromFury(World worldIn) {
        super(worldIn);
        this.field_70765_h = new FlyingMoveHelper((EntityLiving)this);
        this.field_70699_by = new PathNavigateFlying((EntityLiving)this, worldIn);
        if (!worldIn.field_72995_K) {
            ModBBAnimations.animation((EntityLivingBase)this, "fury.fly", false);
        }
        this.func_70105_a(1.2f, 1.2f);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        Vec3d prevAcceleration = this.acceleration;
        this.acceleration = ModUtils.getEntityVelocity((Entity)this).func_186678_a(0.1).func_178787_e(this.acceleration.func_186678_a(0.9));
        if (!this.field_70170_p.field_72995_K) {
            if (prevAcceleration.field_72448_b > 0.0 && this.acceleration.field_72448_b <= 0.0) {
                ModBBAnimations.animation((EntityLivingBase)this, "fury.fly", true);
            } else if (prevAcceleration.field_72448_b <= 0.0 && this.acceleration.field_72448_b > 0.0) {
                ModBBAnimations.animation((EntityLivingBase)this, "fury.fly", false);
            }
        }
    }

    @Override
    public Vec3d getAcceleration() {
        return this.acceleration;
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new AIRandomFly((EntityLiving)this));
        this.field_70714_bg.func_75776_a(3, new AIPassiveCircle<EntityMaelstromFury>(this, 30.0f));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new AIFuryDive(100, 100, (EntityLiving)this, this::onDiveStart, this::onDiveEnd, this::whileDiving));
        super.func_184651_r();
    }

    public void func_191986_a(float strafe, float vertical, float forward) {
        ModUtils.aerialTravel((EntityLivingBase)this, strafe, vertical, forward);
    }

    private void onDiveStart() {
        this.func_184185_a(SoundEvents.field_191265_hd, 7.0f, 1.7f);
        ModBBAnimations.animation((EntityLivingBase)this, "fury.dive", false);
    }

    private void whileDiving() {
        Vec3d entityVelocity = ModUtils.getEntityVelocity((Entity)this);
        Vec3d spearPos = ModUtils.getAxisOffset(entityVelocity.func_72432_b(), ModUtils.X_AXIS.func_186678_a(1.7)).func_178787_e(this.func_174791_d());
        DamageSource damageSource = ModDamageSource.builder().type("mm:mobMaelstrom").disablesShields().directEntity((Entity)this).element(this.getElement()).build();
        float velocity = (float)entityVelocity.func_72433_c();
        ModUtils.handleAreaImpact(0.7f, e -> Float.valueOf(this.getAttack() * velocity * 2.0f), (Entity)this, spearPos, damageSource, 0.5f, 0);
        Main.network.sendToAllTracking((IMessage)new MessageModParticles(EnumModParticles.EFFECT, spearPos, entityVelocity, ModColors.PURPLE), (Entity)this);
    }

    private void onDiveEnd() {
        ModBBAnimations.animation((EntityLivingBase)this, "fury.dive", true);
        ModBBAnimations.animation((EntityLivingBase)this, "fury.undive", false);
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    protected void func_184231_a(double y, boolean onGroundIn, @Nonnull IBlockState state, @Nonnull BlockPos pos) {
    }

    public boolean func_70617_f_() {
        return false;
    }

    public void func_82196_d(@Nonnull EntityLivingBase target, float distanceFactor) {
    }

    @Override
    protected AxisAlignedBB getTargetableArea(double targetDistance) {
        return this.func_174813_aQ().func_186662_g(targetDistance);
    }

    protected SoundEvent func_184639_G() {
        return SoundsHandler.ENTITY_SHADE_AMBIENT;
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundsHandler.ENTITY_SHADE_HURT;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return SoundsHandler.ENTITY_SHADE_DEATH;
    }

    @Override
    protected boolean func_70692_ba() {
        return this.field_70173_aa > 20 * this.getMobConfig().getInt("seconds_existed_to_be_able_to_despawn");
    }
}

