/*
 * Decompiled with CFR 0.152.
 */
package com.barribob.MaelstromMod.entity.entities;

import com.barribob.MaelstromMod.entity.action.ActionFireball;
import com.barribob.MaelstromMod.entity.action.ActionGroundSlash;
import com.barribob.MaelstromMod.entity.action.ActionSpinSlash;
import com.barribob.MaelstromMod.entity.action.ActionTeleport;
import com.barribob.MaelstromMod.entity.action.IAction;
import com.barribob.MaelstromMod.entity.ai.EntityAIRangedAttack;
import com.barribob.MaelstromMod.entity.animation.AnimationFireballThrow;
import com.barribob.MaelstromMod.entity.animation.AnimationHerobrineGroundSlash;
import com.barribob.MaelstromMod.entity.animation.AnimationSpinSlash;
import com.barribob.MaelstromMod.entity.entities.EntityLeveledMob;
import com.barribob.MaelstromMod.entity.projectile.Projectile;
import com.barribob.MaelstromMod.entity.projectile.ProjectileFireball;
import com.barribob.MaelstromMod.entity.projectile.ProjectileHerobrineQuake;
import com.barribob.MaelstromMod.entity.util.ComboAttack;
import com.barribob.MaelstromMod.util.ModColors;
import com.barribob.MaelstromMod.util.ModRandom;
import com.barribob.MaelstromMod.util.ModUtils;
import com.barribob.MaelstromMod.util.handlers.ParticleManager;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFleeSun;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityHerobrineOne
extends EntityLeveledMob
implements IRangedAttackMob {
    private static final DataParameter<Boolean> SWINGING_ARMS = EntityDataManager.func_187226_a(EntityLeveledMob.class, (DataSerializer)DataSerializers.field_187198_h);
    private final ComboAttack attackHandler = new ComboAttack();
    private final byte passiveParticleByte = (byte)7;
    private final int maxHits = 3;
    private int hits = 5;
    private final byte deathParticleByte = (byte)8;
    public static final byte slashParticleByte = 9;
    private final byte fireballParticleByte = (byte)10;
    private boolean markedToDespawn = false;
    private final byte spinSlash = (byte)4;
    private final byte groundSlash = (byte)5;
    private final byte fireball = (byte)6;

    public EntityHerobrineOne(World worldIn) {
        super(worldIn);
        this.healthScaledAttackFactor = 0.2;
        this.func_70105_a(0.8f, 2.0f);
        if (!this.field_70170_p.field_72995_K) {
            this.attackHandler.setAttack((byte)4, new ActionSpinSlash());
            this.attackHandler.setAttack((byte)5, new ActionGroundSlash(() -> new ProjectileHerobrineQuake(this.field_70170_p, (EntityLivingBase)this, this.getAttack())));
            this.attackHandler.setAttack((byte)6, new IAction(){

                @Override
                public void performAction(EntityLeveledMob actor, EntityLivingBase target) {
                    actor.func_184185_a(SoundEvents.field_187606_E, 1.0f, 0.4f / (actor.field_70170_p.field_73012_v.nextFloat() * 0.4f + 0.8f));
                    ProjectileFireball projectile = new ProjectileFireball(actor.field_70170_p, (EntityLivingBase)actor, actor.getAttack(), null);
                    ModUtils.throwProjectile((EntityLivingBase)actor, target, (Projectile)projectile, 2.0f, 0.5f, ModUtils.yVec(0.5));
                }
            });
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void initAnimation() {
        this.attackHandler.setAttack((byte)4, new ActionSpinSlash(), () -> new AnimationSpinSlash());
        this.attackHandler.setAttack((byte)5, new ActionGroundSlash(() -> new ProjectileHerobrineQuake(this.field_70170_p, (EntityLivingBase)this, this.getAttack())), () -> new AnimationHerobrineGroundSlash());
        this.attackHandler.setAttack((byte)6, new ActionFireball(), () -> new AnimationFireballThrow());
        this.currentAnimation = new AnimationSpinSlash();
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(4, new EntityAIRangedAttack<EntityHerobrineOne>(this, 1.0, 40, 10.0f, 0.2f));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIFleeSun((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(30.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(30.0);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.hits == 0) {
            this.hits = 3;
            return super.func_70097_a(source, amount);
        }
        if (source.func_76346_g() instanceof EntityLivingBase) {
            new ActionTeleport().performAction(this, (EntityLivingBase)source.func_76346_g());
            this.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f + ModRandom.getFloat(0.2f));
            this.func_70604_c((EntityLivingBase)source.func_76346_g());
            --this.hits;
        }
        return false;
    }

    public void func_70645_a(DamageSource cause) {
        this.field_70170_p.func_72960_a((Entity)this, this.deathParticleByte);
        this.func_70107_b(0.0, 0.0, 0.0);
        this.func_70106_y();
        super.func_70645_a(cause);
    }

    public void func_82196_d(EntityLivingBase target, float distanceFactor) {
        this.attackHandler.getCurrentAttackAction().performAction(this, target);
    }

    protected void func_180481_a(DifficultyInstance difficulty) {
        this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(ItemSword.func_111206_d((String)"diamond_sword")));
        this.func_184201_a(EntityEquipmentSlot.OFFHAND, new ItemStack(ItemSword.func_111206_d((String)"diamond_sword")));
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        IEntityLivingData ientitylivingdata = super.func_180482_a(difficulty, livingdata);
        this.func_180481_a(difficulty);
        this.func_180483_b(difficulty);
        return ientitylivingdata;
    }

    public void func_184724_a(boolean swingingArms) {
        this.field_70180_af.func_187227_b(SWINGING_ARMS, (Object)swingingArms);
        if (swingingArms) {
            float melee_distance;
            float distance = (float)this.func_70092_e(this.func_70638_az().field_70165_t, this.func_70638_az().func_174813_aQ().field_72338_b, this.func_70638_az().field_70161_v);
            if ((double)distance > Math.pow(melee_distance = 4.0f, 2.0)) {
                this.attackHandler.setCurrentAttack(this.field_70146_Z.nextInt(2) == 0 ? (byte)6 : 5);
            } else {
                this.attackHandler.setCurrentAttack((byte)4);
                if (this.func_70638_az() != null) {
                    Vec3d dir = this.func_70638_az().func_174791_d().func_178788_d(this.func_174791_d()).func_72432_b();
                    Vec3d leap = new Vec3d(dir.field_72450_a, 0.0, dir.field_72449_c).func_72432_b().func_186678_a((double)0.4f).func_178787_e(ModUtils.yVec(0.3f));
                    this.field_70159_w += leap.field_72450_a;
                    if (this.field_70181_x < 0.1) {
                        this.field_70181_x += leap.field_72448_b;
                    }
                    this.field_70179_y += leap.field_72449_c;
                }
            }
            this.field_70170_p.func_72960_a((Entity)this, this.attackHandler.getCurrentAttack());
            if (this.attackHandler.getCurrentAttack() == 6) {
                this.field_70181_x = 0.7f;
                this.field_70143_R = -4.0f;
            }
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.markedToDespawn) {
            this.func_70106_y();
        }
        if (!this.field_70170_p.field_72995_K && this.isSwingingArms() && this.attackHandler.getCurrentAttack() == 6) {
            this.field_70170_p.func_72960_a((Entity)this, this.fireballParticleByte);
        } else {
            this.field_70170_p.func_72960_a((Entity)this, this.passiveParticleByte);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id >= 4 && id <= 6) {
            this.currentAnimation = this.attackHandler.getAnimation(id);
            this.getCurrentAnimation().startAnimation();
        } else if (id == this.passiveParticleByte) {
            if (this.field_70146_Z.nextInt(2) == 0) {
                ParticleManager.spawnEffect(this.field_70170_p, ModUtils.entityPos((Entity)this).func_178787_e(ModRandom.randVec().func_186678_a(1.5)).func_178787_e(new Vec3d(0.0, 1.0, 0.0)), ModColors.AZURE);
            }
        } else if (id == this.deathParticleByte) {
            int particleAmount = 100;
            for (int i = 0; i < particleAmount; ++i) {
                ParticleManager.spawnEffect(this.field_70170_p, ModUtils.entityPos((Entity)this).func_178787_e(ModRandom.randVec().func_186678_a(2.0)).func_178787_e(new Vec3d(0.0, 1.0, 0.0)), ModColors.AZURE);
            }
        } else if (id == this.fireballParticleByte) {
            int fireballParticles = 5;
            for (int i = 0; i < fireballParticles; ++i) {
                Vec3d pos = new Vec3d((double)ModRandom.getFloat(0.5f), (double)(this.func_70047_e() + 1.0f), (double)ModRandom.getFloat(0.5f)).func_178787_e(ModUtils.entityPos((Entity)this));
                ParticleManager.spawnCustomSmoke(this.field_70170_p, pos, ProjectileFireball.FIREBALL_COLOR, Vec3d.field_186680_a);
            }
        } else if (id == 9) {
            Vec3d color = new Vec3d(0.5, 0.2, 0.3);
            float particleHeight = 1.2f;
            for (float r = 0.5f; r <= 2.0f; r += 0.5f) {
                for (float sector = 0.0f; sector < 360.0f; sector += 10.0f) {
                    Vec3d pos = new Vec3d(Math.cos(sector) * (double)r, (double)particleHeight, Math.sin(sector) * (double)r).func_178787_e(ModUtils.entityPos((Entity)this));
                    ParticleManager.spawnEffect(this.field_70170_p, pos, ModColors.AZURE);
                }
            }
        } else {
            super.func_70103_a(id);
        }
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public void func_70037_a(NBTTagCompound compound) {
        this.markedToDespawn = true;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SWINGING_ARMS, (Object)false);
    }

    public boolean isSwingingArms() {
        return (Boolean)this.field_70180_af.func_187225_a(SWINGING_ARMS);
    }
}

