/*
 * Decompiled with CFR 0.152.
 */
package com.barribob.MaelstromMod.entity.entities;

import com.barribob.MaelstromMod.Main;
import com.barribob.MaelstromMod.entity.ai.EntityAITimedAttack;
import com.barribob.MaelstromMod.entity.entities.EntityMaelstromMob;
import com.barribob.MaelstromMod.entity.projectile.ProjectileChaosFireball;
import com.barribob.MaelstromMod.entity.util.DirectionalRender;
import com.barribob.MaelstromMod.entity.util.IAttack;
import com.barribob.MaelstromMod.init.ModBBAnimations;
import com.barribob.MaelstromMod.packets.MessageDirectionForRender;
import com.barribob.MaelstromMod.renderer.ITarget;
import com.barribob.MaelstromMod.util.ModColors;
import com.barribob.MaelstromMod.util.ModDamageSource;
import com.barribob.MaelstromMod.util.ModRandom;
import com.barribob.MaelstromMod.util.ModUtils;
import com.barribob.MaelstromMod.util.handlers.LootTableHandler;
import com.barribob.MaelstromMod.util.handlers.ParticleManager;
import com.barribob.MaelstromMod.util.handlers.SoundsHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.BossInfo;
import net.minecraft.world.BossInfoServer;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class EntityChaosKnight
extends EntityMaelstromMob
implements IAttack,
DirectionalRender,
ITarget {
    private final BossInfoServer bossInfo = new BossInfoServer(this.func_145748_c_(), BossInfo.Color.RED, BossInfo.Overlay.NOTCHED_6);
    private Vec3d chargeDir;
    private static final float dashRadius = 2.0f;
    private Consumer<EntityLivingBase> prevAttack;
    private final Consumer<EntityLivingBase> sideSwipe = target -> {
        ModBBAnimations.animation((EntityLivingBase)this, "chaos_knight.single_slash", false);
        this.addEvent(() -> {
            float distance = this.func_70032_d((Entity)target);
            if (distance > 2.0f) {
                ModUtils.leapTowards((EntityLivingBase)this, target.func_174791_d(), (float)(0.45 * Math.sqrt(distance)), 0.5f);
            }
        }, 5);
        this.addEvent(() -> {
            Vec3d offset = this.func_174791_d().func_178787_e(ModUtils.getRelativeOffset((EntityLivingBase)this, new Vec3d(0.5, 1.0, -1.0)));
            DamageSource source = ModDamageSource.builder().type("mm:mobMaelstrom").directEntity((Entity)this).element(this.getElement()).disablesShields().build();
            float damage = this.getAttack() * this.getConfigFloat("single_swipe_damage");
            ModUtils.handleAreaImpact(2.0f, e -> Float.valueOf(damage), (Entity)this, offset, source, 0.5f, 0, false);
            this.swipeBlocks();
            this.func_184185_a(SoundEvents.field_187730_dW, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
            Vec3d away = this.func_174791_d().func_178788_d(target.func_174791_d()).func_72432_b();
            ModUtils.leapTowards((EntityLivingBase)this, away, 0.4f, 0.4f);
        }, 18);
        this.addEvent(() -> EntityChaosKnight.super.func_184724_a(false), 35);
    };
    private final Consumer<EntityLivingBase> leapSlam = target -> {
        ModBBAnimations.animation((EntityLivingBase)this, "chaos_knight.leap_slam", false);
        this.addEvent(() -> {
            ModUtils.leapTowards((EntityLivingBase)this, target.func_174791_d(), (float)((double)0.45f * Math.sqrt(this.func_70032_d((Entity)target))), 0.9f);
            this.setLeaping(true);
        }, 20);
        this.addEvent(() -> {
            DamageSource source = ModDamageSource.builder().type("mm:explosionMaelstrom.player").directEntity((Entity)this).element(this.getElement()).stoppedByArmorNotShields().build();
            Vec3d pos = this.func_174791_d().func_178787_e(ModUtils.getRelativeOffset((EntityLivingBase)this, new Vec3d(1.0, 0.0, 0.0)));
            float damage = this.getAttack() * this.getConfigFloat("leap_slam_damage");
            ModUtils.handleAreaImpact(3.0f, e -> Float.valueOf(damage), (Entity)this, pos, source);
            this.field_70170_p.func_72885_a((Entity)this, pos.field_72450_a, pos.field_72448_b + 1.0, pos.field_72449_c, (float)this.getMobConfig().getDouble("slam_explosion_strength"), false, true);
            this.field_70170_p.func_72960_a((Entity)this, ModUtils.PARTICLE_BYTE);
        }, 42);
        this.addEvent(() -> EntityChaosKnight.super.func_184724_a(false), 60);
    };
    private final Consumer<EntityLivingBase> dash = target -> {
        ModBBAnimations.animation((EntityLivingBase)this, "chaos_knight.dash", false);
        Vec3d targetPos = this.func_70638_az().func_174791_d().func_178787_e(ModUtils.yVec(1.0));
        Vec3d startPos = this.func_174791_d().func_178787_e(ModUtils.yVec(this.func_70047_e()));
        Vec3d dir = targetPos.func_178788_d(startPos).func_72432_b();
        AtomicReference<Vec3d> teleportPos = new AtomicReference<Vec3d>(targetPos);
        int maxDistance = 10;
        ModUtils.lineCallback(targetPos.func_178787_e(dir), targetPos.func_178787_e(dir.func_186678_a((double)maxDistance)), maxDistance * 2, (pos, i) -> {
            boolean safeLanding = ModUtils.cubePoints(0, -2, 0, 1, 0, 1).stream().anyMatch(off -> this.field_70170_p.func_180495_p(new BlockPos(pos.func_178787_e(off))).isSideSolid((IBlockAccess)this.field_70170_p, new BlockPos(pos.func_178787_e(off)).func_177977_b(), EnumFacing.UP));
            boolean notOpen = ModUtils.cubePoints(0, 1, 0, 1, 3, 1).stream().anyMatch(off -> this.field_70170_p.func_180495_p(new BlockPos(pos.func_178787_e(off))).func_191058_s());
            if (safeLanding && !notOpen) {
                teleportPos.set((Vec3d)pos);
            }
        });
        this.chargeDir = teleportPos.get();
        Main.network.sendToAllTracking((IMessage)new MessageDirectionForRender((Entity)this, this.chargeDir), (Entity)this);
        this.addEvent(() -> {
            this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, 2.0f, false);
            ModUtils.lineCallback(startPos, this.chargeDir, (int)Math.sqrt(this.chargeDir.func_178788_d(startPos).func_189985_c()), (vec, i) -> {
                DamageSource source = ModDamageSource.builder().type("mm:mobMaelstrom").directEntity((Entity)this).element(this.getElement()).stoppedByArmorNotShields().build();
                float damage = this.getAttack() * this.getConfigFloat("dash_damage");
                ModUtils.handleAreaImpact(2.0f, e -> Float.valueOf(damage), (Entity)this, vec, source, 0.3f, 5);
                ModUtils.destroyBlocksInAABB(this.func_174813_aQ().func_191194_a(this.func_174791_d().func_186678_a(-1.0)).func_191194_a(vec), this.field_70170_p, (Entity)this);
                this.field_70170_p.func_184134_a(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, SoundEvents.field_187752_dd, SoundCategory.HOSTILE, 1.0f, 1.0f + ModRandom.getFloat(0.1f), false);
            });
            this.func_70634_a(this.chargeDir.field_72450_a, this.chargeDir.field_72448_b, this.chargeDir.field_72449_c);
            this.field_70170_p.func_72960_a((Entity)this, ModUtils.SECOND_PARTICLE_BYTE);
            this.func_184185_a(SoundEvents.field_187754_de, 1.0f, 1.0f + ModRandom.getFloat(0.1f));
        }, 20);
        this.addEvent(() -> EntityChaosKnight.super.func_184724_a(false), 40);
    };
    private final Consumer<EntityLivingBase> spinSlash = target -> {
        ModBBAnimations.animation((EntityLivingBase)this, "chaos_knight.triple_slash", false);
        Runnable leap = () -> {
            ModUtils.leapTowards((EntityLivingBase)this, target.func_174791_d(), (float)((double)0.35f * Math.sqrt(this.func_70032_d((Entity)target))), 0.5f);
            this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(0.0);
        };
        Runnable meleeAttack = () -> {
            DamageSource source = ModDamageSource.builder().type("mm:mobMaelstrom").directEntity((Entity)this).element(this.getElement()).disablesShields().build();
            float damage = this.getAttack() * this.getConfigFloat("spin_slash_damage");
            ModUtils.handleAreaImpact(2.7f, e -> Float.valueOf(damage), (Entity)this, this.func_174791_d().func_178787_e(ModUtils.yVec(1.0)), source, 0.5f, 0, false);
            this.swipeBlocks();
            this.func_184185_a(SoundEvents.field_187730_dW, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
            this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
        };
        this.addEvent(leap, 10);
        this.addEvent(meleeAttack, 15);
        this.addEvent(leap, 23);
        this.addEvent(meleeAttack, 29);
        this.addEvent(leap, 34);
        this.addEvent(meleeAttack, 41);
        this.addEvent(() -> EntityChaosKnight.super.func_184724_a(false), 60);
    };
    private final Consumer<EntityLivingBase> summonMeteors = target -> {
        this.addEvent(() -> this.field_70181_x += 0.5, 3);
        ModBBAnimations.animation((EntityLivingBase)this, "chaos_knight.summon", false);
        for (int tick = 20; tick < 140; tick += 5) {
            this.addEvent(() -> {
                float damage = this.getAttack() * this.getConfigFloat("meteor_damage");
                ProjectileChaosFireball meteor = new ProjectileChaosFireball(this.field_70170_p, (EntityLivingBase)this, damage, null);
                Vec3d pos = new Vec3d((double)ModRandom.getFloat(10.0f), (double)ModRandom.getFloat(1.0f), (double)ModRandom.getFloat(10.0f)).func_178787_e(this.func_174791_d()).func_178787_e(ModUtils.yVec(13.0));
                Vec3d targetPos = new Vec3d((double)ModRandom.getFloat(5.0f), 0.0, (double)ModRandom.getFloat(5.0f)).func_178787_e(target.func_174791_d());
                Vec3d vel = targetPos.func_178788_d(pos).func_72432_b().func_186678_a(0.4);
                meteor.func_70107_b(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
                meteor.shoot((Entity)this, 90.0f, 0.0f, 0.0f, 0.0f, 0.0f);
                ModUtils.setEntityVelocity(meteor, vel);
                meteor.setTravelRange(20.0f);
                this.field_70170_p.func_72838_d((Entity)meteor);
            }, tick);
        }
        this.addEvent(() -> EntityChaosKnight.super.func_184724_a(false), 30);
        this.addEvent(() -> {
            this.field_70170_p.func_72960_a((Entity)this, ModUtils.THIRD_PARTICLE_BYTE);
            this.func_184185_a(SoundEvents.field_193784_dd, 1.0f, 1.0f * ModRandom.getFloat(0.2f));
        }, 12);
    };

    private void swipeBlocks() {
        double swipeWidth = this.getMobConfig().getDouble("swipe_width");
        AxisAlignedBB box = new AxisAlignedBB(this.func_180425_c()).func_72317_d(-0.5, 1.5, -0.5).func_72314_b(swipeWidth, 1.0, swipeWidth);
        ModUtils.destroyBlocksInAABB(box, this.field_70170_p, (Entity)this);
    }

    public EntityChaosKnight(World worldIn) {
        super(worldIn);
        this.setImmovable(true);
        this.func_70105_a(1.5f, 3.0f);
        this.healthScaledAttackFactor = 0.2;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
        if (!this.field_70170_p.field_72995_K && this.isLeaping()) {
            AxisAlignedBB box = this.func_174813_aQ().func_72314_b(0.25, 0.12, 0.25).func_72317_d(0.0, 0.12, 0.0);
            ModUtils.destroyBlocksInAABB(box, this.field_70170_p, (Entity)this);
        }
        if (this.field_70170_p.field_72995_K || this.field_70173_aa % 5 != 0) {
            return;
        }
        boolean hasGround = false;
        for (int i = 0; i > -10; --i) {
            if (this.field_70170_p.func_175623_d(this.func_180425_c().func_177971_a((Vec3i)new BlockPos(0, i, 0)))) continue;
            hasGround = true;
        }
        if (!hasGround && this.field_70181_x < -1.0) {
            this.setImmovable(true);
        } else if (this.isImmovable()) {
            this.setImmovable(false);
        }
    }

    @Override
    public int startAttack(EntityLivingBase target, float distanceFactor, boolean strafingBackwards) {
        float healthRatio = this.func_110143_aJ() / this.func_110138_aP();
        this.func_184724_a(true);
        double distance = Math.sqrt(distanceFactor);
        ArrayList<Consumer> attacks = new ArrayList<Consumer>(Arrays.asList(this.sideSwipe, this.leapSlam, this.dash, this.spinSlash, this.summonMeteors));
        double[] weights = new double[]{(1.0 - distance / 10.0) * (this.prevAttack != this.sideSwipe ? 1.5 : 1.0), 0.2 + 0.04 * distance, (double)healthRatio < 0.7 ? 0.2 + 0.04 * distance : 0.0, 0.5 - (this.prevAttack == this.spinSlash ? 0.3 : 0.0), this.prevAttack == this.summonMeteors || (double)healthRatio > 0.5 ? 0.0 : (double)(1.0f - healthRatio)};
        this.prevAttack = ModRandom.choice(attacks, this.field_70146_Z, weights).next();
        this.prevAttack.accept(target);
        return this.prevAttack == this.sideSwipe || this.prevAttack == this.summonMeteors ? 50 : 90 - (int)(10.0f * (1.0f - healthRatio));
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (amount > 0.0f && this.canBlockDamageSource(source)) {
            Entity entity;
            this.func_184590_k(amount);
            if (!source.func_76352_a() && (entity = source.func_76364_f()) instanceof EntityLivingBase) {
                this.func_190629_c((EntityLivingBase)entity);
            }
            this.func_184185_a(SoundsHandler.ENTITY_CHAOS_KNIGHT_BLOCK, 1.0f, 0.9f + ModRandom.getFloat(0.2f));
            return false;
        }
        return super.func_70097_a(source, amount);
    }

    private boolean canBlockDamageSource(DamageSource damageSourceIn) {
        Vec3d vec3d;
        if (!damageSourceIn.func_76363_c() && !this.isSwingingArms() && (vec3d = damageSourceIn.func_188404_v()) != null) {
            Vec3d vec3d1 = this.func_70676_i(1.0f);
            Vec3d vec3d2 = vec3d.func_72444_a(new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v)).func_72432_b();
            vec3d2 = new Vec3d(vec3d2.field_72450_a, 0.0, vec3d2.field_72449_c);
            return vec3d2.func_72430_b(vec3d1) < 0.0;
        }
        return false;
    }

    @Override
    protected ResourceLocation func_184647_J() {
        return LootTableHandler.CHAOSKNIGHT;
    }

    public float func_70047_e() {
        return this.field_70131_O * 0.8f;
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(4, new EntityAITimedAttack<EntityChaosKnight>(this, 1.0, 60, 15.0f, 0.5f));
    }

    @Override
    public void func_70103_a(byte id) {
        if (id == ModUtils.PARTICLE_BYTE) {
            for (int r = 1; r < 3; ++r) {
                ModUtils.circleCallback(r, r * 20, pos -> {
                    pos = new Vec3d(pos.field_72450_a, 0.0, pos.field_72448_b);
                    ParticleManager.spawnSplit(this.field_70170_p, pos.func_178787_e(this.func_174791_d().func_178787_e(ModUtils.getRelativeOffset((EntityLivingBase)this, new Vec3d(1.0, 0.0, 0.0))).func_178787_e(ModUtils.yVec(-1.5))), ModColors.RED, pos.func_186678_a((double)0.1f).func_178787_e(ModUtils.yVec(0.05f)));
                });
            }
        } else if (id == ModUtils.SECOND_PARTICLE_BYTE) {
            if (this.chargeDir != null) {
                Vec3d particleVel = this.chargeDir.func_178788_d(this.func_174791_d()).func_72432_b().func_186678_a(0.5);
                ModUtils.lineCallback(this.func_174791_d(), this.chargeDir, 20, (vec, i) -> ModUtils.performNTimes(10, j -> {
                    ParticleManager.spawnSplit(this.field_70170_p, vec.func_178787_e(ModRandom.randVec().func_186678_a(4.0)), ModColors.RED, particleVel.func_178787_e(ModRandom.randVec().func_186678_a((double)0.2f)));
                    ParticleManager.spawnCustomSmoke(this.field_70170_p, vec.func_178787_e(ModRandom.randVec().func_186678_a(4.0)), ModColors.GREY, particleVel.func_178787_e(ModRandom.randVec().func_186678_a((double)0.2f)));
                    Vec3d flamePos = vec.func_178787_e(ModRandom.randVec().func_186678_a(4.0));
                    Vec3d flameVel = particleVel.func_178787_e(ModRandom.randVec().func_186678_a((double)0.2f));
                    this.field_70170_p.func_175688_a(EnumParticleTypes.FLAME, flamePos.field_72450_a, flamePos.field_72448_b, flamePos.field_72449_c, flameVel.field_72450_a, flameVel.field_72448_b, flameVel.field_72449_c, new int[0]);
                }));
                this.chargeDir = null;
            }
        } else if (id == ModUtils.THIRD_PARTICLE_BYTE) {
            ModUtils.circleCallback(2.0f, 50, pos -> {
                pos = new Vec3d(pos.field_72450_a, 0.0, pos.field_72448_b);
                ParticleManager.spawnDust(this.field_70170_p, pos.func_178787_e(this.func_174791_d()).func_178787_e(ModUtils.yVec(5.0)), ModColors.RED, pos.func_72432_b().func_186678_a(0.3).func_178787_e(ModUtils.yVec(0.1)), ModRandom.range(20, 30));
            });
        }
        super.func_70103_a(id);
    }

    @Override
    public void setRenderDirection(Vec3d lazerDir) {
        this.chargeDir = lazerDir;
    }

    @Override
    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
    }

    public void func_70037_a(NBTTagCompound compound) {
        if (this.func_145818_k_()) {
            this.bossInfo.func_186739_a(this.func_145748_c_());
        }
        super.func_70037_a(compound);
    }

    public void func_96094_a(String name) {
        super.func_96094_a(name);
        this.bossInfo.func_186739_a(this.func_145748_c_());
    }

    public void func_184178_b(EntityPlayerMP player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(EntityPlayerMP player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }

    protected SoundEvent func_184639_G() {
        return SoundsHandler.ENTITY_CHAOS_KNIGHT_AMBIENT;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return SoundsHandler.ENTITY_CHAOS_KNIGHT_DEATH;
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundsHandler.ENTITY_CHAOS_KNIGHT_HURT;
    }

    @Override
    protected boolean func_70692_ba() {
        return false;
    }

    @Override
    protected void initAnimation() {
    }

    public void func_82196_d(EntityLivingBase target, float distanceFactor) {
    }

    public int func_70070_b() {
        return Math.min(super.func_70070_b() + 60, 200);
    }

    @Override
    public Optional<Vec3d> getTarget() {
        return Optional.ofNullable(this.chargeDir);
    }
}

