/*
 * Decompiled with CFR 0.152.
 */
package com.barribob.MaelstromMod.entity.animation;

import com.barribob.MaelstromMod.entity.animation.Animation;
import com.barribob.MaelstromMod.entity.animation.AnimationClip;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.model.ModelBase;

public class StreamAnimation<T extends ModelBase>
implements Animation<T> {
    private static final Map<String, List<List<AnimationClip>>> animationsCache = new HashMap<String, List<List<AnimationClip>>>();
    private final List<List<AnimationClip<T>>> animations;
    private int[] activeAnimations;
    private boolean loop = false;

    public StreamAnimation<T> loop(boolean loop) {
        this.loop = loop;
        return this;
    }

    public StreamAnimation(List<List<AnimationClip<T>>> animations) {
        this.animations = animations;
        this.activeAnimations = new int[animations.size()];
        for (int stream = 0; stream < animations.size(); ++stream) {
            this.activeAnimations[stream] = animations.get(stream).size() - 1;
        }
    }

    public static void initStaticAnimations(String csv) {
    }

    @Override
    public void startAnimation() {
        this.activeAnimations = new int[this.animations.size()];
        for (List<AnimationClip<T>> animationClips : this.animations) {
            for (AnimationClip<T> clip : animationClips) {
                clip.startAnimation();
            }
        }
    }

    @Override
    public void update() {
        for (int stream = 0; stream < this.animations.size(); ++stream) {
            if (this.animations.get(stream).size() <= 0) continue;
            AnimationClip<T> currentClip = this.animations.get(stream).get(this.activeAnimations[stream]);
            currentClip.update();
            if (!currentClip.isEnded()) continue;
            if (this.activeAnimations[stream] < this.animations.get(stream).size() - 1) {
                int n = stream;
                this.activeAnimations[n] = this.activeAnimations[n] + 1;
                continue;
            }
            if (!this.loop) continue;
            this.startAnimation();
        }
    }

    @Override
    public void setModelRotations(T model, float limbSwing, float limbSwingAmount, float partialTicks) {
        for (int stream = 0; stream < this.animations.size(); ++stream) {
            if (this.animations.get(stream).size() <= 0) continue;
            this.animations.get(stream).get(this.activeAnimations[stream]).setModelRotations(model, limbSwing, limbSwingAmount, partialTicks);
        }
    }

    public static class AnimationData {
        public String[] movers;
        public List<int[]> animations;
        public int numStreams;

        public AnimationData() {
        }

        public AnimationData(String[] movers, List<int[]> animations, int numStreams) {
            this.movers = movers;
            this.animations = animations;
            this.numStreams = numStreams;
        }
    }
}

