/*
 * Decompiled with CFR 0.152.
 */
package com.barribob.MaelstromMod.entity.animation;

import com.barribob.MaelstromMod.entity.animation.BBAnimation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber(value={Side.CLIENT})
@SideOnly(value=Side.CLIENT)
public class AnimationManager {
    private static final Map<EntityLivingBase, Map<String, BBAnimation>> animations = new HashMap<EntityLivingBase, Map<String, BBAnimation>>();
    private static final Map<ModelBase, Map<ModelRenderer, float[]>> defaultModelValues = new HashMap<ModelBase, Map<ModelRenderer, float[]>>();
    private static final Map<EntityLivingBase, Set<String>> animationsToRemoveOnceEnded = new HashMap<EntityLivingBase, Set<String>>();

    public static void updateAnimation(EntityLivingBase entity, String animationId, boolean remove) {
        if (remove) {
            AnimationManager.removeAnimation(entity, animationId);
            return;
        }
        if (!animations.containsKey(entity)) {
            animations.put(entity, new HashMap());
        }
        if (!animations.get(entity).containsKey(animationId)) {
            animations.get(entity).put(animationId, new BBAnimation(animationId));
        }
        animations.get(entity).get(animationId).startAnimation();
    }

    private static void removeAnimation(EntityLivingBase entity, String animationId) {
        if (animations.containsKey(entity) && animations.get(entity).containsKey(animationId)) {
            BBAnimation animation = animations.get(entity).get(animationId);
            if (animation.isLoop()) {
                AnimationManager.scheduleLoopingAnimationStop(entity, animationId);
            } else {
                animations.get(entity).remove(animationId);
            }
        }
    }

    private static void scheduleLoopingAnimationStop(EntityLivingBase entity, String animationId) {
        if (!animationsToRemoveOnceEnded.containsKey(entity)) {
            animationsToRemoveOnceEnded.put(entity, new HashSet());
        }
        animationsToRemoveOnceEnded.get(entity).add(animationId);
    }

    private static void removeEndedSheduledEndedLoopingAnimations(EntityLivingBase entity, Map<String, BBAnimation> animations, float partialTicks) {
        if (animationsToRemoveOnceEnded.containsKey(entity)) {
            for (String animationId : animationsToRemoveOnceEnded.get(entity)) {
                BBAnimation animation = animations.get(animationId);
                if (animation == null || !animation.isLoop() || !animation.isAtAnimationEnd(partialTicks)) continue;
                animations.remove(animationId);
                animationsToRemoveOnceEnded.get(entity).remove(animationId);
            }
        }
    }

    public static void updateLoopingAnimation(EntityLivingBase entity, String animationId) {
        if (!animations.containsKey(entity)) {
            animations.put(entity, new HashMap());
        }
        if (!animations.get(entity).containsKey(animationId)) {
            animations.get(entity).put(animationId, new BBAnimation(animationId));
        }
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END && !Minecraft.func_71410_x().func_147113_T()) {
            ArrayList<EntityLivingBase> entitiesToRemove = new ArrayList<EntityLivingBase>();
            for (Map.Entry<EntityLivingBase, Map<String, BBAnimation>> entry : animations.entrySet()) {
                EntityLivingBase entity = entry.getKey();
                if (!entity.isAddedToWorld() && entity.field_70128_L) {
                    entitiesToRemove.add(entity);
                    continue;
                }
                if (entity.func_110143_aJ() <= 0.0f) continue;
                ArrayList<String> animsToRemove = new ArrayList<String>();
                Map<String, BBAnimation> animationMap = entry.getValue();
                for (Map.Entry<String, BBAnimation> kv : animationMap.entrySet()) {
                    if (kv.getValue().isEnded()) {
                        animsToRemove.add(kv.getKey());
                        continue;
                    }
                    kv.getValue().update();
                }
                for (String id : animsToRemove) {
                    animationMap.remove(id);
                }
            }
            for (EntityLivingBase entity : entitiesToRemove) {
                animations.remove(entity);
            }
        }
    }

    public static void resetModel(ModelBase model) {
        if (defaultModelValues.containsKey(model)) {
            for (ModelRenderer renderer : model.field_78092_r) {
                float[] values = defaultModelValues.get(model).get(renderer);
                renderer.field_78795_f = values[0];
                renderer.field_78796_g = values[1];
                renderer.field_78808_h = values[2];
                renderer.field_82906_o = values[3];
                renderer.field_82908_p = values[4];
                renderer.field_82907_q = values[5];
                renderer.field_78800_c = values[6];
                renderer.field_78797_d = values[7];
                renderer.field_78798_e = values[8];
            }
        } else {
            defaultModelValues.put(model, new HashMap());
            for (ModelRenderer renderer : model.field_78092_r) {
                defaultModelValues.get(model).put(renderer, new float[]{renderer.field_78795_f, renderer.field_78796_g, renderer.field_78808_h, renderer.field_82906_o, renderer.field_82908_p, renderer.field_82907_q, renderer.field_78800_c, renderer.field_78797_d, renderer.field_78798_e});
            }
        }
    }

    public static void setModelRotations(ModelBase model, EntityLivingBase entity, float limbSwing, float limbSwingAmount, float partialTicks) {
        if (animations.containsKey(entity)) {
            for (BBAnimation animation : animations.get(entity).values()) {
                animation.setModelRotations(model, limbSwing, limbSwingAmount, entity.func_110143_aJ() <= 0.0f ? 0.0f : partialTicks);
            }
            AnimationManager.removeEndedSheduledEndedLoopingAnimations(entity, animations.get(entity), partialTicks);
        }
    }
}

