/*
 * Decompiled with CFR 0.152.
 */
package com.barribob.MaelstromMod.entity.animation;

import com.barribob.MaelstromMod.entity.animation.ArrayAnimation;
import com.barribob.MaelstromMod.entity.model.ModelAzureGolem;

public class AnimationAzureGolem
extends ArrayAnimation<ModelAzureGolem> {
    private static final float[] armFramesDegrees = new float[]{-45.0f, -60.0f, -75.0f, -90.0f, -105.0f, -120.0f, -135.0f, -150.0f, -165.0f, -180.0f, -180.0f, -180.0f, -180.0f, -165.0f, -135.0f, -105.0f, -90.0f, -90.0f, -90.0f, -90.0f, -90.0f, -75.0f, -60.0f, -45.0f, -30.0f, -15.0f, 0.0f};
    private static final float[] backFramesDegrees = new float[]{0.0f, 0.0f, 0.0f, 0.0f, -5.0f, -15.0f, -15.0f, -15.0f, -15.0f, -15.0f, -15.0f, 0.0f, 15.0f, 30.0f, 45.0f, 55.0f, 65.0f, 65.0f, 65.0f, 65.0f, 65.0f, 50.0f, 40.0f, 30.0f, 20.0f, 10.0f, 0.0f};

    public AnimationAzureGolem() {
        super(armFramesDegrees.length);
    }

    @Override
    public void setModelRotations(ModelAzureGolem model, float limbSwing, float limbSwingAmount, float partialTicks) {
        float armsRotationX = (float)Math.toRadians(this.getInterpolatedFrame(armFramesDegrees, partialTicks));
        float waistRotationX = (float)Math.toRadians(this.getInterpolatedFrame(backFramesDegrees, partialTicks));
        if (armsRotationX == 0.0f) {
            model.rightBicep.field_78795_f = (-0.2f + model.limbSwingFactor * this.triangleWave(limbSwing, 13.0f)) * limbSwingAmount;
            model.leftBicep.field_78795_f = (-0.2f - model.limbSwingFactor * this.triangleWave(limbSwing, 13.0f)) * limbSwingAmount;
        } else {
            model.rightBicep.field_78795_f = armsRotationX;
            model.leftBicep.field_78795_f = armsRotationX;
        }
        model.waist.field_78795_f = waistRotationX;
        model.waist.field_78808_h = 0.0f;
    }

    private float triangleWave(float p_78172_1_, float p_78172_2_) {
        return (Math.abs(p_78172_1_ % p_78172_2_ - p_78172_2_ * 0.5f) - p_78172_2_ * 0.25f) / (p_78172_2_ * 0.25f);
    }
}

