/*
 * Decompiled with CFR 0.152.
 */
package com.barribob.MaelstromMod.entity.ai;

import com.barribob.MaelstromMod.entity.util.IAttack;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;

public class EntityAITimedAttack<T extends EntityLiving>
extends EntityAIBase {
    private final T entity;
    private final double moveSpeedAmp;
    private final int attackCooldown;
    private final float maxAttackDistSq;
    private int attackTime;
    private boolean strafingClockwise;
    private boolean strafingBackwards;
    private int strafingTime = -1;
    private final float strafeAmount;
    private final float lookSpeed;
    private static final float STRAFING_STOP_FACTOR = 0.75f;
    private static final float STRAFING_BACKWARDS_FACTOR = 0.25f;
    private static final float STRAFING_DIRECTION_TICK = 20.0f;
    private static final float STRAFING_DIRECTION_CHANGE_CHANCE = 0.3f;

    public EntityAITimedAttack(T entity, double moveSpeedAmp, int attackCooldown, float maxAttackDistance, float strafeAmount) {
        this(entity, moveSpeedAmp, attackCooldown, maxAttackDistance, strafeAmount, 30.0f);
    }

    public EntityAITimedAttack(T entity, double moveSpeedAmp, int attackCooldown, float maxAttackDistance, float strafeAmount, float lookSpeed) {
        this.entity = entity;
        this.moveSpeedAmp = moveSpeedAmp;
        this.attackCooldown = attackCooldown;
        this.maxAttackDistSq = maxAttackDistance * maxAttackDistance;
        this.strafeAmount = strafeAmount;
        this.attackTime = attackCooldown;
        this.lookSpeed = lookSpeed;
        this.func_75248_a(3);
    }

    public boolean func_75250_a() {
        return this.entity.func_70638_az() != null;
    }

    public boolean func_75253_b() {
        return this.func_75250_a() || !this.entity.func_70661_as().func_75500_f();
    }

    public void func_75251_c() {
        super.func_75251_c();
        this.attackTime = Math.max(this.attackTime, this.attackCooldown);
    }

    public void func_75246_d() {
        EntityLivingBase target = this.entity.func_70638_az();
        if (target == null) {
            return;
        }
        double distSq = this.entity.func_70092_e(target.field_70165_t, target.func_174813_aQ().field_72338_b, target.field_70161_v);
        boolean canSee = this.entity.func_70635_at().func_75522_a((Entity)target);
        this.move(target, distSq, canSee);
        if (distSq <= (double)this.maxAttackDistSq && canSee) {
            --this.attackTime;
            if (this.attackTime <= 0) {
                this.attackTime = ((IAttack)this.entity).startAttack(target, (float)distSq, this.strafingBackwards);
            }
        }
    }

    public void move(EntityLivingBase target, double distSq, boolean canSee) {
        if (distSq <= (double)this.maxAttackDistSq && canSee) {
            this.entity.func_70661_as().func_75499_g();
            ++this.strafingTime;
        } else {
            this.entity.func_70661_as().func_75497_a((Entity)target, this.moveSpeedAmp);
            this.strafingTime = -1;
        }
        if ((float)this.strafingTime >= 20.0f) {
            if ((double)this.entity.func_70681_au().nextFloat() < (double)0.3f) {
                boolean bl = this.strafingClockwise = !this.strafingClockwise;
            }
            if ((double)this.entity.func_70681_au().nextFloat() < (double)0.3f) {
                this.strafingBackwards = !this.strafingBackwards;
            }
            this.strafingTime = 0;
        }
        if (this.strafingTime > -1) {
            if (distSq > (double)(this.maxAttackDistSq * 0.75f)) {
                this.strafingBackwards = false;
            } else if (distSq < (double)(this.maxAttackDistSq * 0.25f)) {
                this.strafingBackwards = true;
            }
            this.entity.func_70605_aq().func_188488_a((float)(this.strafingBackwards ? -1 : 1) * this.strafeAmount, (float)(this.strafingClockwise ? 1 : -1) * this.strafeAmount);
            this.entity.func_70625_a((Entity)target, this.lookSpeed, this.lookSpeed);
        } else {
            this.entity.func_70671_ap().func_75651_a((Entity)target, this.lookSpeed, this.lookSpeed);
        }
    }
}

