/*
 * Decompiled with CFR 0.152.
 */
package com.barribob.MaelstromMod.entity.ai;

import com.barribob.MaelstromMod.util.ModRandom;
import com.barribob.MaelstromMod.util.ModUtils;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;

public class AIPassiveCircle<T extends EntityLiving>
extends EntityAIBase {
    private final T entity;
    @Nullable
    private Vec3d planeVectorPath = this.getNewPlaneVector();
    private final float circleRadius;

    public AIPassiveCircle(T entity, float circleRadius) {
        this.entity = entity;
        this.circleRadius = circleRadius;
        this.func_75248_a(3);
    }

    public boolean func_75250_a() {
        return this.entity.func_70638_az() != null;
    }

    public void func_75246_d() {
        if (this.entity.func_70638_az() != null) {
            Vec3d target = this.entity.func_70638_az().func_174791_d();
            Vec3d nextPointToFollow = this.getNextPoint(target);
            Vec3d direction = nextPointToFollow.func_178788_d(this.entity.func_174791_d()).func_72432_b();
            double speed = this.entity.func_110148_a(SharedMonsterAttributes.field_193334_e).func_111126_e();
            ModUtils.addEntityVelocity(this.entity, direction.func_186678_a((double)0.05f * speed));
            if (!this.hasClearPath(nextPointToFollow) || this.lineBlocked(nextPointToFollow, target)) {
                this.planeVectorPath = this.getNewPlaneVector();
            }
            ModUtils.facePosition(nextPointToFollow, this.entity, 10.0f, 10.0f);
            this.entity.func_70671_ap().func_75650_a(nextPointToFollow.field_72450_a, nextPointToFollow.field_72448_b, nextPointToFollow.field_72449_c, 3.0f, 3.0f);
        }
        super.func_75246_d();
    }

    private Vec3d getNewPlaneVector() {
        return ModUtils.Y_AXIS.func_178787_e(ModRandom.randVec().func_186678_a(2.0)).func_72432_b();
    }

    private boolean hasClearPath(Vec3d nextPointToFollow) {
        return ModUtils.getBoundingBoxCorners(this.entity.func_174813_aQ()).stream().noneMatch(vec3d -> this.lineBlocked((Vec3d)vec3d, nextPointToFollow));
    }

    private boolean lineBlocked(Vec3d start, Vec3d nextPointToFollow) {
        RayTraceResult rayTraceResult = ((EntityLiving)this.entity).field_70170_p.func_147447_a(start, nextPointToFollow, false, true, false);
        return rayTraceResult != null && rayTraceResult.field_72313_a == RayTraceResult.Type.BLOCK;
    }

    private Vec3d getNextPoint(Vec3d center) {
        Vec3d circlePointInWorld = this.entity.func_174791_d().func_178787_e(ModRandom.randVec());
        int i = 0;
        while ((float)i < this.circleRadius) {
            for (int sign : new int[]{1, -1}) {
                Vec3d entityVelocity = ModUtils.getEntityVelocity(this.entity);
                Vec3d entityDirection = this.entity.func_174791_d().func_178788_d(center);
                Vec3d projectedEntityDirection = ModUtils.planeProject(entityDirection, this.planeVectorPath).func_72432_b().func_186678_a((double)(this.circleRadius + (float)(i * sign)));
                Vec3d nextPointOnCircle = ModUtils.rotateVector2(projectedEntityDirection, this.planeVectorPath, 15.0 * entityVelocity.func_72433_c());
                circlePointInWorld = nextPointOnCircle.func_178787_e(center);
                if (this.hasClearPath(circlePointInWorld)) {
                    return circlePointInWorld;
                }
                this.planeVectorPath = this.getNewPlaneVector();
            }
            ++i;
        }
        return circlePointInWorld;
    }
}

