/*
 * Decompiled with CFR 0.152.
 */
package com.barribob.MaelstromMod.entity.ai;

import com.barribob.MaelstromMod.util.ModUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;

public class AIFuryDive
extends EntityAIBase {
    private int cooldown;
    private final int maxCooldown;
    private final EntityLiving entity;
    private final Runnable onDiveStart;
    private final Runnable onDiveEnd;
    private final Runnable whileDiving;
    private final int maxDiveTime;

    public AIFuryDive(int maxCooldown, int maxDiveTime, EntityLiving entity, Runnable onDiveStart, Runnable onDiveEnd, Runnable whileDiving) {
        this.maxCooldown = maxCooldown;
        this.entity = entity;
        this.onDiveEnd = onDiveEnd;
        this.onDiveStart = onDiveStart;
        this.whileDiving = whileDiving;
        this.maxDiveTime = maxDiveTime;
        this.func_75248_a(3);
    }

    public boolean func_75250_a() {
        ++this.cooldown;
        return this.func_75253_b() && this.entity.func_70638_az() != null && this.entity.func_70638_az().func_70040_Z().func_72430_b(this.entity.func_174791_d().func_178788_d(this.entity.func_70638_az().func_174824_e(1.0f))) < 0.0;
    }

    public boolean func_75253_b() {
        return this.cooldown >= this.maxCooldown && this.entity.func_70638_az() != null && this.hasClearPath(this.entity.func_70638_az().func_174824_e(1.0f));
    }

    public void func_75249_e() {
        this.onDiveStart.run();
        this.cooldown = this.maxCooldown;
    }

    private boolean hasClearPath(Vec3d nextPointToFollow) {
        return ModUtils.getBoundingBoxCorners(this.entity.func_174813_aQ()).stream().noneMatch(vec3d -> {
            RayTraceResult rayTraceResult = this.entity.field_70170_p.func_147447_a(vec3d, nextPointToFollow, true, true, false);
            return rayTraceResult != null && rayTraceResult.field_72313_a == RayTraceResult.Type.BLOCK;
        });
    }

    public void func_75251_c() {
        this.cooldown = 0;
        this.onDiveEnd.run();
    }

    public void func_75246_d() {
        this.dive();
    }

    public void dive() {
        if (this.entity.func_70638_az() != null) {
            boolean diveInCriteria;
            ++this.cooldown;
            Vec3d target = this.entity.func_70638_az().func_174824_e(1.0f);
            Vec3d pos = this.entity.func_174791_d();
            Vec3d toTarget = target.func_178788_d(pos);
            Vec3d directionToTarget = toTarget.func_72432_b();
            double speed = this.entity.func_110148_a(SharedMonsterAttributes.field_193334_e).func_111126_e();
            double speedForDistance = ModUtils.clamp(toTarget.func_72433_c() / 20.0, 1.0, 1.5);
            Vec3d velocityCorrection = ModUtils.planeProject(ModUtils.getEntityVelocity((Entity)this.entity), directionToTarget);
            ModUtils.addEntityVelocity((Entity)this.entity, directionToTarget.func_178788_d(velocityCorrection).func_186678_a(0.055 * speed * speedForDistance));
            Vec3d lookTarget = pos.func_178787_e(directionToTarget);
            ModUtils.facePosition(lookTarget, (Entity)this.entity, 10.0f, 10.0f);
            this.entity.func_70671_ap().func_75650_a(lookTarget.field_72450_a, lookTarget.field_72448_b, lookTarget.field_72449_c, 3.0f, 3.0f);
            this.whileDiving.run();
            double hitboxCompensation = this.entity.func_174813_aQ().func_72320_b() * 0.5 + this.entity.func_70638_az().func_174813_aQ().func_72320_b() * 0.5;
            boolean bl = diveInCriteria = target.func_72436_e(pos) < Math.pow(hitboxCompensation + 1.5, 2.0) || this.entity.field_70132_H;
            if (diveInCriteria || !this.hasClearPath(target) || this.cooldown - this.maxCooldown > this.maxDiveTime) {
                this.func_75251_c();
            }
        }
    }
}

