/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.dimensions.world.driver;

import java.util.Objects;
import mcjty.lostcities.dimensions.world.driver.IIndex;
import mcjty.lostcities.dimensions.world.driver.IPrimerDriver;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.world.chunk.ChunkPrimer;

public class SafeDriver
implements IPrimerDriver {
    private ChunkPrimer primer;
    private int currentX;
    private int currentY;
    private int currentZ;

    @Override
    public void setPrimer(ChunkPrimer primer) {
        this.primer = primer;
    }

    @Override
    public ChunkPrimer getPrimer() {
        return this.primer;
    }

    @Override
    public IPrimerDriver current(int x, int y, int z) {
        this.currentX = x;
        this.currentY = y;
        this.currentZ = z;
        return this;
    }

    @Override
    public IPrimerDriver current(IIndex index) {
        Index i = (Index)index;
        this.currentX = i.x;
        this.currentY = i.y;
        this.currentZ = i.z;
        return this;
    }

    @Override
    public IIndex getCurrent() {
        return new Index(this.currentX, this.currentY, this.currentZ);
    }

    @Override
    public void incY() {
        ++this.currentY;
    }

    @Override
    public void incY(int amount) {
        this.currentY += amount;
    }

    @Override
    public void decY() {
        --this.currentY;
    }

    @Override
    public void incX() {
        ++this.currentX;
    }

    @Override
    public void incZ() {
        ++this.currentZ;
    }

    @Override
    public int getX() {
        return this.currentX;
    }

    @Override
    public int getY() {
        return this.currentY;
    }

    @Override
    public int getZ() {
        return this.currentZ;
    }

    @Override
    public void setBlockRange(int x, int y, int z, int y2, char c) {
        IBlockState state = (IBlockState)Block.field_176229_d.func_148745_a((int)c);
        while (y < y2) {
            this.primer.func_177855_a(x, y, z, state);
            ++y;
        }
    }

    @Override
    public void setBlockRangeSafe(int x, int y, int z, int y2, char c) {
        IBlockState state = (IBlockState)Block.field_176229_d.func_148745_a((int)c);
        while (y < y2) {
            this.primer.func_177855_a(x, y, z, state);
            ++y;
        }
    }

    @Override
    public IPrimerDriver block(char c) {
        IBlockState state = (IBlockState)Block.field_176229_d.func_148745_a((int)c);
        this.primer.func_177855_a(this.currentX, this.currentY, this.currentZ, state);
        return this;
    }

    @Override
    public IPrimerDriver block(IBlockState c) {
        this.primer.func_177855_a(this.currentX, this.currentY, this.currentZ, c);
        return this;
    }

    @Override
    public IPrimerDriver add(char c) {
        IBlockState state = (IBlockState)Block.field_176229_d.func_148745_a((int)c);
        this.primer.func_177855_a(this.currentX, this.currentY++, this.currentZ, state);
        return this;
    }

    @Override
    public char getBlock() {
        return (char)Block.field_176229_d.func_148747_b((Object)this.primer.func_177856_a(this.currentX, this.currentY, this.currentZ));
    }

    @Override
    public char getBlockDown() {
        return (char)Block.field_176229_d.func_148747_b((Object)this.primer.func_177856_a(this.currentX, this.currentY - 1, this.currentZ));
    }

    @Override
    public char getBlockEast() {
        return (char)Block.field_176229_d.func_148747_b((Object)this.primer.func_177856_a(this.currentX + 1, this.currentY, this.currentZ));
    }

    @Override
    public char getBlockWest() {
        return (char)Block.field_176229_d.func_148747_b((Object)this.primer.func_177856_a(this.currentX - 1, this.currentY, this.currentZ));
    }

    @Override
    public char getBlockSouth() {
        return (char)Block.field_176229_d.func_148747_b((Object)this.primer.func_177856_a(this.currentX, this.currentY, this.currentZ + 1));
    }

    @Override
    public char getBlockNorth() {
        return (char)Block.field_176229_d.func_148747_b((Object)this.primer.func_177856_a(this.currentX, this.currentY, this.currentZ - 1));
    }

    @Override
    public char getBlock(int x, int y, int z) {
        return (char)Block.field_176229_d.func_148747_b((Object)this.primer.func_177856_a(x, y, z));
    }

    @Override
    public IIndex getIndex(int x, int y, int z) {
        return new Index(x, y, z);
    }

    @Override
    public IPrimerDriver copy() {
        SafeDriver driver = new SafeDriver();
        driver.currentX = this.currentX;
        driver.currentY = this.currentY;
        driver.currentZ = this.currentZ;
        driver.primer = this.primer;
        return driver;
    }

    private class Index
    implements IIndex {
        private final int x;
        private final int y;
        private final int z;

        Index(int x, int y, int z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Index index = (Index)o;
            return this.x == index.x && this.y == index.y && this.z == index.z;
        }

        public int hashCode() {
            return Objects.hash(this.x, this.y, this.z);
        }
    }
}

