/*
 * Decompiled with CFR 0.152.
 */
package leviathan143.loottweaker.common.zenscript.factory;

import com.google.common.collect.Lists;
import crafttweaker.api.data.IData;
import crafttweaker.mc1120.data.NBTConverter;
import java.util.ArrayList;
import java.util.List;
import leviathan143.loottweaker.common.ErrorHandler;
import leviathan143.loottweaker.common.darkmagic.LootTableManagerAccessors;
import leviathan143.loottweaker.common.lib.DataParser;
import leviathan143.loottweaker.common.zenscript.wrapper.ZenLootFunctionWrapper;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.EnchantRandomly;
import net.minecraft.world.storage.loot.functions.EnchantWithLevels;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraft.world.storage.loot.functions.LootingEnchantBonus;
import net.minecraft.world.storage.loot.functions.SetCount;
import net.minecraft.world.storage.loot.functions.SetDamage;
import net.minecraft.world.storage.loot.functions.SetMetadata;
import net.minecraft.world.storage.loot.functions.SetNBT;
import net.minecraft.world.storage.loot.functions.Smelt;

public class LootFunctionFactoryImpl {
    private static final LootCondition[] NO_CONDITIONS = new LootCondition[0];
    private final ErrorHandler errorHandler;
    private final DataParser loggingParser;

    public LootFunctionFactoryImpl(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
        this.loggingParser = new DataParser(LootTableManagerAccessors.getGsonInstance(), e -> errorHandler.error(e.getMessage()));
    }

    public ZenLootFunctionWrapper enchantRandomly(String[] enchantIDList) {
        ArrayList enchantments = Lists.newArrayListWithCapacity((int)enchantIDList.length);
        for (String id : enchantIDList) {
            Enchantment ench = Enchantment.func_180305_b((String)id);
            if (ench == null) {
                this.errorHandler.error("%s is not a valid enchantment id", id);
                continue;
            }
            enchantments.add(ench);
        }
        return new ZenLootFunctionWrapper((LootFunction)new EnchantRandomly(NO_CONDITIONS, (List)enchantments));
    }

    public ZenLootFunctionWrapper enchantWithLevels(int min, int max, boolean isTreasure) {
        return new ZenLootFunctionWrapper((LootFunction)new EnchantWithLevels(NO_CONDITIONS, new RandomValueRange((float)min, (float)max), isTreasure));
    }

    public ZenLootFunctionWrapper lootingEnchantBonus(int min, int max, int limit) {
        return new ZenLootFunctionWrapper((LootFunction)new LootingEnchantBonus(NO_CONDITIONS, new RandomValueRange((float)min, (float)max), limit));
    }

    public ZenLootFunctionWrapper setCount(int min, int max) {
        return new ZenLootFunctionWrapper((LootFunction)new SetCount(NO_CONDITIONS, new RandomValueRange((float)min, (float)max)));
    }

    public ZenLootFunctionWrapper setDamage(float min, float max) {
        if (max > 1.0f) {
            this.errorHandler.error("Items cannot recieve more than 100% damage!");
            return ZenLootFunctionWrapper.INVALID;
        }
        return new ZenLootFunctionWrapper((LootFunction)new SetDamage(NO_CONDITIONS, new RandomValueRange(min, max)));
    }

    public ZenLootFunctionWrapper setMetadata(int min, int max) {
        return new ZenLootFunctionWrapper((LootFunction)new SetMetadata(NO_CONDITIONS, new RandomValueRange((float)min, (float)max)));
    }

    public ZenLootFunctionWrapper setNBT(IData nbtData) {
        NBTBase nbt = NBTConverter.from((IData)nbtData);
        if (!(nbt instanceof NBTTagCompound)) {
            this.errorHandler.error("Expected compound nbt tag, got %s", nbtData);
            return ZenLootFunctionWrapper.INVALID;
        }
        return new ZenLootFunctionWrapper((LootFunction)new SetNBT(NO_CONDITIONS, (NBTTagCompound)nbt));
    }

    public ZenLootFunctionWrapper smelt() {
        return new ZenLootFunctionWrapper((LootFunction)new Smelt(NO_CONDITIONS));
    }

    public ZenLootFunctionWrapper parse(IData json) {
        return this.loggingParser.parse(json, LootFunction.class).map(ZenLootFunctionWrapper::new).orElse(ZenLootFunctionWrapper.INVALID);
    }
}

