/*
 * Decompiled with CFR 0.152.
 */
package leviathan143.loottweaker.common.mutable_loot.entry;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.List;
import leviathan143.loottweaker.common.darkmagic.LootEntryItemAccessors;
import leviathan143.loottweaker.common.darkmagic.LootTableManagerAccessors;
import leviathan143.loottweaker.common.mutable_loot.entry.MutableLootEntry;
import net.minecraft.item.Item;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;

public class MutableLootEntryItem
extends MutableLootEntry<MutableLootEntryItem, LootEntryItem> {
    private Item item;
    private List<LootFunction> functions;

    MutableLootEntryItem(LootEntryItem entry) {
        super((LootEntry)entry);
        this.item = LootEntryItemAccessors.getItem(entry);
        this.functions = Lists.newArrayList((Object[])LootEntryItemAccessors.getFunctions(entry));
    }

    public MutableLootEntryItem(String name, int weight, int quality, List<LootCondition> conditions, Item item, List<LootFunction> functions) {
        super(name, weight, quality, conditions);
        this.item = item;
        this.functions = functions;
    }

    @Override
    public MutableLootEntryItem deepClone() {
        return new MutableLootEntryItem(this.getName(), this.getWeight(), this.getQuality(), this.deepCloneConditions(), this.item, this.deepCloneFunctions());
    }

    private List<LootFunction> deepCloneFunctions() {
        ArrayList<LootFunction> clone = new ArrayList<LootFunction>(this.functions.size());
        for (int i = 0; i < this.functions.size(); ++i) {
            clone.add(this.deepCloneFunction(this.functions.get(i)));
        }
        return clone;
    }

    private LootFunction deepCloneFunction(LootFunction lootFunction) {
        Gson lootTableGson = LootTableManagerAccessors.getGsonInstance();
        JsonElement json = lootTableGson.toJsonTree((Object)lootFunction);
        return (LootFunction)lootTableGson.fromJson(json, LootFunction.class);
    }

    @Override
    public LootEntryItem toImmutable() {
        return new LootEntryItem(this.item, this.getWeight(), this.getQuality(), this.functions.toArray(new LootFunction[0]), this.getConditions().toArray(new LootCondition[0]), this.getName());
    }

    public Item getItem() {
        return this.item;
    }

    public void setItem(Item item) {
        this.item = item;
    }

    public List<LootFunction> getFunctions() {
        return this.functions;
    }

    public void setFunctions(List<LootFunction> functions) {
        this.functions = functions;
    }

    public void addFunction(LootFunction function) {
        this.functions.add(function);
    }

    public void clearFunctions() {
        this.functions.clear();
    }
}

