/*
 * Decompiled with CFR 0.152.
 */
package leviathan143.loottweaker.common.mutable_loot.entry;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.List;
import leviathan143.loottweaker.common.darkmagic.LootEntryAccessors;
import leviathan143.loottweaker.common.darkmagic.LootTableManagerAccessors;
import leviathan143.loottweaker.common.lib.DeepClone;
import leviathan143.loottweaker.common.mutable_loot.entry.MutableLootEntryEmpty;
import leviathan143.loottweaker.common.mutable_loot.entry.MutableLootEntryItem;
import leviathan143.loottweaker.common.mutable_loot.entry.MutableLootEntryTable;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryEmpty;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.LootEntryTable;
import net.minecraft.world.storage.loot.conditions.LootCondition;

public abstract class MutableLootEntry<Self extends MutableLootEntry<Self, Immutable>, Immutable extends LootEntry>
implements DeepClone<Self> {
    private final String name;
    private int weight;
    private int quality;
    private List<LootCondition> conditions;

    protected MutableLootEntry(LootEntry entry) {
        this.name = entry.getEntryName();
        this.weight = LootEntryAccessors.getWeight(entry);
        this.quality = LootEntryAccessors.getQuality(entry);
        this.conditions = Lists.newArrayList((Object[])LootEntryAccessors.getConditions(entry));
    }

    protected MutableLootEntry(String name, int weight, int quality, LootCondition[] conditions) {
        this(name, weight, quality, Lists.newArrayList((Object[])conditions));
    }

    protected MutableLootEntry(String name, int weight, int quality, List<LootCondition> conditions) {
        this.name = name;
        this.weight = weight;
        this.quality = quality;
        this.conditions = conditions;
    }

    public static MutableLootEntry<?, ?> from(LootEntry entry) {
        if (entry instanceof LootEntryItem) {
            return new MutableLootEntryItem((LootEntryItem)entry);
        }
        if (entry instanceof LootEntryTable) {
            return new MutableLootEntryTable((LootEntryTable)entry);
        }
        if (entry instanceof LootEntryEmpty) {
            return new MutableLootEntryEmpty((LootEntryEmpty)entry);
        }
        throw new IllegalArgumentException("Unknown loot entry type " + entry.getClass().getName());
    }

    protected List<LootCondition> deepCloneConditions() {
        ArrayList<LootCondition> clone = new ArrayList<LootCondition>(this.conditions.size());
        for (int i = 0; i < this.conditions.size(); ++i) {
            clone.add(this.deepCloneCondition(this.conditions.get(i)));
        }
        return clone;
    }

    private LootCondition deepCloneCondition(LootCondition lootCondition) {
        Gson lootTableGson = LootTableManagerAccessors.getGsonInstance();
        JsonElement json = lootTableGson.toJsonTree((Object)lootCondition);
        return (LootCondition)lootTableGson.fromJson(json, LootCondition.class);
    }

    public abstract Immutable toImmutable();

    public int getWeight() {
        return this.weight;
    }

    public void setWeight(int weight) {
        this.weight = weight;
    }

    public int getQuality() {
        return this.quality;
    }

    public void setQuality(int quality) {
        this.quality = quality;
    }

    public List<LootCondition> getConditions() {
        return this.conditions;
    }

    public void setConditions(List<LootCondition> conditions) {
        this.conditions = conditions;
    }

    public void addCondition(LootCondition condition) {
        this.conditions.add(condition);
    }

    public void clearConditions() {
        this.conditions.clear();
    }

    public String getName() {
        return this.name;
    }
}

