/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.fluidtank.recipes;

import com.kotori316.fluidtank.Config;
import com.kotori316.fluidtank.FluidTank;
import com.kotori316.fluidtank.recipes.TierIngredient;
import com.kotori316.fluidtank.tiles.Tiers;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.OreIngredient;

public class TankRecipe
extends ShapedRecipes {
    private static final Function<ItemStack, IFluidHandlerItem> itemHandler = s -> (IFluidHandlerItem)s.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
    private final Tiers tiers;
    private final boolean valid;

    public TankRecipe(@Nonnull Tiers tiers) {
        super("fluidtank:tank" + tiers.rank(), 3, 3, NonNullList.func_191197_a((int)9, (Object)Ingredient.field_193370_a), ItemStack.field_190927_a);
        this.setRegistryName("fluidtank:tank" + tiers.toString().toLowerCase(Locale.US));
        this.tiers = tiers;
        OreIngredient oreIngredient = new OreIngredient((String)Config.content().oreNameMap().apply((Object)tiers));
        boolean bl = this.valid = tiers.rank() > 1 && OreDictionary.doesOreNameExist((String)((String)Config.content().oreNameMap().apply((Object)tiers)));
        if (this.valid) {
            TierIngredient tierIngredient = new TierIngredient(tiers.rank() - 1);
            IntStream.of(0, 2, 6, 8).forEach(value -> {
                Ingredient cfr_ignored_0 = (Ingredient)this.field_77574_d.set(value, (Object)oreIngredient);
            });
            IntStream.of(1, 3, 5, 7).forEach(value -> {
                Ingredient cfr_ignored_0 = (Ingredient)this.field_77574_d.set(value, (Object)tierIngredient);
            });
        }
    }

    public boolean func_77569_a(@Nonnull InventoryCrafting inv, @Nonnull World world) {
        for (int i = 0; i <= inv.func_174922_i() - this.field_77576_b; ++i) {
            for (int j = 0; j <= inv.func_174923_h() - this.field_77577_c; ++j) {
                if (!this.checkMatch(inv, i, j)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean checkMatch(InventoryCrafting inv, int startX, int startY) {
        FluidStack stack = null;
        for (int x = 0; x < inv.func_174922_i(); ++x) {
            for (int y = 0; y < inv.func_174923_h(); ++y) {
                ItemStack stackInRowAndColumn;
                int subX = x - startX;
                int subY = y - startY;
                Ingredient target = Ingredient.field_193370_a;
                if (subX >= 0 && subY >= 0 && subX < 3 && subY < 3) {
                    target = (Ingredient)this.field_77574_d.get(subX + subY * 3);
                }
                if (target.apply(stackInRowAndColumn = inv.func_70463_b(x, y))) {
                    if (!(target instanceof TierIngredient)) continue;
                    FluidStack fluidStack = Optional.of(stackInRowAndColumn).map(itemHandler).filter(h -> h.getTankProperties().length > 0).map(h -> h.getTankProperties()[0].getContents()).orElse(null);
                    if (stack == null) {
                        if (fluidStack == null) continue;
                        stack = fluidStack;
                        continue;
                    }
                    if (fluidStack == null || stack.isFluidEqual(fluidStack)) continue;
                    return false;
                }
                return false;
            }
        }
        return true;
    }

    public NonNullList<ItemStack> func_179532_b(InventoryCrafting inv) {
        NonNullList stacks = NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < stacks.size(); ++i) {
            ItemStack item = inv.func_70301_a(i);
            if (!item.func_77973_b().hasContainerItem(item)) continue;
            stacks.set(i, (Object)ForgeHooks.getContainerItem((ItemStack)item));
        }
        return stacks;
    }

    public ItemStack func_77572_b(InventoryCrafting inv) {
        FluidStack stack = IntStream.of(1, 3, 5, 7).mapToObj(arg_0 -> ((InventoryCrafting)inv).func_70301_a(arg_0)).map(itemHandler).filter(Objects::nonNull).map(IFluidHandler::getTankProperties).flatMap(x$0 -> WrapFluid.newStreamWithValidStack(x$0)).reduce((x$0, x$1) -> WrapFluid.combine((WrapFluid)x$0, (WrapFluid)x$1)).map(WrapFluid::getStack).orElse(null);
        ItemStack copy = this.func_77571_b().func_77946_l();
        Optional.of(copy).map(itemHandler).ifPresent(h -> h.fill(stack, true));
        return copy;
    }

    @Nonnull
    public ItemStack func_77571_b() {
        return this.valid ? new ItemStack((Block)FluidTank.BLOCK_TANKS.get(this.tiers.rank() - 1), 1, this.tiers.meta()) : super.func_77571_b();
    }

    public boolean isValid() {
        return this.valid;
    }

    public String toString() {
        return "Recipe of " + this.tiers + " valid = " + this.valid;
    }

    private static class WrapFluid {
        private FluidStack stack;

        private WrapFluid(@Nonnull FluidStack stack) {
            this.stack = stack.copy();
        }

        private static WrapFluid combine(@Nonnull WrapFluid w1, @Nonnull WrapFluid w2) {
            w1.stack.amount += w2.stack.amount;
            return w1;
        }

        private static Stream<WrapFluid> newStreamWithValidStack(@Nonnull IFluidTankProperties[] properties) {
            FluidStack stack;
            if (properties.length > 0 && (stack = properties[0].getContents()) != null) {
                return Stream.of(new WrapFluid(stack));
            }
            return Stream.empty();
        }

        @Nonnull
        public FluidStack getStack() {
            return this.stack;
        }
    }
}

