/*
 * Decompiled with CFR 0.152.
 */
package com.github.terminatornl.laggoggles.util;

public enum ColorBlindMode {
    GREEN_TO_RED(1, 0, 2),
    BLUE_TO_RED(2, 0, 1),
    GREEN_TO_BLUE(1, 2, 0);

    private final int bad;
    private final int good;
    private final int neutral;

    private ColorBlindMode(int good, int bad, int neutral) {
        this.bad = bad;
        this.good = good;
        this.neutral = neutral;
    }

    public double[] heatToColor(double heat) {
        double[] rgb = new double[3];
        rgb[this.neutral] = 0.0;
        if (heat < 50.0) {
            rgb[this.bad] = heat / 50.0;
            rgb[this.good] = 1.0;
            return rgb;
        }
        if (heat == 50.0) {
            rgb[this.bad] = 1.0;
            rgb[this.good] = 1.0;
            return rgb;
        }
        rgb[this.bad] = 1.0;
        rgb[this.good] = 1.0 - (heat - 50.0) / 50.0;
        return rgb;
    }
}

