/*
 * Decompiled with CFR 0.152.
 */
package com.github.terminatornl.laggoggles.util;

import com.github.terminatornl.laggoggles.client.ClientConfig;
import com.github.terminatornl.laggoggles.client.gui.GuiScanResultsWorld;
import com.github.terminatornl.laggoggles.packet.ObjectData;
import com.github.terminatornl.laggoggles.profiler.ProfileResult;
import com.github.terminatornl.laggoggles.profiler.TimingManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class Calculations {
    public static final double NANOS_IN_A_TICK = 5.0E7;

    public static double heat(long nanos, ProfileResult result) {
        return Math.min(Calculations.muPerTick(nanos, result) / (double)ClientConfig.GRADIENT_MAXED_OUT_AT_MICROSECONDS * 100.0, 100.0);
    }

    public static double heatThread(GuiScanResultsWorld.LagSource source, ProfileResult result) {
        if (source.data.type != ObjectData.Type.EVENT_BUS_LISTENER) {
            throw new IllegalArgumentException("Expected heat calculation for thread, not " + (Object)((Object)source.data.type));
        }
        TimingManager.EventTimings.ThreadType type = TimingManager.EventTimings.ThreadType.values()[(Integer)source.data.getValue(ObjectData.Entry.EVENT_BUS_THREAD_TYPE)];
        if (type == TimingManager.EventTimings.ThreadType.CLIENT) {
            return Math.min((double)source.nanos / (double)result.getTotalTime() * 100.0, 100.0);
        }
        if (type == TimingManager.EventTimings.ThreadType.ASYNC) {
            return 0.0;
        }
        if (type == TimingManager.EventTimings.ThreadType.SERVER) {
            return Math.floor((double)(source.nanos / result.getTickCount()) / 5.0E7 * 10000.0) / 100.0;
        }
        throw new IllegalStateException("Terminator_NL forgot to add code here... Please submit an issue at github!");
    }

    public static double heatNF(long nanos, ProfileResult result) {
        return Math.min((double)nanos / (double)result.getTotalFrames() / (double)ClientConfig.GRADIENT_MAXED_OUT_AT_NANOSECONDS_FPS * 100.0, 100.0);
    }

    public static String NFString(long nanos, long frames) {
        long nf = nanos / frames;
        if (nf > 1000L) {
            return nf / 1000L + "k ns/F";
        }
        return nf + " ns/F";
    }

    public static String NFStringSimple(long nanos, long frames) {
        return nanos / frames + " ns/F";
    }

    public static String tickPercent(long nanos, ProfileResult result) {
        if (result == null || result.getTickCount() == 0L) {
            return "?";
        }
        return Math.floor((double)(nanos / result.getTickCount()) / 5.0E7 * 10000.0) / 100.0 + "%";
    }

    public static String nfPercent(long nanos, ProfileResult result) {
        if (result == null || result.getTotalFrames() == 0L) {
            return "?";
        }
        return Math.floor((double)nanos / (double)result.getTotalTime() * 10000.0) / 100.0 + "%";
    }

    public static double muPerTick(long nanos, ProfileResult result) {
        if (result == null) {
            return 0.0;
        }
        return nanos / result.getTickCount() / 1000L;
    }

    public static double muPerTickCustomTotals(long nanos, long totalTicks) {
        return nanos / totalTicks / 1000L;
    }

    public static String muPerTickString(long nanos, ProfileResult result) {
        if (result == null) {
            return "?";
        }
        return Double.valueOf(nanos / result.getTickCount() / 1000L).intValue() + " " + "\u00b5" + "s/t";
    }
}

