package jeresources.profiling;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ReportedException;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.NextTickListEntry;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityDispatcher;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.registry.GameRegistry;

import javax.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * Dummy world wraps a regular world.
 * It prevents saving new chunks, doing lighting calculations, or spawning entities.
 */
public class DummyWorld extends WorldServer {
    public List<Entity> spawnedEntities = new ArrayList<>();
    private CapabilityDispatcher capabilities;

    public DummyWorld(WorldServer world) {
        super(Minecraft.func_71410_x().func_71401_C(), world.func_72860_G(), world.func_72912_H(), world.field_73011_w.getDimension(), world.field_72984_F);
        this.field_73011_w.func_76558_a(this);
        this.field_73020_y = new DummyChunkProvider(this, this.func_72863_F());
        this.field_193036_D = world.func_193037_A(); // Make sure this is here for a tick between object creation and dummy world init
        this.capabilities = ForgeEventFactory.gatherCapabilities(world, field_73011_w.initCapabilities());
    }

    public void clearChunks() {
        ((DummyChunkProvider) this.field_73020_y).unloadAllChunks();
    }

    @Override
    public Entity func_73045_a(int i) {
        return null;
    }

    @Override
    public boolean func_180501_a(BlockPos pos, IBlockState newState, int flags) {
        if (!func_175701_a(pos) || !func_175667_e(pos)) {
            return false;
        }

        Chunk chunk = func_175726_f(pos);
        IBlockState blockState = chunk.func_177436_a(pos, newState);
        return blockState != null;
    }

    @Override
    public boolean func_175656_a(BlockPos pos, IBlockState state) {
        return this.func_180501_a(pos, state, 3);
    }

    @Override
    public void func_180497_b(BlockPos pos, Block blockIn, int delay, int priority) {

    }

    @Override
    public void func_175654_a(BlockPos pos, Block blockIn, int delay, int priority) {

    }

    @Override
    public boolean func_72955_a(boolean p_72955_1_) {
        return false;
    }

    @Override
    public List<NextTickListEntry> func_175712_a(StructureBoundingBox structureBB, boolean p_175712_2_) {
        return Collections.emptyList();
    }

    @Override
    public boolean func_72838_d(Entity entity) {
        this.spawnedEntities.add(entity);
        return true;
    }

    @Override
    public void func_72835_b() {

    }

    @Nullable
    @Override
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        return capabilities == null ? null : capabilities.getCapability(capability, facing);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capabilities != null && capabilities.hasCapability(capability, facing);
    }

    private static class DummyChunkProvider extends ChunkProviderServer implements IChunkProvider, IChunkGenerator {
        private final World dummyWorld;
        private final IChunkGenerator realChunkGenerator;
        private final IChunkProvider realChunkProvider;
        private boolean allowLoading = true;

        public DummyChunkProvider(DummyWorld dummyWorld, ChunkProviderServer chunkProviderServer) {
            super(dummyWorld, chunkProviderServer.field_73247_e, chunkProviderServer.field_186029_c);
            this.dummyWorld = dummyWorld;
            this.realChunkGenerator = chunkProviderServer.field_186029_c;
            this.realChunkProvider = chunkProviderServer;
        }

        @Override
        public void func_180514_a(Chunk chunkIn, int x, int z) {
            // no retrogen
        }

        @Override
        public boolean func_193413_a(World worldIn, String structureName, BlockPos pos) {
            return false;
        }

        @Override
        public String func_73148_d() {
            return "Dummy";
        }

        @Override
        public List<Biome.SpawnListEntry> func_177458_a(EnumCreatureType creatureType, BlockPos pos) {
            return null;
        }

        @Override
        public void func_185931_b(int x, int z) {
            allowLoading = false;
            realChunkGenerator.func_185931_b(x, z);
            GameRegistry.generateWorld(x, z, dummyWorld, this, this);
            allowLoading = true;
        }

        @Override
        public Chunk func_186026_b(int x, int z) {
            final long chunkKey = ChunkPos.func_77272_a(x, z);
            return this.field_73244_f.get(chunkKey);
        }

        public void unloadAllChunks() {
            this.field_73244_f.clear();
        }

        @Override
        public boolean func_186027_a(boolean all) {
            return true;
        }

        @Override
        public Chunk func_185932_a(int x, int z) {
            final long chunkKey = ChunkPos.func_77272_a(x, z);
            Chunk chunk = this.field_73244_f.get(chunkKey);
            if (chunk != null) {
                return chunk;
            }
            if (!allowLoading) {
                return new EmptyChunkJER(dummyWorld, x, z);
            }

            try {
                chunk = realChunkGenerator.func_185932_a(x, z);
            } catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.func_85055_a(throwable, "Exception generating new chunk");
                CrashReportCategory crashreportcategory = crashreport.func_85058_a("Chunk to be generated");
                crashreportcategory.func_71507_a("Location", String.format("%d,%d", x, z));
                crashreportcategory.func_71507_a("Generator", realChunkProvider.func_73148_d());
                throw new ReportedException(crashreport);
            }

            this.field_73244_f.put(chunkKey, chunk);

            this.allowLoading = false;
            net.minecraftforge.common.MinecraftForge.EVENT_BUS.post(new net.minecraftforge.event.world.ChunkEvent.Load(chunk));
            chunk.func_186030_a(this, this);
            this.allowLoading = true;

            return chunk;
        }

        @Override
        public boolean func_185933_a(Chunk chunkIn, int x, int z) {
            return false;
        }

        @Override
        public boolean func_73156_b() {
            return false;
        }
    }
}
