package jeresources.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import jeresources.api.distributions.DistributionBase;
import jeresources.api.distributions.DistributionCustom;
import jeresources.api.distributions.DistributionHelpers;
import jeresources.api.drop.LootDrop;
import jeresources.api.restrictions.DimensionRestriction;
import jeresources.api.restrictions.Restriction;
import jeresources.config.ConfigHandler;
import jeresources.entry.WorldGenEntry;
import jeresources.registry.WorldGenRegistry;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.*;

public class WorldGenAdapter {
    public static boolean hasWorldGenDIYData() {
        return ConfigHandler.getWorldGenFile().exists();
    }

    public static boolean readDIYData() {
        JsonParser parser = new JsonParser();
        try {
            JsonElement base = parser.parse(new FileReader(ConfigHandler.getWorldGenFile()));
            if (!base.isJsonArray() || base.getAsJsonArray().size() == 0) return false;
            JsonArray array = base.getAsJsonArray();
            for (int i = 0; i < array.size(); i++) {
                JsonObject obj = array.get(i).getAsJsonObject();

                JsonElement element = obj.get("mod"); // use of "mod": "modID"
                if (element != null)
                    if (!Loader.isModLoaded(element.getAsString())) // when modID is not loaded skip item
                        continue;

                String block = obj.get("block").getAsString();
                JsonElement distribElement = obj.get("distrib");
                if (distribElement == null)
                    continue;

                String distrib = distribElement.getAsString();
                JsonElement silk = obj.get("silktouch");
                boolean silktouch = silk != null && silk.getAsBoolean();

                JsonElement dimElement = obj.get("dim");
                String dim = dimElement != null ? dimElement.getAsString() : "";

                String[] blockParts = block.split(":");

                Block blockBlock = Block.field_149771_c.func_82594_a(new ResourceLocation(blockParts[0], blockParts[1]));
                if (blockBlock == null || Item.func_150898_a(blockBlock) == null) continue;
                int oreMeta = blockParts.length == 3 ? Integer.parseInt(blockParts[2]) : 0;
                ItemStack blockStack = new ItemStack(blockBlock, 1, oreMeta);
                List<DistributionHelpers.OrePoint> points = new ArrayList<>();
                for (String point : distrib.split(";")) {
                    String[] split = point.split(",");
                    if (split.length == 2)
                        points.add(new DistributionHelpers.OrePoint(Integer.parseInt(split[0]), Float.parseFloat(split[1])));
                }
                DistributionBase distribution = new DistributionCustom(DistributionHelpers.getDistributionFromPoints(points.toArray(new DistributionHelpers.OrePoint[points.size()])));

                JsonElement dropsListElement = obj.get("dropsList");
                List<LootDrop> dropList = new LinkedList<>();
                if (dropsListElement != null) {
                    JsonArray drops = dropsListElement.getAsJsonArray();
                    for (JsonElement dropElement : drops) {
                        JsonObject drop = dropElement.getAsJsonObject();
                        JsonElement itemStackElement = drop.get("itemStack");
                        if (itemStackElement.isJsonNull()) continue;
                        String itemStackString = itemStackElement.getAsString();
                        String[] stackStrings = itemStackString.split(":", 4);
                        Item item = Item.field_150901_e.func_82594_a(new ResourceLocation(stackStrings[0], stackStrings[1]));
                        if (item == null)
                            continue;

                        ItemStack itemStack = new ItemStack(item);
                        if (stackStrings.length >= 3) {
                            itemStack.func_77964_b(Integer.valueOf(stackStrings[2]));
                        }

                        if (stackStrings.length == 4) {
                            try {
                                itemStack.func_77982_d(JsonToNBT.func_180713_a(stackStrings[3]));
                            } catch (NBTException e) {
                                e.printStackTrace();
                            }
                        }

                        JsonElement fortuneElement = drop.get("fortunes");
                        if (fortuneElement != null) {
                            JsonObject fortunes = fortuneElement.getAsJsonObject();
                            for (Map.Entry<String, JsonElement> fortuneValue : fortunes.entrySet()) {
                                int fortuneLevel = Integer.valueOf(fortuneValue.getKey());
                                float dropAmount = fortuneValue.getValue().getAsFloat();
                                dropList.add(new LootDrop(itemStack, dropAmount, fortuneLevel));
                            }
                        }
                    }
                }

                if ((blockStack.func_190926_b() || blockStack.func_77973_b() == Items.field_190931_a) && dropList.size() > 0) {
                    // Some blocks don't have an item equivalent so we use the first drop
                    blockStack = dropList.get(0).item.func_77946_l();
                    blockStack.func_190920_e(1);
                }

                WorldGenRegistry.getInstance().registerEntry(new WorldGenEntry(blockStack, distribution, getRestriction(dim), silktouch, dropList.toArray(new LootDrop[dropList.size()])));
            }
        } catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        map.clear();
        return true;
    }

    private static Map<String, Restriction> map = new HashMap<>();

    private static Restriction getRestriction(String dim) {
        return map.computeIfAbsent(dim, k -> new Restriction(new DimensionRestriction(dim)));
    }
}
