package jeresources.compatibility.minecraft;

import jeresources.api.render.IMobRenderHook;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.monster.EntityElderGuardian;
import net.minecraft.entity.monster.EntityGiantZombie;
import net.minecraft.entity.monster.EntityShulker;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.passive.EntitySquid;

public class RenderHooks {
    public static final IMobRenderHook ENDER_DRAGON = (IMobRenderHook<EntityDragon>) (renderInfo, entity) ->
    {
        GlStateManager.func_179114_b(20.0F, 1.0F, 0.0F, 0.0F);
        GlStateManager.func_179114_b(180.0F, 0.0F, 1.0F, 0.0F);
        renderInfo.pitch = -renderInfo.pitch - 80;
        GlStateManager.func_179114_b(renderInfo.yaw < 90 ? (renderInfo.yaw < -90 ? 90 : -renderInfo.yaw) : -90, 0.0F, 1.0F, 0.0F);
        return renderInfo;
    };

    public static final IMobRenderHook BAT = (IMobRenderHook<EntityBat>) (renderInfo, entity) ->
    {
        GlStateManager.func_179114_b(20.0F, 1.0F, 0.0F, 0.0F);
        GlStateManager.func_179114_b(180.0F, 0.0F, 1.0F, 0.0F);
        renderInfo.pitch = -renderInfo.pitch;
        return renderInfo;
    };

    public static final IMobRenderHook ELDER_GUARDIAN = (IMobRenderHook<EntityElderGuardian>) (renderInfo, entity) ->
    {
        GlStateManager.func_179152_a(0.6F, 0.6F, 0.6F);
        entity.func_190767_di();
        return renderInfo;
    };

    public static final IMobRenderHook SQUID = (IMobRenderHook<EntitySquid>) (renderInfo, entity) ->
    {
        GlStateManager.func_179114_b(50.0F, 1.0F, 0.0F, 0.0F);
        return renderInfo;
    };

    public static final IMobRenderHook GIANT = (IMobRenderHook<EntityGiantZombie>) (renderInfo, entity) ->
    {
        GlStateManager.func_179109_b(0.0F, -2.0F, 0.0F);
        GlStateManager.func_179152_a(0.7F, 0.7F, 0.7F);
        return renderInfo;
    };

    public static final IMobRenderHook SHULKER = (IMobRenderHook<EntityShulker>) (renderInfo, entity) ->
    {
        return renderInfo;
    };
}
