/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.ironchest.common.blocks.chest;

import cpw.mods.ironchest.IronChest;
import cpw.mods.ironchest.common.blocks.chest.IronChestType;
import cpw.mods.ironchest.common.core.IronChestCreativeTabs;
import cpw.mods.ironchest.common.tileentity.chest.TileEntityIronChest;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.ILockableContainer;
import net.minecraft.world.IWorldNameable;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockIronChest
extends Block {
    public static final PropertyEnum<IronChestType> VARIANT_PROP = PropertyEnum.func_177709_a((String)"variant", IronChestType.class);
    protected static final AxisAlignedBB IRON_CHEST_AABB = new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.875, 0.9375);
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    private static final EnumFacing[] validRotationAxes = new EnumFacing[]{EnumFacing.UP, EnumFacing.DOWN};

    public BlockIronChest() {
        super(Material.field_151573_f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
        this.setRegistryName(new ResourceLocation("ironchest:iron_chest"));
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(VARIANT_PROP, (Comparable)((Object)IronChestType.IRON)));
        this.func_149711_c(3.0f);
        this.func_149663_c("IronChest");
        this.func_149647_a(IronChestCreativeTabs.tabIronChests);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return IRON_CHEST_AABB;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    @Nullable
    public ILockableContainer getLockableContainer(World worldIn, BlockPos pos) {
        return this.getContainer(worldIn, pos, false);
    }

    @Nullable
    public ILockableContainer getContainer(World worldIn, BlockPos pos, boolean allowBlocking) {
        return null;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing heldItem, float side, float hitX, float hitY) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te == null || !(te instanceof TileEntityIronChest)) {
            return true;
        }
        if (worldIn.field_72995_K) {
            return true;
        }
        playerIn.openGui((Object)IronChest.instance, ((TileEntityIronChest)te).getType().ordinal(), worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        return true;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return ((IronChestType)((Object)state.func_177229_b(VARIANT_PROP))).makeEntity();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        for (IronChestType type : IronChestType.VALUES) {
            if (!type.isValidForCreativeMode()) continue;
            list.add((Object)new ItemStack((Block)this, 1, type.ordinal()));
        }
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT_PROP, (Comparable)((Object)IronChestType.VALUES[meta]));
    }

    public int func_176201_c(IBlockState blockState) {
        return ((IronChestType)((Object)blockState.func_177229_b(VARIANT_PROP))).ordinal();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT_PROP, FACING});
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        super.func_176213_c(world, pos, state);
        world.func_184138_a(pos, state, state, 3);
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te != null && te instanceof TileEntityIronChest) {
            TileEntityIronChest teic = (TileEntityIronChest)te;
            teic.wasPlaced(placer, stack);
            teic.setFacing(placer.func_174811_aO().func_176734_d());
            worldIn.func_184138_a(pos, state, state, 3);
            if (stack.func_82837_s()) {
                teic.func_190575_a(stack.func_82833_r());
            }
        }
    }

    public int func_180651_a(IBlockState state) {
        return ((IronChestType)((Object)state.func_177229_b(VARIANT_PROP))).ordinal();
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntityIronChest tileentity = (TileEntityIronChest)worldIn.func_175625_s(pos);
        if (tileentity != null) {
            tileentity.removeAdornments();
            InventoryHelper.func_180175_a((World)worldIn, (BlockPos)pos, (IInventory)tileentity);
            worldIn.func_175666_e(pos, (Block)this);
            worldIn.func_175713_t(pos);
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public float getExplosionResistance(World world, BlockPos pos, Entity exploder, Explosion explosion) {
        TileEntityIronChest teic;
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityIronChest && (teic = (TileEntityIronChest)te).getType().isExplosionResistant()) {
            return 10000.0f;
        }
        return super.getExplosionResistance(world, pos, exploder, explosion);
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState blockState, World worldIn, BlockPos pos) {
        return Container.func_178144_a((TileEntity)worldIn.func_175625_s(pos));
    }

    public EnumFacing[] getValidRotations(World worldObj, BlockPos pos) {
        return validRotationAxes;
    }

    public boolean rotateBlock(World worldObj, BlockPos pos, EnumFacing axis) {
        if (worldObj.field_72995_K) {
            return false;
        }
        if (axis == EnumFacing.UP || axis == EnumFacing.DOWN) {
            TileEntity tileEntity = worldObj.func_175625_s(pos);
            if (tileEntity instanceof TileEntityIronChest) {
                TileEntityIronChest icte = (TileEntityIronChest)tileEntity;
                icte.rotateAround();
            }
            return true;
        }
        return false;
    }

    @Deprecated
    public boolean func_189539_a(IBlockState state, World worldIn, BlockPos pos, int id, int param) {
        super.func_189539_a(state, worldIn, pos, id, param);
        TileEntity tileentity = worldIn.func_175625_s(pos);
        return tileentity != null && tileentity.func_145842_c(id, param);
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        Random rand = world instanceof World ? ((World)world).field_73012_v : RANDOM;
        TileEntity tileentity = world.func_175625_s(pos);
        int count = this.quantityDropped(state, fortune, rand);
        for (int i = 0; i < count; ++i) {
            Item item = this.func_180660_a(state, rand, fortune);
            if (item == Items.field_190931_a) continue;
            ItemStack stack = new ItemStack(item, 1, this.func_180651_a(state));
            if (tileentity instanceof IWorldNameable && ((IWorldNameable)tileentity).func_145818_k_()) {
                stack.func_151001_c(((IWorldNameable)tileentity).func_70005_c_());
            }
            if (state.func_177229_b(VARIANT_PROP) == IronChestType.DIRTCHEST9000) {
                stack.func_77983_a("dirtchest", (NBTBase)new NBTTagByte(1));
            }
            drops.add((Object)stack);
        }
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack stack) {
        if (te instanceof IWorldNameable && ((IWorldNameable)te).func_145818_k_()) {
            player.func_71029_a(StatList.func_188055_a((Block)this));
            player.func_71020_j(0.005f);
            if (worldIn.field_72995_K) {
                return;
            }
            int i = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)stack);
            Item item = this.func_180660_a(state, worldIn.field_73012_v, i);
            if (item == Items.field_190931_a) {
                return;
            }
            ItemStack itemstack = new ItemStack(item, 1, this.func_180651_a(state));
            if (state.func_177229_b(VARIANT_PROP) == IronChestType.DIRTCHEST9000) {
                itemstack.func_77983_a("dirtchest", (NBTBase)new NBTTagByte(1));
            }
            itemstack.func_151001_c(((IWorldNameable)te).func_70005_c_());
            BlockIronChest.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)itemstack);
        } else {
            super.func_180657_a(worldIn, player, pos, state, (TileEntity)null, stack);
        }
    }
}

