/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.tile.agriculture;

import com.buuz135.industrial.tile.WorkingAreaElectricMachine;
import com.buuz135.industrial.utils.BlockUtils;
import com.buuz135.industrial.utils.WorkUtils;
import java.util.List;
import net.minecraft.block.IGrowable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.FarmlandWaterManager;
import net.minecraftforge.common.ticket.AABBTicket;

public class HydratorTile
extends WorkingAreaElectricMachine {
    private AABBTicket farmlandTicket;

    public HydratorTile() {
        super(HydratorTile.class.getName().hashCode());
    }

    public void onLoad() {
        if (!this.field_145850_b.field_72995_K) {
            this.farmlandTicket = FarmlandWaterManager.addAABBTicket((World)this.field_145850_b, (AxisAlignedBB)this.getWateringArea());
            this.updateTicket();
        }
    }

    public void updateTicket() {
        if (!this.field_145850_b.field_72995_K) {
            this.farmlandTicket.validate();
        }
    }

    @Override
    public float work() {
        if (WorkUtils.isDisabled(this.func_145838_q())) {
            return 0.0f;
        }
        if (this.farmlandTicket == null || !this.farmlandTicket.axisAlignedBB.equals((Object)this.getWateringArea())) {
            if (this.farmlandTicket != null) {
                this.farmlandTicket.invalidate();
            }
            this.farmlandTicket = FarmlandWaterManager.addAABBTicket((World)this.field_145850_b, (AxisAlignedBB)this.getWateringArea());
            this.updateTicket();
        }
        List<BlockPos> blockPosList = BlockUtils.getBlockPosInAABB(this.getWorkingArea());
        boolean hasWorked = false;
        for (BlockPos pos : blockPosList) {
            if (!(this.field_145850_b.func_180495_p(pos).func_177230_c() instanceof IGrowable)) continue;
            this.field_145850_b.func_180495_p(pos).func_177230_c().func_180645_a(this.field_145850_b, pos, this.field_145850_b.func_180495_p(pos), this.field_145850_b.field_73012_v);
            hasWorked = true;
        }
        return hasWorked ? 1.0f : 0.0f;
    }

    @Override
    public AxisAlignedBB getWorkingArea() {
        return super.getWorkingArea().func_72317_d(0.0, -1.0, 0.0);
    }

    public void onChunkUnload() {
        if (!this.field_145850_b.field_72995_K) {
            this.farmlandTicket.invalidate();
        }
    }

    public AxisAlignedBB getWateringArea() {
        return this.getWorkingArea().func_72317_d(0.0, -1.0, 0.0).func_72314_b(0.0, 1.0, 0.0);
    }

    public AABBTicket getFarmlandTicket() {
        return this.farmlandTicket;
    }
}

