/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.tile.agriculture;

import codechicken.enderstorage.tile.TileEnderChest;
import com.buuz135.industrial.IndustrialForegoing;
import com.buuz135.industrial.api.plant.PlantRecollectable;
import com.buuz135.industrial.proxy.BlockRegistry;
import com.buuz135.industrial.proxy.client.ClientProxy;
import com.buuz135.industrial.registry.IFRegistries;
import com.buuz135.industrial.tile.CustomColoredItemHandler;
import com.buuz135.industrial.tile.WorkingAreaElectricMachine;
import com.buuz135.industrial.utils.BlockUtils;
import com.buuz135.industrial.utils.ItemStackUtils;
import com.buuz135.industrial.utils.WorkUtils;
import cpw.mods.ironchest.common.tileentity.chest.TileEntityIronChest;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import mekanism.common.tile.TileEntityBin;
import net.minecraft.block.IGrowable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityEnderChest;
import net.minecraft.tileentity.TileEntityShulkerBox;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.ndrei.teslacorelib.gui.BasicTeslaGuiContainer;
import net.ndrei.teslacorelib.gui.IGuiContainerPiece;
import net.ndrei.teslacorelib.gui.ToggleButtonPiece;
import net.ndrei.teslacorelib.inventory.BoundingRectangle;
import net.ndrei.teslacorelib.netsync.SimpleNBTMessage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CropRecolectorTile
extends WorkingAreaElectricMachine {
    private static String NBT_POINTER = "pointer";
    private static String NBT_OPERATION = "operation";
    private static String NBT_TYPE = "type";
    private ItemStackHandler outItems;
    private int pointer;
    private int operationAmount;
    private PlantRecollectable.Type type = PlantRecollectable.Type.ANY;
    private boolean didWork;

    public CropRecolectorTile() {
        super(CropRecolectorTile.class.getName().hashCode());
    }

    @Override
    protected void initializeInventories() {
        super.initializeInventories();
        this.outItems = new ItemStackHandler(12){

            protected void onContentsChanged(int slot) {
                CropRecolectorTile.this.func_70296_d();
            }
        };
        this.addInventory((IItemHandler)new CustomColoredItemHandler((IItemHandler)this.outItems, EnumDyeColor.ORANGE, "Crops output", 93, 25, 4, 3){

            public boolean canInsertItem(int slot, ItemStack stack) {
                return stack.func_82833_r().equalsIgnoreCase("fertilizer") || stack.func_82833_r().equalsIgnoreCase("Bone Meal");
            }

            public boolean canExtractItem(int slot) {
                ItemStack stack = CropRecolectorTile.this.outItems.getStackInSlot(slot);
                return stack.func_190926_b() || !stack.func_82833_r().equalsIgnoreCase("Fertilizer") && !stack.func_82833_r().equalsIgnoreCase("Bone Meal");
            }
        });
        this.addInventoryToStorage(this.outItems, "outItems");
    }

    @Override
    public float work() {
        IItemHandler itemHandler;
        BlockPos above;
        TileEntity tileEntity;
        ItemStack stack;
        int i;
        if (WorkUtils.isDisabled(this.func_145838_q())) {
            return 0.0f;
        }
        if (ItemStackUtils.isInventoryFull(this.outItems)) {
            return 0.0f;
        }
        List<BlockPos> blockPos = BlockUtils.getBlockPosInAABB(this.getWorkingArea());
        boolean shouldPointerIncrease = true;
        boolean didWork = false;
        if (this.pointer < blockPos.size() && BlockUtils.canBlockBeBroken(this.field_145850_b, blockPos.get(this.pointer))) {
            BlockPos pos = blockPos.get(this.pointer);
            IBlockState state = this.field_145850_b.func_180495_p(blockPos.get(this.pointer));
            Optional<PlantRecollectable> recollectable = IFRegistries.PLANT_RECOLLECTABLES_REGISTRY.getValuesCollection().stream().sorted(Comparator.comparingInt(PlantRecollectable::getPriority)).filter(iPlantRecollectable -> iPlantRecollectable.canBeHarvested(this.field_145850_b, pos, state) && (this.type == PlantRecollectable.Type.ANY || this.type == iPlantRecollectable.getRecollectableType())).findFirst();
            if (recollectable.isPresent()) {
                PlantRecollectable plantRecollectable = recollectable.get();
                ++this.operationAmount;
                List<ItemStack> items = plantRecollectable.doHarvestOperation(this.field_145850_b, pos, state, this.hasShearingAddon(), this.operationAmount);
                if (items != null && !items.isEmpty()) {
                    this.insertItems(items, this.outItems);
                }
                if (!plantRecollectable.shouldCheckNextPlant(this.field_145850_b, pos, state)) {
                    shouldPointerIncrease = false;
                }
            }
            didWork = recollectable.isPresent();
            for (i = 0; i < BlockRegistry.plantInteractorBlock.getHeight() + 1; ++i) {
                IBlockState tempState;
                BlockPos tempPos = new BlockPos(pos.func_177958_n(), pos.func_177956_o() + i, pos.func_177952_p());
                if (!BlockUtils.canBlockBeBroken(this.field_145850_b, tempPos) || !((tempState = this.field_145850_b.func_180495_p(tempPos)).func_177230_c() instanceof IPlantable) && !(tempState.func_177230_c() instanceof IGrowable)) continue;
                FakePlayer player = IndustrialForegoing.getFakePlayer(this.field_145850_b, tempPos.func_177984_a());
                player.field_71071_by.func_174888_l();
                tempState.func_177230_c().func_180639_a(this.field_145850_b, tempPos, tempState, (EntityPlayer)player, EnumHand.MAIN_HAND, EnumFacing.UP, 0.0f, 0.0f, 0.0f);
                ForgeHooks.onRightClickBlock((EntityPlayer)player, (EnumHand)EnumHand.MAIN_HAND, (BlockPos)tempPos, (EnumFacing)EnumFacing.UP, (Vec3d)new Vec3d(0.0, 0.0, 0.0));
                for (ItemStack stack2 : player.field_71071_by.field_70462_a) {
                    if (stack2.func_190926_b()) continue;
                    ItemHandlerHelper.insertItem((IItemHandler)this.outItems, (ItemStack)stack2, (boolean)false);
                    didWork = true;
                }
                player.field_71071_by.func_174888_l();
            }
            if (!this.field_145850_b.func_175623_d(pos)) {
                for (i = 0; i < this.outItems.getSlots(); ++i) {
                    FakePlayer player;
                    stack = this.outItems.getStackInSlot(i);
                    if (stack.func_190926_b() || !stack.func_82833_r().equalsIgnoreCase("Fertilizer") && !stack.func_82833_r().equalsIgnoreCase("Bone Meal") || !ItemDye.applyBonemeal((ItemStack)stack, (World)this.field_145850_b, (BlockPos)pos, (EntityPlayer)(player = IndustrialForegoing.getFakePlayer(this.field_145850_b)), (EnumHand)EnumHand.MAIN_HAND)) continue;
                    didWork = true;
                }
            }
        }
        if (shouldPointerIncrease) {
            ++this.pointer;
            this.operationAmount = 0;
        }
        if (this.pointer >= blockPos.size()) {
            this.pointer = 0;
        }
        if (didWork && (tileEntity = this.field_145850_b.func_175625_s(above = this.field_174879_c.func_177984_a())) != null && (tileEntity instanceof TileEntityIronChest || tileEntity instanceof TileEntityBin || tileEntity instanceof TileEntityChest || tileEntity instanceof TileEntityEnderChest || tileEntity instanceof TileEntityShulkerBox || tileEntity instanceof TileEnderChest) && (itemHandler = (IItemHandler)tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.DOWN)) != null) {
            for (i = 0; i < this.outItems.getSlots(); ++i) {
                stack = this.outItems.getStackInSlot(i);
                if (stack.func_190926_b()) continue;
                ItemStack remainder = ItemHandlerHelper.insertItem((IItemHandler)itemHandler, (ItemStack)stack, (boolean)false);
                this.outItems.setStackInSlot(i, remainder);
            }
        }
        return didWork ? 1.0f : 0.0f;
    }

    private ItemStack getFirstItem() {
        for (int i = 0; i < this.outItems.getSlots(); ++i) {
            if (this.outItems.getStackInSlot(i).func_190926_b()) continue;
            return this.outItems.getStackInSlot(i);
        }
        return ItemStack.field_190927_a;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        NBTTagCompound tagCompound = super.func_189515_b(compound);
        tagCompound.func_74768_a(NBT_POINTER, this.pointer);
        tagCompound.func_74768_a(NBT_OPERATION, this.operationAmount);
        tagCompound.func_74778_a(NBT_TYPE, this.type.name());
        return tagCompound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.pointer = compound.func_74762_e(NBT_POINTER);
        this.operationAmount = compound.func_74762_e(NBT_OPERATION);
        this.type = PlantRecollectable.Type.ANY;
        if (compound.func_74764_b(NBT_TYPE)) {
            this.type = PlantRecollectable.Type.valueOf(compound.func_74779_i(NBT_TYPE));
        }
    }

    private void insertItems(List<ItemStack> drops, ItemStackHandler outItems) {
        for (ItemStack stack : drops) {
            ItemHandlerHelper.insertItem((IItemHandler)outItems, (ItemStack)stack, (boolean)false);
        }
    }

    protected boolean acceptsFluidItem(ItemStack stack) {
        return ItemStackUtils.acceptsFluidItem(stack);
    }

    public boolean hasShearingAddon() {
        return this.type == PlantRecollectable.Type.LEAVES;
    }

    @Override
    public List<IGuiContainerPiece> getGuiContainerPieces(BasicTeslaGuiContainer container) {
        List<IGuiContainerPiece> pieces = super.getGuiContainerPieces(container);
        pieces.add((IGuiContainerPiece)new ToggleButtonPiece(118, 84, 13, 13, 0){

            protected int getCurrentState() {
                return CropRecolectorTile.this.type.ordinal();
            }

            protected void renderState(BasicTeslaGuiContainer container, int state, BoundingRectangle box) {
            }

            public void drawBackgroundLayer(BasicTeslaGuiContainer container, int guiX, int guiY, float partialTicks, int mouseX, int mouseY) {
                super.drawBackgroundLayer(container, guiX, guiY, partialTicks, mouseX, mouseY);
                container.field_146297_k.func_110434_K().func_110577_a(ClientProxy.GUI);
                container.drawTexturedRect(this.getLeft() - 1, this.getTop() - 1, 49, 56, 16, 16);
                if (CropRecolectorTile.this.type == PlantRecollectable.Type.TREE) {
                    ItemStackUtils.renderItemIntoGUI(new ItemStack(Blocks.field_150345_g, 1, 4), this.getLeft() + guiX - 2, this.getTop() + guiY - 3, 9);
                } else if (CropRecolectorTile.this.type == PlantRecollectable.Type.LEAVES) {
                    ItemStackUtils.renderItemIntoGUI(new ItemStack((Item)Items.field_151097_aZ, 1, 0), this.getLeft() + guiX - 2, this.getTop() + guiY - 3, 9);
                } else if (CropRecolectorTile.this.type == PlantRecollectable.Type.PLANT) {
                    ItemStackUtils.renderItemIntoGUI(new ItemStack(Items.field_151075_bm), this.getLeft() + guiX - 2, this.getTop() + guiY - 2, 9);
                } else {
                    ItemStackUtils.renderItemIntoGUI(new ItemStack(Items.field_151075_bm), this.getLeft() + guiX, this.getTop() + guiY - 3, 9);
                    ItemStackUtils.renderItemIntoGUI(new ItemStack(Blocks.field_150345_g, 1, 1), this.getLeft() + guiX - 2, this.getTop() + guiY - 4, 8);
                }
            }

            protected void clicked() {
                CropRecolectorTile.this.sendToServer(CropRecolectorTile.this.setupSpecialNBTMessage("NEXT_PLANT_TYPE"));
            }

            @NotNull
            protected List<String> getStateToolTip(int state) {
                return Arrays.asList(new TextComponentTranslation("text.industrialforegoing.button.gather." + CropRecolectorTile.this.type.name().toLowerCase(), new Object[0]).func_150254_d());
            }
        });
        return pieces;
    }

    @Nullable
    protected SimpleNBTMessage processClientMessage(@Nullable String messageType, @NotNull NBTTagCompound compound) {
        if (messageType != null && messageType.equalsIgnoreCase("NEXT_PLANT_TYPE")) {
            this.type = PlantRecollectable.Type.values()[(this.type.ordinal() + 1) % PlantRecollectable.Type.values().length];
            this.func_70296_d();
            this.forceSync();
        }
        return super.processClientMessage(messageType, compound);
    }

    public void harvestDrops(BlockEvent.HarvestDropsEvent event) {
        for (ItemStack stack : event.getDrops()) {
            ItemHandlerHelper.insertItem((IItemHandler)this.outItems, (ItemStack)stack, (boolean)false);
        }
        event.getDrops().clear();
        this.didWork = true;
    }
}

