/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.proxy.client.infopiece;

import com.buuz135.industrial.proxy.client.ClientProxy;
import com.buuz135.industrial.tile.misc.DyeMixerTile;
import java.util.Arrays;
import net.minecraft.item.EnumDyeColor;
import net.ndrei.teslacorelib.gui.BasicRenderedGuiPiece;
import net.ndrei.teslacorelib.gui.BasicTeslaGuiContainer;

public class DyeTankInfoPiece
extends BasicRenderedGuiPiece {
    private DyeMixerTile tile;
    private EnumDyeColor color;

    public DyeTankInfoPiece(DyeMixerTile tile, EnumDyeColor color, int left, int top, int textureX, int textureY) {
        super(left, top, 18, 33, ClientProxy.GUI, textureX, textureY);
        this.tile = tile;
        this.color = color;
    }

    public void drawBackgroundLayer(BasicTeslaGuiContainer container, int guiX, int guiY, float partialTicks, int mouseX, int mouseY) {
        super.drawBackgroundLayer(container, guiX, guiY, partialTicks, mouseX, mouseY);
        container.field_146297_k.func_110434_K().func_110577_a(ClientProxy.GUI);
        double amount = (double)this.tile.getRainbow() / 100.0;
        int guiLeft = this.getLeft() + 3;
        int guiRight = (int)((double)(this.getTop() + 3) + (27.0 - 27.0 * amount));
        int textureX = 125 + 18 * this.getModifier();
        int textureY = (int)(105.0 + (27.0 - 27.0 * amount));
        int width = 12;
        int height = (int)(amount * 27.0);
        container.drawTexturedRect(guiLeft, guiRight, textureX, textureY, width, height);
    }

    public void drawForegroundLayer(BasicTeslaGuiContainer container, int guiX, int guiY, int mouseX, int mouseY) {
        super.drawForegroundLayer(container, guiX, guiY, mouseX, mouseY);
        int amount = this.tile.getRainbow();
        if (this.isInside(container, mouseX, mouseY)) {
            container.drawTooltip(Arrays.asList("Rainbow Dye Remaining: " + amount), mouseX - guiX, mouseY - guiY);
        }
    }

    private int getModifier() {
        return this.color == EnumDyeColor.RED ? 0 : (this.color == EnumDyeColor.GREEN ? 1 : 2);
    }
}

