/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.addons.minecraft;

import com.rwtema.extrautils2.backend.entries.XU2Entries;
import com.rwtema.extrautils2.blocks.BlockEnderLilly;
import java.util.List;
import javax.annotation.Nonnull;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.IWailaRegistrar;
import mcp.mobius.waila.cbcore.LangUtil;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockSilverfish;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemRecord;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;

public class HUDHandlerVanilla
implements IWailaDataProvider {
    static Block mobSpawner = Blocks.field_150474_ac;
    static Block crops = Blocks.field_150464_aj;
    static Block beet = Blocks.field_185773_cZ;
    static Block farmland = Blocks.field_150458_ak;
    static Block melonStem = Blocks.field_150394_bc;
    static Block pumpkinStem = Blocks.field_150393_bb;
    static Block lever = Blocks.field_150442_at;
    static Block repeaterIdle = Blocks.field_150413_aR;
    static Block repeaterActv = Blocks.field_150416_aS;
    static Block comparatorIdl = Blocks.field_150441_bU;
    static Block comparatorAct = Blocks.field_150455_bV;
    static Block redstone = Blocks.field_150488_af;
    static Block jukebox = Blocks.field_150421_aI;
    static Block cocoa = Blocks.field_150375_by;
    static Block netherwart = Blocks.field_150388_bm;
    static Block silverfish = Blocks.field_150418_aU;
    static Block enderlilly = (Block)XU2Entries.blockEnderLilly.value;
    public final PropertyInteger GROWTH_STATE = PropertyInteger.func_177719_a((String)"growth", (int)0, (int)7);

    public static void register(IWailaRegistrar registrar) {
        registrar.addConfig("VanillaMC", "vanilla.spawntype");
        registrar.addConfig("VanillaMC", "vanilla.leverstate");
        registrar.addConfig("VanillaMC", "vanilla.repeater");
        registrar.addConfig("VanillaMC", "vanilla.comparator");
        registrar.addConfig("VanillaMC", "vanilla.redstone");
        registrar.addConfig("VanillaMC", "vanilla.silverfish");
        registrar.addConfigRemote("VanillaMC", "vanilla.jukebox");
        HUDHandlerVanilla provider = new HUDHandlerVanilla();
        registrar.registerStackProvider(provider, silverfish.getClass());
        registrar.registerStackProvider(provider, crops.getClass());
        registrar.registerStackProvider(provider, beet.getClass());
        registrar.registerStackProvider(provider, farmland.getClass());
        registrar.registerHeadProvider(provider, mobSpawner.getClass());
        registrar.registerHeadProvider(provider, melonStem.getClass());
        registrar.registerHeadProvider(provider, pumpkinStem.getClass());
        registrar.registerHeadProvider(provider, redstone.getClass());
        registrar.registerBodyProvider(provider, BlockCrops.class);
        registrar.registerBodyProvider(provider, melonStem.getClass());
        registrar.registerBodyProvider(provider, pumpkinStem.getClass());
        registrar.registerBodyProvider(provider, cocoa.getClass());
        registrar.registerBodyProvider(provider, BlockEnderLilly.class);
        registrar.registerBodyProvider(provider, netherwart.getClass());
        registrar.registerBodyProvider(provider, lever.getClass());
        registrar.registerBodyProvider(provider, repeaterIdle.getClass());
        registrar.registerBodyProvider(provider, repeaterActv.getClass());
        registrar.registerBodyProvider(provider, comparatorIdl.getClass());
        registrar.registerBodyProvider(provider, comparatorAct.getClass());
        registrar.registerBodyProvider(provider, redstone.getClass());
        registrar.registerBodyProvider(provider, jukebox.getClass());
        registrar.registerNBTProvider(provider, jukebox.getClass());
    }

    private static void addMaturityTooltip(List<String> currentTip, float growthValue) {
        if ((growthValue *= 100.0f) < 100.0f) {
            currentTip.add(LangUtil.translateG("hud.msg.growth", new Object[0]) + " : " + LangUtil.translateG("hud.msg.growth.value", (int)growthValue));
        } else {
            currentTip.add(LangUtil.translateG("hud.msg.growth", new Object[0]) + " : " + LangUtil.translateG("hud.msg.mature", new Object[0]));
        }
    }

    @Override
    @Nonnull
    public ItemStack getWailaStack(IWailaDataAccessor accessor, IWailaConfigHandler config) {
        Block block = accessor.getBlock();
        if (block == silverfish && config.getConfig("vanilla.silverfish")) {
            BlockSilverfish.EnumType type = (BlockSilverfish.EnumType)accessor.getBlockState().func_177229_b((IProperty)BlockSilverfish.field_176378_a);
            return type.func_176883_d().func_177230_c().getPickBlock(type.func_176883_d(), accessor.getMOP(), accessor.getWorld(), accessor.getPosition(), accessor.getPlayer());
        }
        if (block == crops) {
            return new ItemStack(Items.field_151015_O);
        }
        if (block == beet) {
            return new ItemStack(Items.field_185164_cV);
        }
        if (block == farmland) {
            return new ItemStack(Blocks.field_150458_ak);
        }
        return ItemStack.field_190927_a;
    }

    @Override
    @Nonnull
    public List<String> getWailaHead(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        String name;
        Block block = accessor.getBlock();
        if (block == mobSpawner && accessor.getTileEntity() instanceof TileEntityMobSpawner && config.getConfig("vanilla.spawntype")) {
            name = currenttip.get(0);
            String mobname = ((TileEntityMobSpawner)accessor.getTileEntity()).func_145881_a().func_184994_d().func_70005_c_();
            currenttip.set(0, String.format("%s (%s)", name, mobname));
        }
        if (block == redstone) {
            name = currenttip.get(0).replaceFirst(String.format(" %s", accessor.getMetadata()), "");
            currenttip.set(0, name);
        }
        if (block == melonStem) {
            currenttip.set(0, TextFormatting.WHITE + I18n.func_74838_a((String)"hud.item.melonstem"));
        }
        if (block == pumpkinStem) {
            currenttip.set(0, TextFormatting.WHITE + I18n.func_74838_a((String)"hud.item.pumpkinstem"));
        }
        return currenttip;
    }

    @Override
    @Nonnull
    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        Block block = accessor.getBlock();
        if (config.getConfig("general.showcrop")) {
            if (BlockCrops.class.isInstance(block)) {
                HUDHandlerVanilla.addMaturityTooltip(currenttip, (float)accessor.getMetadata() / (float)((BlockCrops)block).func_185526_g());
            } else if (block == melonStem || block == pumpkinStem) {
                HUDHandlerVanilla.addMaturityTooltip(currenttip, (float)accessor.getMetadata() / 7.0f);
            } else if (block == cocoa) {
                HUDHandlerVanilla.addMaturityTooltip(currenttip, (float)(accessor.getMetadata() >> 2) / 2.0f);
            } else if (block == netherwart) {
                HUDHandlerVanilla.addMaturityTooltip(currenttip, (float)accessor.getMetadata() / 3.0f);
            } else if (block == enderlilly) {
                int i = (Integer)accessor.getBlockState().func_177229_b((IProperty)this.GROWTH_STATE);
                HUDHandlerVanilla.addMaturityTooltip(currenttip, (float)i / 7.0f);
            }
        }
        if (config.getConfig("vanilla.leverstate") && block == lever) {
            String redstoneOn = (accessor.getMetadata() & 8) == 0 ? LangUtil.translateG("hud.msg.off", new Object[0]) : LangUtil.translateG("hud.msg.on", new Object[0]);
            currenttip.add(String.format("%s : %s", LangUtil.translateG("hud.msg.state", new Object[0]), redstoneOn));
            return currenttip;
        }
        if (config.getConfig("vanilla.repeater") && (block == repeaterIdle || block == repeaterActv)) {
            int tick = (accessor.getMetadata() >> 2) + 1;
            if (tick == 1) {
                currenttip.add(String.format("%s : %s tick", LangUtil.translateG("hud.msg.delay", new Object[0]), tick));
            } else {
                currenttip.add(String.format("%s : %s ticks", LangUtil.translateG("hud.msg.delay", new Object[0]), tick));
            }
            return currenttip;
        }
        if (config.getConfig("vanilla.comparator") && (block == comparatorIdl || block == comparatorAct)) {
            String mode = (accessor.getMetadata() >> 2 & 1) == 0 ? LangUtil.translateG("hud.msg.comparator", new Object[0]) : LangUtil.translateG("hud.msg.substractor", new Object[0]);
            currenttip.add("Mode : " + mode);
            return currenttip;
        }
        if (config.getConfig("vanilla.redstone") && block == redstone) {
            currenttip.add(String.format("%s : %s", LangUtil.translateG("hud.msg.power", new Object[0]), accessor.getMetadata()));
            return currenttip;
        }
        if (config.getConfig("vanilla.jukebox") && block == jukebox) {
            NBTTagCompound tag = accessor.getNBTData();
            if (tag.func_150297_b("RecordItem", 10)) {
                Item record = new ItemStack(tag.func_74775_l("RecordItem")).func_77973_b();
                currenttip.add(LangUtil.translateG("record.nowPlaying", ((ItemRecord)record).func_150927_i()));
            } else {
                currenttip.add(LangUtil.translateG("hud.msg.empty", new Object[0]));
            }
        }
        return currenttip;
    }

    @Override
    @Nonnull
    public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity te, NBTTagCompound tag, World world, BlockPos pos) {
        return te.func_189515_b(tag);
    }
}

