/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.huntingdim.handler;

import java.util.UUID;
import net.darkhax.bookshelf.data.AttributeOperation;
import net.darkhax.bookshelf.util.MathsUtils;
import net.darkhax.bookshelf.util.PotionUtils;
import net.darkhax.bookshelf.util.WorldUtils;
import net.darkhax.huntingdim.HuntingDimension;
import net.darkhax.huntingdim.handler.ConfigurationHandler;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.living.LootingLevelEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class DimensionEffectHandler {
    public static final AttributeModifier BUFF_ARMOR = new AttributeModifier(UUID.fromString("054ab076-0a2e-4ea4-b525-b201fcf4a2a7"), "buff_hunting_armor", (double)ConfigurationHandler.buffArmor, AttributeOperation.ADDITIVE.ordinal());
    public static final AttributeModifier BUFF_HEALTH = new AttributeModifier(UUID.fromString("d52efdc2-53fc-42ab-80ed-9fe79d219ff7"), "buff_hunting_health", (double)ConfigurationHandler.buffHealth, AttributeOperation.MULTIPLY.ordinal());
    public static final AttributeModifier BUFF_ATTACK = new AttributeModifier(UUID.fromString("d86f9cdc-8a12-492a-a0ad-e8cdded32ab7"), "buff_hunting_attack", (double)ConfigurationHandler.buffAttack, AttributeOperation.MULTIPLY.ordinal());
    public static final AttributeModifier BUFF_SPEED = new AttributeModifier(UUID.fromString("dd6f9ddd-8a12-492a-a0ad-e8cdded32ab7"), "buff_hunting_speed", (double)ConfigurationHandler.buffSpeed, AttributeOperation.MULTIPLY.ordinal());

    @SubscribeEvent
    public void onExpCalculated(LivingExperienceDropEvent event) {
        if (event.getEntityLiving() != null && event.getEntityLiving().field_71093_bK == ConfigurationHandler.dimensionId && MathsUtils.tryPercentage((double)ConfigurationHandler.expChance)) {
            int additional = (int)((double)event.getOriginalExperience() * ConfigurationHandler.expMultiplier / (double)event.getOriginalExperience());
            event.setDroppedExperience(additional);
        }
    }

    @SubscribeEvent
    public void onLootingCalculated(LootingLevelEvent event) {
        if (event.getEntityLiving() != null && event.getEntityLiving().field_71093_bK == ConfigurationHandler.dimensionId && MathsUtils.tryPercentage((double)ConfigurationHandler.lootingChance)) {
            event.setLootingLevel(event.getLootingLevel() + 1);
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorld(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntityLiving() instanceof IMob && event.getEntityLiving().field_71093_bK == ConfigurationHandler.dimensionId) {
            EntityLivingBase entity = event.getEntityLiving();
            this.applyModifier(entity, BUFF_ARMOR, SharedMonsterAttributes.field_188791_g);
            this.applyModifier(entity, BUFF_HEALTH, SharedMonsterAttributes.field_111267_a);
            this.applyModifier(entity, BUFF_ATTACK, SharedMonsterAttributes.field_111264_e);
            this.applyModifier(entity, BUFF_SPEED, SharedMonsterAttributes.field_111263_d);
        }
    }

    private void applyModifier(EntityLivingBase entity, AttributeModifier modifier, IAttribute attribute) {
        ModifiableAttributeInstance attrInst;
        if (modifier.func_111164_d() > 0.0 && (attrInst = (ModifiableAttributeInstance)entity.func_110148_a(attribute)) != null && !attrInst.func_180374_a(modifier)) {
            attrInst.func_111121_a(modifier);
            if (attribute == SharedMonsterAttributes.field_111267_a) {
                entity.func_70691_i(entity.func_110138_aP());
            }
        }
    }

    @SubscribeEvent
    public void onSpawnCheck(LivingSpawnEvent.CheckSpawn event) {
        if (event.isSpawner()) {
            return;
        }
        if (!ConfigurationHandler.allowPeacefulInHunting && event.getEntityLiving() instanceof EntityAnimal && WorldUtils.isDimension((World)event.getWorld(), (DimensionType)HuntingDimension.dimensionType)) {
            event.setResult(Event.Result.DENY);
        } else if (!ConfigurationHandler.allowHostileInOverworld && event.getEntityLiving() instanceof IMob && WorldUtils.isDimension((World)event.getWorld(), (DimensionType)DimensionType.OVERWORLD)) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayer && !((EntityPlayer)event.getEntityLiving()).field_71075_bZ.field_75098_d && ConfigurationHandler.quickPotionWearOff && event.getEntityLiving().field_71093_bK == ConfigurationHandler.dimensionId) {
            for (PotionEffect effect : event.getEntityLiving().func_70651_bq()) {
                if (!PotionUtils.isBeneficial((Potion)effect.func_188419_a()) || effect.func_82720_e()) continue;
                PotionUtils.deincrementDuration((PotionEffect)effect);
            }
        }
    }
}

