/*
 * Decompiled with CFR 0.152.
 */
package elec332.huds.proxy;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import elec332.core.ElecCore;
import elec332.core.api.config.IConfigurableElement;
import elec332.core.api.registry.ISingleRegister;
import elec332.core.config.ConfigWrapper;
import elec332.core.hud.AbstractHud;
import elec332.huds.Huds;
import elec332.huds.client.GuiFactory;
import elec332.huds.client.hud.armor.ArmorHud;
import elec332.huds.proxy.CommonProxy;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.ConfigElement;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.config.IConfigElement;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

public class ClientProxy
extends CommonProxy {
    private static ClientProxy instance;
    public static ConfigWrapper config;
    private final Set<WrappedHud> huds = Sets.newHashSet();

    public ClientProxy() {
        instance = this;
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public static List<IConfigElement> getCategories() {
        return ClientProxy.instance.huds.stream().map(wrappedHud -> new ConfigElement(config.getConfiguration().getCategory(((WrappedHud)wrappedHud).category))).collect(Collectors.toList());
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("huds")) {
            config.refresh(false);
        }
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        Huds.logger.info("PreInitializing...");
        config = new ConfigWrapper(new Configuration(event.getSuggestedConfigurationFile()));
        this.registerHuds(this.huds);
        for (WrappedHud hud : this.huds) {
            config.registerConfigurableElement((IConfigurableElement)hud);
        }
        config.refresh();
    }

    private void registerHuds(Set<WrappedHud> huds) {
        huds.add(new WrappedHud((AbstractHud)new ArmorHud(), "ArmorHud"));
    }

    @Override
    public void registerClientCommands(ISingleRegister<ICommand> commandRegistry) {
        commandRegistry.register((Object)new CommandBase(){
            static final String show = "show";
            static final String reload = "reload";

            @Nonnull
            public String func_71517_b() {
                return "hudconfig";
            }

            @Nonnull
            public String func_71518_a(@Nonnull ICommandSender sender) {
                return "hudconfig <show|reload>";
            }

            @Nonnull
            public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
                return Lists.newArrayList((Object[])new String[]{show, reload});
            }

            public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
                return true;
            }

            public void func_184881_a(@Nonnull MinecraftServer server, @Nonnull ICommandSender sender, @Nonnull String[] args) throws CommandException {
                if (sender instanceof EntityPlayer) {
                    if (args.length != 1) {
                        throw new CommandException(args.length == 0 ? "No argument provided." : "Too many arguments provided: " + Lists.newArrayList((Object[])args), new Object[0]);
                    }
                    switch (args[0]) {
                        case "show": {
                            ElecCore.tickHandler.registerCall(() -> Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiFactory.ConfigGui(Minecraft.func_71410_x().field_71462_r)), Side.CLIENT);
                            break;
                        }
                        case "reload": {
                            config.refresh();
                        }
                    }
                }
            }
        });
    }

    private class WrappedHud
    implements IConfigurableElement {
        private final AbstractHud hud;
        private final String category;
        private boolean enabled = true;
        private boolean registered = true;

        private WrappedHud(AbstractHud hud, String config) {
            this.category = config;
            this.hud = hud.setConfigCategory(this.category);
        }

        public void reconfigure(Configuration config) {
            this.hud.reconfigure(config);
            this.enabled = config.getBoolean("enabled", this.hud.getConfigCategory(), true, "Sets whether this HUD will be shown in-game.");
            this.check();
        }

        private void check() {
            if (this.registered != this.enabled) {
                if (this.enabled) {
                    MinecraftForge.EVENT_BUS.register((Object)this.hud);
                } else {
                    MinecraftForge.EVENT_BUS.unregister((Object)this.hud);
                }
            }
            this.registered = this.enabled;
        }

        WrappedHud(AbstractHud x1, String x2, Object x3) {
            this(x1, x2);
        }
    }
}

