/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.horsepower.jei;

import com.google.common.collect.ImmutableList;
import java.util.List;
import mezz.jei.api.gui.IGuiIngredientGroup;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.api.recipe.IStackHelper;
import mezz.jei.api.recipe.wrapper.ICustomCraftingRecipeWrapper;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraftforge.oredict.OreDictionary;
import se.gory_moon.horsepower.Configs;
import se.gory_moon.horsepower.blocks.BlockChopper;
import se.gory_moon.horsepower.blocks.BlockHPChoppingBase;
import se.gory_moon.horsepower.jei.HorsePowerPlugin;
import se.gory_moon.horsepower.recipes.ShapelessChoppingRecipe;

public class ShapelessChoppingCraftingWrapper
implements IRecipeWrapper,
ICustomCraftingRecipeWrapper {
    private final ShapelessChoppingRecipe recipe;
    private final List<List<ItemStack>> outputs;

    public ShapelessChoppingCraftingWrapper(ShapelessChoppingRecipe recipe) {
        this.recipe = recipe;
        for (Object input : this.recipe.func_192400_c()) {
            ItemStack itemStack;
            if (!(input instanceof ItemStack) || (itemStack = (ItemStack)input).func_190916_E() == 1) continue;
            itemStack.func_190920_e(1);
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ItemStack stack : recipe.outputBlocks) {
            BlockHPChoppingBase block = (BlockHPChoppingBase)Block.func_149634_a((Item)recipe.getSimpleRecipeOutput().func_77973_b());
            if (!Configs.general.useDynamicCrafting && !"minecraft".equals(stack.func_77973_b().getRegistryName().func_110624_b())) {
                builder.add((Object)BlockHPChoppingBase.createItemStack(block, recipe.getSimpleRecipeOutput().func_190916_E(), new ItemStack(Blocks.field_150364_r)));
                break;
            }
            if (stack.func_77952_i() == Short.MAX_VALUE) {
                for (ItemStack sub : HorsePowerPlugin.jeiHelpers.getStackHelper().getSubtypes(stack)) {
                    builder.add((Object)BlockHPChoppingBase.createItemStack(block, recipe.getSimpleRecipeOutput().func_190916_E(), sub));
                }
                continue;
            }
            if (Block.func_149634_a((Item)stack.func_77973_b()) instanceof BlockHPChoppingBase) {
                NonNullList stacks = NonNullList.func_191196_a();
                Block.func_149634_a((Item)stack.func_77973_b()).func_149666_a(null, stacks);
                for (ItemStack sub : stacks) {
                    builder.add((Object)BlockHPChoppingBase.createItemStack(block, recipe.getSimpleRecipeOutput().func_190916_E(), sub));
                }
                continue;
            }
            builder.add((Object)BlockHPChoppingBase.createItemStack(block, recipe.getSimpleRecipeOutput().func_190916_E(), stack));
        }
        this.outputs = ImmutableList.of((Object)builder.build());
    }

    public void getIngredients(IIngredients ingredients) {
        IStackHelper stackHelper = HorsePowerPlugin.jeiHelpers.getStackHelper();
        List inputs = stackHelper.expandRecipeItemStackInputs((List)this.recipe.func_192400_c());
        ingredients.setInputLists(ItemStack.class, inputs);
        if (!this.outputs.isEmpty()) {
            ingredients.setOutputLists(ItemStack.class, this.outputs);
        }
    }

    private boolean isOutputBlock(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        for (ItemStack output : this.recipe.outputBlocks) {
            if (!OreDictionary.itemMatches((ItemStack)output, (ItemStack)stack, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    public void setRecipe(IRecipeLayout recipeLayout, IIngredients ingredients) {
        recipeLayout.setShapeless();
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        List inputs = ingredients.getInputs(ItemStack.class);
        List outputs = (List)ingredients.getOutputs(ItemStack.class).get(0);
        IFocus ifocus = recipeLayout.getFocus();
        Object focusObj = ifocus.getValue();
        if (focusObj instanceof ItemStack) {
            IGuiIngredientGroup guiIngredients = recipeLayout.getIngredientsGroup(ItemStack.class);
            ItemStack focus = (ItemStack)focusObj;
            IFocus.Mode mode = ifocus.getMode();
            if (mode == IFocus.Mode.INPUT && this.isOutputBlock(focus)) {
                BlockHPChoppingBase block = (BlockHPChoppingBase)Block.func_149634_a((Item)this.recipe.getSimpleRecipeOutput().func_77973_b());
                ItemStack outputFocus = BlockChopper.createItemStack(block, 1, focus);
                guiIngredients.setOverrideDisplayFocus(HorsePowerPlugin.recipeRegistry.createFocus(IFocus.Mode.OUTPUT, (Object)outputFocus));
            } else if (mode == IFocus.Mode.OUTPUT) {
                ItemStack base = new ItemStack(focus.func_77942_o() ? focus.func_77978_p().func_74775_l("textureBlock") : new NBTTagCompound());
                if (Block.func_149634_a((Item)this.recipe.outputBlocks.get(0).func_77973_b()) instanceof BlockHPChoppingBase) {
                    base = this.recipe.outputBlocks.get(0).func_77946_l();
                    NBTTagCompound tag = new NBTTagCompound();
                    tag.func_74782_a("textureBlock", (NBTBase)(focus.func_77942_o() ? focus.func_77978_p().func_74775_l("textureBlock") : new NBTTagCompound()));
                    base.func_77982_d(tag);
                }
                if (!base.func_190926_b()) {
                    guiIngredients.setOverrideDisplayFocus(HorsePowerPlugin.recipeRegistry.createFocus(IFocus.Mode.INPUT, (Object)base));
                }
            }
        }
        HorsePowerPlugin.craftingGridHelper.setInputs((IGuiIngredientGroup)guiItemStacks, inputs);
        recipeLayout.getItemStacks().set(0, outputs);
    }
}

