/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.horsepower.client.model;

import com.google.common.base.Function;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.SimpleModelState;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import org.apache.commons.lang3.tuple.Pair;
import se.gory_moon.horsepower.blocks.BlockChopper;
import se.gory_moon.horsepower.blocks.BlockHPChoppingBase;
import se.gory_moon.horsepower.client.model.TRSRBakedModel;
import se.gory_moon.horsepower.util.RenderUtils;

public class BakedChopperModel
implements IBakedModel {
    private final IBakedModel standard;
    private final IModel choppingModel;
    private final VertexFormat format;
    private final ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms;
    private final Map<String, IBakedModel> cache = Maps.newHashMap();
    private final Function<ResourceLocation, TextureAtlasSprite> textureGetter;
    private final Cache<TableCombinationCacheKey, IBakedModel> tableCombinedCache = CacheBuilder.newBuilder().maximumSize(20L).build();

    public BakedChopperModel(IBakedModel standard, IModel choppingModel, VertexFormat format) {
        this.standard = standard;
        this.choppingModel = choppingModel;
        this.format = format;
        this.transforms = RenderUtils.getTransforms(standard);
        this.textureGetter = location -> {
            assert (location != null);
            return Minecraft.func_71410_x().func_147117_R().func_110572_b(location.toString());
        };
    }

    protected IBakedModel getActualModel(String texture, String top_texture, EnumFacing facing) {
        IBakedModel bakedModel = this.standard;
        if (texture != null) {
            if (this.cache.containsKey(texture)) {
                bakedModel = this.cache.get(texture);
            } else if (this.choppingModel != null) {
                ImmutableMap.Builder builder = ImmutableMap.builder();
                builder.put((Object)"2", (Object)texture);
                builder.put((Object)"1", (Object)top_texture);
                IModel retexturedModel = this.choppingModel.retexture(builder.build());
                SimpleModelState modelState = new SimpleModelState(this.transforms);
                bakedModel = retexturedModel.bake((IModelState)modelState, this.format, this.textureGetter);
                this.cache.put(texture, bakedModel);
            }
        }
        IBakedModel parentModel = bakedModel;
        try {
            bakedModel = (IBakedModel)this.tableCombinedCache.get((Object)new TableCombinationCacheKey(bakedModel, facing), () -> this.getCombinedBakedModel(facing, parentModel));
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
        return bakedModel;
    }

    private IBakedModel getCombinedBakedModel(EnumFacing facing, IBakedModel parentModel) {
        IBakedModel out = parentModel;
        if (facing != null) {
            out = new TRSRBakedModel(out, facing);
        }
        return out;
    }

    public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        String side_texture = null;
        String top_texture = null;
        EnumFacing face = EnumFacing.SOUTH;
        if (state instanceof IExtendedBlockState) {
            IExtendedBlockState extendedState = (IExtendedBlockState)state;
            if (extendedState.getUnlistedNames().contains(BlockHPChoppingBase.SIDE_TEXTURE)) {
                side_texture = (String)extendedState.getValue((IUnlistedProperty)BlockHPChoppingBase.SIDE_TEXTURE);
            }
            if (extendedState.getUnlistedNames().contains(BlockHPChoppingBase.TOP_TEXTURE)) {
                top_texture = (String)extendedState.getValue((IUnlistedProperty)BlockHPChoppingBase.TOP_TEXTURE);
            }
            if (extendedState.func_177227_a().contains(BlockChopper.FACING)) {
                face = (EnumFacing)extendedState.func_177229_b((IProperty)BlockChopper.FACING);
            }
        }
        if (side_texture == null) {
            return this.standard.func_188616_a(state, side, rand);
        }
        return this.getActualModel(side_texture, top_texture, face).func_188616_a(state, side, rand);
    }

    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
        Pair pair = this.standard.handlePerspective(cameraTransformType);
        return Pair.of((Object)this, (Object)pair.getRight());
    }

    public boolean func_177555_b() {
        return this.standard.func_177555_b();
    }

    public boolean func_177556_c() {
        return this.standard.func_177556_c();
    }

    public boolean func_188618_c() {
        return this.standard.func_188618_c();
    }

    public TextureAtlasSprite func_177554_e() {
        return this.standard.func_177554_e();
    }

    public ItemCameraTransforms func_177552_f() {
        return this.standard.func_177552_f();
    }

    public ItemOverrideList func_188617_f() {
        return ChopperItemOverrideList.INSTANCE;
    }

    private static class TableCombinationCacheKey {
        private final IBakedModel bakedBaseModel;
        private final EnumFacing facing;

        public TableCombinationCacheKey(IBakedModel bakedBaseModel, EnumFacing facing) {
            this.bakedBaseModel = bakedBaseModel;
            this.facing = facing;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TableCombinationCacheKey that = (TableCombinationCacheKey)o;
            return (this.bakedBaseModel != null ? this.bakedBaseModel.equals(that.bakedBaseModel) : that.bakedBaseModel == null) && this.facing == that.facing;
        }

        public int hashCode() {
            int result = this.bakedBaseModel != null ? this.bakedBaseModel.hashCode() : 0;
            result = 31 * result + (this.facing != null ? this.facing.hashCode() : 0);
            return result;
        }
    }

    private static class ChopperItemOverrideList
    extends ItemOverrideList {
        static ChopperItemOverrideList INSTANCE = new ChopperItemOverrideList();

        private ChopperItemOverrideList() {
            super((List)ImmutableList.of());
        }

        @Nonnull
        public IBakedModel handleItemState(@Nonnull IBakedModel originalModel, ItemStack stack, World world, EntityLivingBase entity) {
            ItemStack blockStack;
            if (originalModel instanceof BakedChopperModel && !(blockStack = new ItemStack(stack.func_77942_o() ? stack.func_77978_p().func_74775_l("textureBlock") : new NBTTagCompound())).func_190926_b()) {
                Block block = Block.func_149634_a((Item)blockStack.func_77973_b());
                IBlockState state = block.func_176203_a(blockStack.func_77952_i());
                String side_texture = RenderUtils.getTextureFromBlockstate(state).func_94215_i();
                String top_texture = RenderUtils.getTopTextureFromBlockstate(state).func_94215_i();
                return ((BakedChopperModel)originalModel).getActualModel(side_texture, top_texture, null);
            }
            return originalModel;
        }
    }
}

