/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.tile.tooltip.own;

import com.zeitheron.hammercore.tile.tooltip.own.IRenderableInfo;
import com.zeitheron.hammercore.tile.tooltip.own.ITooltip;
import com.zeitheron.hammercore.tile.tooltip.own.ITooltipProviderHC;
import com.zeitheron.hammercore.utils.WorldLocation;
import java.util.LinkedList;
import net.minecraft.entity.Entity;

public class GuiTooltip
implements ITooltip {
    public final LinkedList<TooltipLine> infos = new LinkedList();
    protected WorldLocation loc;
    protected Entity ent;
    protected int width;
    protected int height;

    protected void refresh() {
        this.width = 0;
        this.height = 0;
        for (int i = 0; i < this.infos.size(); ++i) {
            TooltipLine ln = this.infos.get(i);
            ln.refresh();
            this.width = Math.max(this.width, ln.width);
            this.height += ln.height;
        }
    }

    @Override
    public void append(IRenderableInfo info) {
        if (this.infos.isEmpty()) {
            this.newLine();
        }
        this.infos.getLast().addLast(info);
        this.refresh();
    }

    @Override
    public void newLine() {
        this.infos.addLast(new TooltipLine());
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public void render(float x, float y, float partialTime) {
        for (int i = 0; i < this.infos.size(); ++i) {
            TooltipLine ln = this.infos.get(i);
            ln.render(x, y, partialTime);
            y += (float)ln.height;
        }
    }

    @Override
    public void reset() {
        this.infos.clear();
        this.refresh();
    }

    @Override
    public WorldLocation getLocation() {
        return this.loc;
    }

    @Override
    public Entity getEntity() {
        return this.ent;
    }

    public GuiTooltip withLocation(WorldLocation loc) {
        this.loc = loc;
        return this;
    }

    public GuiTooltip withEntity(Entity ent) {
        this.ent = ent;
        return this;
    }

    public GuiTooltip withProvider(ITooltipProviderHC provider) {
        provider.addInformation(this);
        return this;
    }

    public static class TooltipLine
    extends LinkedList<IRenderableInfo> {
        protected int width;
        protected int height;

        public void render(float x, float y, float partialTime) {
            for (int i = 0; i < this.size(); ++i) {
                IRenderableInfo info = (IRenderableInfo)this.get(i);
                info.render(x, y + (float)((this.height - info.getHeight()) / 2), partialTime);
                x += (float)info.getWidth();
            }
        }

        protected void refresh() {
            this.width = 0;
            this.height = 0;
            for (int i = 0; i < this.size(); ++i) {
                IRenderableInfo info = (IRenderableInfo)this.get(i);
                this.width += info.getWidth();
                this.height = Math.max(this.height, info.getHeight());
            }
        }
    }
}

