/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.lib.zlib.weupnp;

import com.zeitheron.hammercore.lib.zlib.weupnp.AttuneResult;
import com.zeitheron.hammercore.lib.zlib.weupnp.EnumProtocol;
import com.zeitheron.hammercore.lib.zlib.weupnp.impl.GatewayDevice;
import com.zeitheron.hammercore.lib.zlib.weupnp.impl.GatewayDiscover;
import com.zeitheron.hammercore.lib.zlib.weupnp.impl.PortMappingEntry;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.logging.log4j.Logger;
import org.xml.sax.SAXException;

public class WeUPnP {
    GatewayDiscover gatewayDiscover;
    Map<InetAddress, GatewayDevice> gateways;
    GatewayDevice valid;
    ThreadLocal<PortMappingEntry> portMapping = ThreadLocal.withInitial(() -> new PortMappingEntry());

    public void setup() {
        this.gatewayDiscover = new GatewayDiscover();
    }

    public void discover() throws IOException, SAXException, ParserConfigurationException {
        this.gateways = this.gatewayDiscover.discover();
        Iterator<GatewayDevice> activeGW = this.gateways.values().iterator();
        while (activeGW.hasNext()) {
            activeGW.next();
        }
        this.valid = this.gatewayDiscover.getValidGateway();
    }

    public void logFound(Logger log) {
        if (this.gateways == null) {
            throw new RuntimeException("WeUPnP.discover() wasn't called yet!");
        }
        if (this.gateways.isEmpty()) {
            log.warn("No gateways found");
            log.warn("Stopping weupnp");
        } else {
            log.info(this.gateways.size() + " gateway" + (this.gateways.size() != 1 ? "s" : "") + " found");
            int counter = 0;
            for (GatewayDevice portMapCount : this.gateways.values()) {
                log.info("Listing gateway details of device #" + ++counter + "\n\tFriendly name: " + portMapCount.getFriendlyName() + "\n\tPresentation URL: " + portMapCount.getPresentationURL() + "\n\tModel name: " + portMapCount.getModelName() + "\n\tModel number: " + portMapCount.getModelNumber() + "\n\tLocal interface address: " + portMapCount.getLocalAddress().getHostAddress() + (this.valid == portMapCount ? "\n\t::This gateway is going to be used." : ""));
            }
            if (this.valid == null) {
                log.error("Failed to find valid gateway! weUPnP won't work!");
            }
        }
    }

    public boolean isAttuned(EnumProtocol protocol, int extPort) throws IOException, SAXException {
        return this.valid.getSpecificPortMappingEntry(extPort, protocol.name(), this.portMapping.get());
    }

    public AttuneResult attune(EnumProtocol protocol, int intPort, int extPort, String desc) throws IOException, SAXException {
        return new AttuneResult(this, extPort, intPort, protocol, this.valid.addPortMapping(extPort, intPort, this.valid.getLocalAddress().getHostAddress(), protocol.name(), desc));
    }

    public boolean unattune(EnumProtocol protocol, int extPort) throws IOException, SAXException {
        return this.valid.deletePortMapping(extPort, protocol.name());
    }
}

