/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.internal.chunk;

import com.zeitheron.hammercore.internal.chunk.ChunkLoaderHC;
import com.zeitheron.hammercore.internal.chunk.ChunkPredicate;
import com.zeitheron.hammercore.world.WorldGenHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@Mod.EventBusSubscriber
public class ChunkloadAPI {
    private static ChunkPredicate predicate;
    public static List<Long> chunks;

    public static void addChunkLoader(ChunkPredicate.IChunkLoader loader) {
        predicate = new ChunkPredicate(predicate, loader);
    }

    @SubscribeEvent
    public static void serverTick(TickEvent.ServerTickEvent e) {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        for (int i = 0; i < chunks.size(); ++i) {
            BlockPos pos = BlockPos.func_177969_a((long)chunks.get(i));
            int dim = pos.func_177958_n();
            int x = pos.func_177956_o();
            int z = pos.func_177952_p();
            WorldServer ws = server.func_71218_a(dim);
            ws.func_72863_F().func_186025_d(x, z);
            chunks.remove(i);
            --i;
        }
        ArrayList<ChunkPredicate.LoadableChunk> chunks = ChunkloadAPI.getForcedChunks();
        for (int i = 0; i < chunks.size(); ++i) {
            ChunkPredicate.LoadableChunk c = chunks.get(i);
            WorldServer ws = server.func_71218_a(c.dim);
            ws.func_72863_F().func_186025_d(c.x, c.z);
        }
    }

    @SubscribeEvent
    public static void chunkUnload(ChunkEvent.Unload evt) {
        long l;
        Chunk c = evt.getChunk();
        if (ChunkloadAPI.shouldBeLoaded(c.func_177412_p(), c.field_76635_g, c.field_76647_h) && !chunks.contains(l = new BlockPos(c.func_177412_p().field_73011_w.getDimension(), c.field_76635_g, c.field_76647_h).func_177986_g())) {
            chunks.add(l);
        }
    }

    public static boolean shouldBeLoaded(World world, int x, int z) {
        if (predicate != null) {
            return predicate.isKeptLoaded(world, x, z);
        }
        return false;
    }

    public static ArrayList<ChunkPredicate.LoadableChunk> getForcedChunks() {
        if (predicate != null) {
            return predicate.getAllForcedChunks();
        }
        return new ArrayList<ChunkPredicate.LoadableChunk>();
    }

    static {
        ChunkloadAPI.addChunkLoader(ChunkLoaderHC.INSTANCE);
        ChunkloadAPI.addChunkLoader(WorldGenHelper.chunkLoader());
        chunks = new ArrayList<Long>();
    }
}

