/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.internal.blocks.base;

import com.zeitheron.hammercore.internal.blocks.base.BlockTileHC;
import com.zeitheron.hammercore.internal.blocks.base.IBlockEnableable;
import com.zeitheron.hammercore.internal.blocks.base.IBlockHorizontal;
import com.zeitheron.hammercore.internal.blocks.base.IBlockOrientable;
import com.zeitheron.hammercore.utils.WorldUtil;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BlockDeviceHC<T extends TileEntity>
extends BlockTileHC<T> {
    protected boolean reactsToRedstone;

    public BlockDeviceHC(Material mat, Class<T> tc, String name) {
        super(mat, tc, name);
        IBlockState bs = this.field_176227_L.func_177621_b();
        if (this instanceof IBlockHorizontal) {
            bs.func_177226_a((IProperty)IBlockHorizontal.FACING, (Comparable)EnumFacing.NORTH);
        } else if (this instanceof IBlockOrientable) {
            bs.func_177226_a((IProperty)IBlockOrientable.FACING, (Comparable)EnumFacing.UP);
        }
        if (this instanceof IBlockEnableable) {
            bs.func_177226_a((IProperty)IBlockEnableable.ENABLED, (Comparable)Boolean.valueOf(((IBlockEnableable)((Object)this)).enableableDefault()));
        }
        this.func_180632_j(bs);
    }

    public static void updateStateKeepTile(World world, BlockPos pos, IBlockState newState) {
        TileEntity tile = world.func_175625_s(pos);
        world.func_175713_t(pos);
        world.func_180501_a(pos, newState, 3);
        tile.func_145829_t();
        world.func_175690_a(pos, tile);
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        super.func_176213_c(worldIn, pos, state);
        this.updateState(worldIn, pos, state);
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos frompos) {
        this.updateState(worldIn, pos, state);
        super.func_189540_a(state, worldIn, pos, blockIn, frompos);
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        IBlockState bs = this.func_176223_P();
        if (this instanceof IBlockHorizontal) {
            bs = bs.func_177226_a((IProperty)IBlockHorizontal.FACING, (Comparable)(placer.func_70093_af() ? placer.func_174811_aO() : placer.func_174811_aO().func_176734_d()));
        }
        if (this instanceof IBlockOrientable) {
            bs = bs.func_177226_a((IProperty)IBlockOrientable.FACING, (Comparable)(placer.func_70093_af() ? EnumFacing.func_190914_a((BlockPos)pos, (EntityLivingBase)placer).func_176734_d() : EnumFacing.func_190914_a((BlockPos)pos, (EntityLivingBase)placer)));
        }
        if (this instanceof IBlockEnableable) {
            bs = bs.func_177226_a((IProperty)IBlockEnableable.ENABLED, (Comparable)Boolean.valueOf(((IBlockEnableable)((Object)this)).enableableDefault()));
        }
        return bs;
    }

    protected void updateState(World worldIn, BlockPos pos, IBlockState state) {
        if (this.reactsToRedstone && this instanceof IBlockEnableable) {
            boolean flag = !worldIn.func_175640_z(pos);
            boolean bl = flag;
            if (flag != (Boolean)state.func_177229_b((IProperty)IBlockEnableable.ENABLED)) {
                BlockDeviceHC.updateStateKeepTile(worldIn, pos, state.func_177226_a((IProperty)IBlockEnableable.ENABLED, (Comparable)Boolean.valueOf(flag)));
            }
        }
    }

    public void updateFacing(World world, BlockPos pos, EnumFacing face) {
        if (this instanceof IBlockOrientable || this instanceof IBlockHorizontal) {
            if (face == WorldUtil.getFacing(world.func_180495_p(pos))) {
                return;
            }
            if (this instanceof IBlockHorizontal && face.func_176736_b() >= 0) {
                BlockDeviceHC.updateStateKeepTile(world, pos, world.func_180495_p(pos).func_177226_a((IProperty)IBlockHorizontal.FACING, (Comparable)face));
            }
            if (this instanceof IBlockOrientable) {
                BlockDeviceHC.updateStateKeepTile(world, pos, world.func_180495_p(pos).func_177226_a((IProperty)IBlockOrientable.FACING, (Comparable)face));
            }
        }
    }

    public IBlockState func_176203_a(int meta) {
        IBlockState bs = this.func_176223_P();
        try {
            if (this instanceof IBlockHorizontal) {
                bs = bs.func_177226_a((IProperty)IBlockHorizontal.FACING, (Comparable)WorldUtil.getFacing(meta));
            }
            if (this instanceof IBlockOrientable) {
                bs = bs.func_177226_a((IProperty)IBlockOrientable.FACING, (Comparable)WorldUtil.getFacing(meta));
            }
            if (this instanceof IBlockEnableable) {
                bs = bs.func_177226_a((IProperty)IBlockEnableable.ENABLED, (Comparable)Boolean.valueOf(WorldUtil.isEnabled(meta)));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bs;
    }

    public int func_176201_c(IBlockState state) {
        int i;
        int b0 = 0;
        int n = this instanceof IBlockHorizontal ? b0 | ((EnumFacing)state.func_177229_b((IProperty)IBlockHorizontal.FACING)).func_176745_a() : (i = this instanceof IBlockOrientable ? b0 | ((EnumFacing)state.func_177229_b((IProperty)IBlockOrientable.FACING)).func_176745_a() : b0);
        if (this instanceof IBlockEnableable && !((Boolean)state.func_177229_b((IProperty)IBlockEnableable.ENABLED)).booleanValue()) {
            i |= 8;
        }
        return i;
    }

    protected BlockStateContainer func_180661_e() {
        ArrayList<Object> ip = new ArrayList<Object>();
        if (this instanceof IBlockHorizontal) {
            ip.add(IBlockHorizontal.FACING);
        }
        if (this instanceof IBlockOrientable) {
            ip.add(IBlockOrientable.FACING);
        }
        if (this instanceof IBlockEnableable) {
            ip.add(IBlockEnableable.ENABLED);
        }
        return ip.size() == 0 ? super.func_180661_e() : new BlockStateContainer((Block)this, ip.toArray(new IProperty[ip.size()]));
    }
}

