/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.client.gui;

import com.zeitheron.hammercore.client.gui.GuiWidgets;
import com.zeitheron.hammercore.client.utils.RenderUtil;
import com.zeitheron.hammercore.net.HCNet;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import org.lwjgl.opengl.GL11;

public class GuiFluidTank
extends Gui {
    private static final int TEX_WIDTH = 16;
    private static final int TEX_HEIGHT = 16;
    private static final int MIN_FLUID_HEIGHT = 1;
    public int x;
    public int y;
    public int width;
    public int height;
    public FluidTank tank;
    public int tankColor = -8454144;

    public GuiFluidTank(int x, int y, int width, int height, FluidTank tank) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.tank = tank;
    }

    public void render(int mouseX, int mouseY) {
        int totalLines = Math.round((float)this.height / 5.0f);
        int half = totalLines / 2;
        GlStateManager.func_179147_l();
        GlStateManager.func_179141_d();
        this.drawFluid(Minecraft.func_71410_x(), this.x, this.y);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)200.0f);
        GL11.glDisable((int)3553);
        for (int l = 0; l < totalLines; ++l) {
            RenderUtil.drawColoredModalRect(this.x, this.y + l * 5, this.width / (l == half ? 1 : 2), 1.0, this.tankColor);
        }
        GL11.glEnable((int)3553);
        GL11.glPopMatrix();
    }

    public boolean postRender(int mouseX, int mouseY) {
        if (this.isHovered(mouseX, mouseY)) {
            GL11.glDisable((int)3553);
            RenderUtil.drawColoredModalRect(this.x, this.y, this.width, this.height, -1426063361);
            GL11.glEnable((int)3553);
            return HCNet.getMouseStack((EntityPlayer)Minecraft.func_71410_x().field_71439_g).func_190926_b();
        }
        return false;
    }

    public void addTooltip(int mouseX, int mouseY, List<String> tooltip) {
        tooltip.addAll(this.getTooltip(mouseX, mouseY));
    }

    public List<String> getTooltip(int mouseX, int mouseY) {
        if (this.isHovered(mouseX, mouseY)) {
            return GuiWidgets.createTooltipForFluidTank(this.tank);
        }
        return Collections.emptyList();
    }

    public boolean isHovered(int mouseX, int mouseY) {
        return mouseX >= this.x && mouseY >= this.y && mouseX < this.x + this.width && mouseY < this.y + this.height;
    }

    private void drawFluid(Minecraft minecraft, int xPosition, int yPosition) {
        float x;
        FluidStack fluidStack = this.tank.getFluid();
        if (fluidStack == null) {
            return;
        }
        Fluid fluid = fluidStack.getFluid();
        if (fluid == null) {
            return;
        }
        TextureAtlasSprite tas = GuiFluidTank.getStillFluidSprite(minecraft, fluid);
        int fluidColor = fluid.getColor(fluidStack);
        float scaledAmount = (float)(fluidStack.amount * this.height) / (float)this.tank.getCapacity();
        if (scaledAmount > (float)this.height) {
            scaledAmount = this.height;
        }
        minecraft.field_71446_o.func_110577_a(TextureMap.field_110575_b);
        GuiFluidTank.setGLColorFromInt(fluidColor);
        int start = 0;
        float BarHeight = scaledAmount;
        do {
            x = 0.0f;
            if (BarHeight > 16.0f) {
                x = 16.0f;
                BarHeight -= 16.0f;
            } else {
                x = BarHeight;
                BarHeight = 0.0f;
            }
            RenderUtil.drawTexturedModalRect(this.x, (float)(this.y + this.height) - x - (float)start, tas, this.width, x);
            start += 16;
        } while (x != 0.0f && BarHeight != 0.0f);
    }

    private static TextureAtlasSprite getStillFluidSprite(Minecraft minecraft, Fluid fluid) {
        TextureMap textureMapBlocks = minecraft.func_147117_R();
        ResourceLocation fluidStill = fluid.getStill();
        TextureAtlasSprite fluidStillSprite = null;
        if (fluidStill != null) {
            fluidStillSprite = textureMapBlocks.getTextureExtry(fluidStill.toString());
        }
        if (fluidStillSprite == null) {
            fluidStillSprite = textureMapBlocks.func_174944_f();
        }
        return fluidStillSprite;
    }

    private void drawTiledSprite(Minecraft minecraft, int xPosition, int yPosition, int tiledWidth, int tiledHeight, int color, float scaledAmount, TextureAtlasSprite sprite) {
        int xTileCount = tiledWidth / 16;
        int xRemainder = tiledWidth - xTileCount * 16;
        float yTileCount = scaledAmount / 16.0f;
        float yRemainder = scaledAmount - yTileCount * 16.0f;
        int yStart = yPosition + tiledHeight;
        for (int xTile = 0; xTile <= xTileCount; ++xTile) {
            int yTile = 0;
            while ((float)yTile <= yTileCount) {
                int width = xTile == xTileCount ? xRemainder : 16;
                float height = (float)yTile == yTileCount ? yRemainder : 16.0f;
                int x = xPosition + xTile * 16;
                int y = yStart - (yTile + 1) * 16;
                if (width > 0 && height > 0.0f) {
                    GuiFluidTank.drawTextureWithMasking(x, y, sprite, 16.0f - height, 16 - width, 100.0);
                }
                ++yTile;
            }
        }
    }

    private static void setGLColorFromInt(int color) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        GlStateManager.func_179131_c((float)red, (float)green, (float)blue, (float)1.0f);
    }

    private static void drawTextureWithMasking(double xCoord, double yCoord, TextureAtlasSprite textureSprite, float maskTop, int maskRight, double zLevel) {
        double uMin = textureSprite.func_94209_e();
        double uMax = textureSprite.func_94212_f();
        double vMin = textureSprite.func_94206_g();
        double vMax = textureSprite.func_94210_h();
        uMax -= (double)maskRight / 16.0 * (uMax - uMin);
        vMax -= (double)maskTop / 16.0 * (vMax - vMin);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferBuilder = tessellator.func_178180_c();
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferBuilder.func_181662_b(xCoord, yCoord + 16.0, zLevel).func_187315_a(uMin, vMax).func_181675_d();
        bufferBuilder.func_181662_b(xCoord + 16.0 - (double)maskRight, yCoord + 16.0, zLevel).func_187315_a(uMax, vMax).func_181675_d();
        bufferBuilder.func_181662_b(xCoord + 16.0 - (double)maskRight, yCoord + (double)maskTop, zLevel).func_187315_a(uMax, vMin).func_181675_d();
        bufferBuilder.func_181662_b(xCoord, yCoord + (double)maskTop, zLevel).func_187315_a(uMin, vMin).func_181675_d();
        tessellator.func_78381_a();
    }
}

