/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.guidebook.guidebook.elements;

import com.google.common.collect.Lists;
import gigaherz.guidebook.guidebook.IBookGraphics;
import gigaherz.guidebook.guidebook.IConditionSource;
import gigaherz.guidebook.guidebook.drawing.VisualElement;
import gigaherz.guidebook.guidebook.elements.ElementInline;
import gigaherz.guidebook.guidebook.elements.ElementText;
import gigaherz.guidebook.guidebook.elements.TextStyle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.w3c.dom.NamedNodeMap;

public class ElementSpan
extends ElementInline {
    public final List<ElementInline> inlines = Lists.newArrayList();

    public ElementSpan(boolean isFirstElement, boolean isLastElement, ElementInline ... addRuns) {
        super(isFirstElement, isLastElement);
        Collections.addAll(this.inlines, addRuns);
    }

    public static ElementSpan of(String text, boolean isFirstElement, boolean isLastElement, TextStyle style) {
        ElementText inline = new ElementText(text, isFirstElement, isLastElement, style);
        return new ElementSpan(isFirstElement, isLastElement, inline);
    }

    public static ElementSpan of(String text, TextStyle style) {
        return ElementSpan.of(text, true, true, style);
    }

    @Override
    public List<VisualElement> measure(IBookGraphics nav, int width, int firstLineWidth) {
        ArrayList visuals = Lists.newArrayList();
        for (ElementInline run : this.inlines) {
            visuals.addAll(run.measure(nav, width, firstLineWidth));
        }
        return visuals;
    }

    @Override
    public void parse(IConditionSource book, NamedNodeMap attributes) {
        super.parse(book, attributes);
    }

    @Override
    public String toString(boolean complete) {
        return "<span ...>" + this.inlines.stream().map(Object::toString).collect(Collectors.joining()) + "</span>";
    }

    @Override
    public ElementInline copy() {
        ElementSpan span = super.copy(new ElementSpan(this.isFirstElement, this.isLastElement, new ElementInline[0]));
        for (ElementInline run : this.inlines) {
            span.inlines.add(run.copy());
        }
        return span;
    }
}

