/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.guidebook.guidebook.drawing;

import gigaherz.guidebook.guidebook.HoverContext;
import gigaherz.guidebook.guidebook.IBookGraphics;
import gigaherz.guidebook.guidebook.drawing.MovingPicture;
import gigaherz.guidebook.guidebook.drawing.VisualElement;
import gigaherz.guidebook.guidebook.elements.LinkContext;
import gigaherz.guidebook.guidebook.util.GifDecoder;
import gigaherz.guidebook.guidebook.util.LinkHelper;
import gigaherz.guidebook.guidebook.util.Size;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import org.jcodec.api.FrameGrab;
import org.jcodec.api.JCodecException;
import org.jcodec.api.PictureWithMetadata;
import org.jcodec.common.io.NIOUtils;
import org.jcodec.common.io.SeekableByteChannel;
import org.jcodec.common.model.Picture;
import org.jcodec.scale.AWTUtil;

public class VisualImage
extends VisualElement
implements LinkHelper.ILinkable {
    public ResourceLocation textureLocation;
    public int tx;
    public int ty;
    public int tw;
    public int th;
    public int w;
    public int h;
    public float scale;
    public LinkContext linkContext = null;
    int n;
    int width;
    int height;
    GifDecoder d;
    BufferedImage frame;
    private long curTime;
    private long prevTime = this.curTime = Minecraft.func_71386_F();
    private long delta = 0L;
    private int frameCounterGif = 0;
    private final int frameCounterh264 = 0;
    private final ResourceLocation foo = new ResourceLocation("gbook:gui/recipe_backgrounds");
    private final Map<String, MovingPicture> movingPictures = new HashMap<String, MovingPicture>();
    private FrameGrab frameGrab = null;
    private Picture picture;
    private File file;
    private boolean gifFileLoaded = false;
    private Picture oldPic;
    private double h264Delay = 0.0;
    private PictureWithMetadata pictureWithMetadata;

    public VisualImage(Size size, int positionMode, float baseline, int verticalAlign, ResourceLocation textureLocation, int tx, int ty, int tw, int th, int w, int h, float scale) {
        super(size, positionMode, baseline, verticalAlign);
        this.textureLocation = textureLocation;
        this.tx = tx;
        this.ty = ty;
        this.tw = tw;
        this.th = th;
        this.w = w;
        this.h = h;
        this.scale = scale;
    }

    @Override
    public void draw(IBookGraphics nav) {
        ResourceLocation tmpLocation = this.textureLocation;
        super.draw(nav);
        if (this.textureLocation.func_110623_a().contains("animated")) {
            if (!this.movingPictures.containsKey(this.textureLocation.func_110623_a())) {
                this.movingPictures.put(this.textureLocation.func_110623_a(), new MovingPicture(tmpLocation.func_110623_a()));
            }
            tmpLocation = this.movingPictures.get(this.textureLocation.func_110623_a()).getResourceLocation(tmpLocation.func_110623_a());
            nav.drawImage(tmpLocation, this.position.x, this.position.y, this.tx, this.ty, this.w, this.h, this.tw, this.th, this.scale);
        } else if (this.textureLocation.func_110623_a().contains("h264")) {
            if (this.frameGrab == null) {
                String h264File = Minecraft.func_71410_x().field_71412_D.getAbsolutePath() + "/resources/torgobooks/textures/" + tmpLocation.func_110623_a() + ".mp4";
                this.file = new File(h264File);
                this.delta = 99L;
                this.h264Delay = 0.0;
                this.picture = null;
                this.oldPic = null;
                this.pictureWithMetadata = null;
                try {
                    this.frameGrab = FrameGrab.createFrameGrab((SeekableByteChannel)NIOUtils.readableChannel((File)this.file));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                catch (JCodecException e) {
                    throw new RuntimeException(e);
                }
            }
            try {
                if (this.h264Delay < (double)this.delta) {
                    this.pictureWithMetadata = this.frameGrab.getNativeFrameWithMetadata();
                    this.picture = this.pictureWithMetadata.getPicture();
                    this.h264Delay = 1.0 / this.pictureWithMetadata.getDuration();
                    this.width = this.picture.getWidth();
                    this.height = this.picture.getHeight();
                    this.oldPic = this.picture;
                    this.delta = 0L;
                }
                nav.drawImage(AWTUtil.toBufferedImage((Picture)this.oldPic), this.position.x, this.position.y, this.tx, this.ty, this.width, this.height, this.width, this.height, 205.0f / (float)this.width);
            }
            catch (IOException e) {
                this.frameGrab = null;
            }
            catch (NullPointerException e) {
                this.frameGrab = null;
            }
            this.delta += this.curTime - this.prevTime;
        } else if (this.textureLocation.func_110623_a().contains("gifs")) {
            if (!this.gifFileLoaded) {
                String gifFile = Minecraft.func_71410_x().field_71412_D.getAbsolutePath() + "/resources/torgobooks/textures/" + tmpLocation.func_110623_a() + ".gif";
                this.d = new GifDecoder();
                this.d.read(gifFile);
                this.width = this.d.getFrame(0).getWidth();
                this.height = this.d.getFrame(0).getHeight();
                this.gifFileLoaded = true;
                this.frameCounterGif = 0;
            }
            this.frame = this.d.getFrame(this.frameCounterGif);
            if (this.frame == null) {
                this.frameCounterGif = 0;
                this.frame = this.d.getFrame(this.frameCounterGif);
            }
            int delay = this.d.getDelay(this.frameCounterGif);
            this.delta += this.curTime - this.prevTime;
            if (this.delta >= (long)delay) {
                ++this.frameCounterGif;
                this.delta = 0L;
            }
            nav.drawImage(this.frame, this.position.x, this.position.y, this.tx, this.ty, this.width, this.height, this.width, this.height, 205.0f / (float)this.width);
        } else {
            nav.drawImage(tmpLocation, this.position.x, this.position.y, this.tx, this.ty, this.w, this.h, this.tw, this.th, this.scale);
        }
        this.prevTime = this.curTime;
        this.curTime = Minecraft.func_71386_F();
    }

    @Override
    public boolean wantsHover() {
        return this.linkContext != null;
    }

    @Override
    public void mouseOver(IBookGraphics nav, HoverContext hoverContext) {
        if (this.linkContext != null) {
            this.linkContext.isHovering = true;
        }
    }

    @Override
    public void mouseOut(IBookGraphics nav, HoverContext hoverContext) {
        if (this.linkContext != null) {
            this.linkContext.isHovering = false;
        }
    }

    @Override
    public void click(IBookGraphics nav) {
        if (this.linkContext != null) {
            LinkHelper.click(nav, this.linkContext);
        }
    }

    @Override
    public void setLinkContext(LinkContext ctx) {
        this.linkContext = ctx;
    }
}

