/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.venus.world.gen.base;

import java.util.List;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.core.world.gen.dungeon.MapGenDungeon;
import micdoodle8.mods.galacticraft.planets.venus.world.gen.base.BaseConfiguration;
import micdoodle8.mods.galacticraft.planets.venus.world.gen.base.BaseDeck;
import micdoodle8.mods.galacticraft.planets.venus.world.gen.base.BaseHangar;
import micdoodle8.mods.galacticraft.planets.venus.world.gen.base.BaseLinking;
import micdoodle8.mods.galacticraft.planets.venus.world.gen.base.BasePlate;
import micdoodle8.mods.galacticraft.planets.venus.world.gen.base.BaseRoom;
import micdoodle8.mods.galacticraft.planets.venus.world.gen.base.BaseStart;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.structure.MapGenStructure;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureStart;

public class MapGenAbandonedBase
extends MapGenStructure {
    private static boolean initialized;

    public static void initiateStructures() throws Throwable {
        if (!initialized) {
            MapGenStructureIO.func_143034_b(Start.class, (String)"AbandonedBase");
            MapGenStructureIO.func_143031_a(BaseStart.class, (String)"AbandonedBaseStart");
            MapGenStructureIO.func_143031_a(BaseRoom.class, (String)"AbandonedBaseRoom");
            MapGenStructureIO.func_143031_a(BaseDeck.class, (String)"AbandonedBaseDeck");
            MapGenStructureIO.func_143031_a(BasePlate.class, (String)"AbandonedBasePlate");
            MapGenStructureIO.func_143031_a(BaseHangar.class, (String)"AbandonedBaseHangar");
            MapGenStructureIO.func_143031_a(BaseLinking.class, (String)"AbandonedBaseCorridor");
        }
        initialized = true;
    }

    public BlockPos func_180706_b(World worldIn, BlockPos pos, boolean p_180706_3_) {
        return null;
    }

    public String func_143025_a() {
        return "GC_AbandonedBase";
    }

    protected boolean func_75047_a(int chunkX, int chunkZ) {
        if (this.field_75038_b.nextInt(100) < 90) {
            return false;
        }
        long dungeonPos = MapGenDungeon.getDungeonPosForCoords((World)this.field_75039_c, (int)chunkX, (int)chunkZ, (int)((IGalacticraftWorldProvider)this.field_75039_c.field_73011_w).getDungeonSpacing());
        int i = (int)(dungeonPos >> 32);
        int j = (int)dungeonPos;
        return i == chunkX && j == chunkZ;
    }

    public void func_186125_a(World worldIn, int x, int z, ChunkPrimer chunkPrimerIn) {
        int i = this.field_75040_a;
        this.field_75039_c = worldIn;
        this.field_75038_b.setSeed(worldIn.func_72905_C());
        long j = this.field_75038_b.nextLong();
        long k = this.field_75038_b.nextLong();
        for (int l = x - i; l <= x + i; ++l) {
            for (int i1 = z - i; i1 <= z + i; ++i1) {
                long j1 = (long)l * j;
                long k1 = (long)i1 * k;
                this.field_75038_b.setSeed(j1 ^ k1 ^ worldIn.func_72905_C());
                this.func_180701_a(worldIn, l, i1, x, z, chunkPrimerIn);
            }
        }
    }

    public void reset() {
        this.field_75053_d.clear();
    }

    protected StructureStart func_75049_b(int chunkX, int chunkZ) {
        return new Start(this.field_75039_c, this.field_75038_b, (chunkX << 4) + 8, (chunkZ << 4) + 8, 15, new BaseConfiguration(148, this.field_75038_b));
    }

    static {
        try {
            MapGenAbandonedBase.initiateStructures();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static class Start
    extends StructureStart {
        private BaseConfiguration configuration;

        public Start() {
        }

        public Start(World worldIn, Random rand, int posX, int posZ, int size, BaseConfiguration configuration) {
            super(posX >> 4, posZ >> 4);
            this.configuration = configuration;
            if (size < 1) {
                size = 1;
            }
            size = size * (int)MathHelper.func_76129_c((float)size) / 4;
            if (configuration.isHangarDeck()) {
                size -= 6;
            }
            int xoffset = 0;
            int zoffset = 0;
            EnumFacing direction = EnumFacing.Plane.HORIZONTAL.func_179518_a(rand);
            switch (direction) {
                case NORTH: {
                    zoffset = -size;
                    break;
                }
                case SOUTH: {
                    zoffset = size;
                    break;
                }
                case WEST: {
                    xoffset = -size;
                    break;
                }
                case EAST: {
                    xoffset = size;
                }
            }
            BaseStart startPiece = new BaseStart(configuration, rand, posX + xoffset, posZ + zoffset, direction);
            startPiece.func_74861_a(startPiece, this.field_75075_a, rand);
            List<StructureComponent> list = startPiece.attachedComponents;
            while (!list.isEmpty()) {
                int i = rand.nextInt(list.size());
                StructureComponent structurecomponent = list.remove(i);
                structurecomponent.func_74861_a((StructureComponent)startPiece, this.field_75075_a, rand);
            }
            this.func_75072_c();
        }
    }
}

