/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.tile;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import micdoodle8.mods.galacticraft.core.tile.IMachineSides;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.util.IStringSerializable;

public class IMachineSidesProperties {
    public static IMachineSidesProperties NOT_CONFIGURABLE = new IMachineSidesProperties((Predicate<MachineSidesModel>)MachineSidesModel.access$000(), IMachineSides.Face.Horizontals);
    public static IMachineSidesProperties ONEFACE_HORIZ = new IMachineSidesProperties((Predicate<MachineSidesModel>)MachineSidesModel.access$100(), IMachineSides.Face.Horizontals);
    public static IMachineSidesProperties ONEFACE = new IMachineSidesProperties((Predicate<MachineSidesModel>)MachineSidesModel.access$200(), IMachineSides.Face.AllAvailable);
    public static IMachineSidesProperties TWOFACES_HORIZ = new IMachineSidesProperties((Predicate<MachineSidesModel>)MachineSidesModel.access$300(), IMachineSides.Face.Horizontals);
    public static IMachineSidesProperties TWOFACES_ALL = new IMachineSidesProperties((Predicate<MachineSidesModel>)MachineSidesModel.access$400(), IMachineSides.Face.AllAvailable);
    private final Predicate<MachineSidesModel> filter;
    private final IMachineSides.Face[] toFaces;
    public PropertyEnum<MachineSidesModel> asProperty;

    public IMachineSidesProperties(Predicate<MachineSidesModel> theFilter, IMachineSides.Face[] faces) {
        this.asProperty = PropertyEnum.func_177708_a((String)"msm", MachineSidesModel.class, theFilter);
        this.filter = theFilter;
        this.toFaces = faces;
    }

    public static MachineSidesModel getModelForTwoFaces(IMachineSides.Face faceA, IMachineSides.Face faceB) {
        String result = faceA.getName() + faceB.getName();
        for (MachineSidesModel test : MachineSidesModel.values()) {
            if (!result.equals(test.name)) continue;
            return test;
        }
        return MachineSidesModel.RIGHT1;
    }

    public static MachineSidesModel getModelForOneFace(IMachineSides.Face allowedSide) {
        switch (allowedSide) {
            case RIGHT: {
                return MachineSidesModel.RIGHT1;
            }
            case REAR: {
                return MachineSidesModel.REAR1;
            }
            case TOP: {
                return MachineSidesModel.TOP1;
            }
            case BOTTOM: {
                return MachineSidesModel.BOTTOM1;
            }
        }
        return MachineSidesModel.LEFT1;
    }

    public MachineSidesModel getDefault() {
        return MachineSidesModel.LEFT1;
    }

    public IMachineSides.Face[] allowableFaces() {
        return this.toFaces;
    }

    public boolean isValidFor(MachineSidesModel machineSidesModel) {
        return this.filter.apply((Object)machineSidesModel);
    }

    public static enum MachineSidesModel implements IStringSerializable
    {
        LEFT1("lr"),
        LEFT2("lb"),
        LEFT3("lu"),
        LEFT4("ld"),
        RIGHT1("rl"),
        RIGHT2("rb"),
        RIGHT3("ru"),
        RIGHT4("rd"),
        REAR1("bl"),
        REAR2("br"),
        REAR3("bu"),
        REAR4("bd"),
        TOP1("ul"),
        TOP2("ur"),
        TOP3("ub"),
        TOP4("ud"),
        BOTTOM1("dl"),
        BOTTOM2("dr"),
        BOTTOM3("db"),
        BOTTOM4("du");

        private final String name;

        private MachineSidesModel(String newname) {
            this.name = newname;
        }

        private static Predicate<MachineSidesModel> oneFacedAll() {
            return new Predicate<MachineSidesModel>(){

                public boolean apply(MachineSidesModel msm) {
                    return msm.ordinal() % 4 == 0;
                }
            };
        }

        private static Predicate<MachineSidesModel> twoFacedAll() {
            return Predicates.alwaysTrue();
        }

        private static Predicate<MachineSidesModel> oneFacedHoriz() {
            return new Predicate<MachineSidesModel>(){

                public boolean apply(MachineSidesModel msm) {
                    return msm.ordinal() < 12 && msm.ordinal() % 4 == 0;
                }
            };
        }

        private static Predicate<MachineSidesModel> twoFacedHoriz() {
            return new Predicate<MachineSidesModel>(){

                public boolean apply(MachineSidesModel msm) {
                    return msm.ordinal() < 12 && msm.ordinal() % 4 < 2;
                }
            };
        }

        private static Predicate<MachineSidesModel> noneConfigurable() {
            return new Predicate<MachineSidesModel>(){

                public boolean apply(MachineSidesModel msm) {
                    return msm == LEFT1;
                }
            };
        }

        public String func_176610_l() {
            return this.name;
        }

        public MachineSidesModel validFor(IMachineSidesProperties configurationType) {
            if (configurationType.isValidFor(this)) {
                return this;
            }
            return configurationType.getDefault();
        }

        static /* synthetic */ Predicate access$000() {
            return MachineSidesModel.noneConfigurable();
        }

        static /* synthetic */ Predicate access$100() {
            return MachineSidesModel.oneFacedHoriz();
        }

        static /* synthetic */ Predicate access$200() {
            return MachineSidesModel.oneFacedAll();
        }

        static /* synthetic */ Predicate access$300() {
            return MachineSidesModel.twoFacedHoriz();
        }

        static /* synthetic */ Predicate access$400() {
            return MachineSidesModel.twoFacedAll();
        }
    }
}

