/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.tile;

import java.util.Arrays;
import java.util.List;
import micdoodle8.mods.galacticraft.api.tile.ITileClientUpdates;
import micdoodle8.mods.galacticraft.core.tile.IMachineSidesProperties;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public interface IMachineSides
extends ITileClientUpdates {
    public static IBlockState addPropertyForTile(IBlockState state, TileEntity tile, IMachineSidesProperties renderType, PropertyEnum<IMachineSidesProperties.MachineSidesModel> key) {
        if (tile instanceof IMachineSides) {
            IMachineSides tileSides = (IMachineSides)tile;
            return state.func_177226_a(key, (Comparable)((Object)tileSides.buildBlockStateProperty()));
        }
        return state.func_177226_a(key, (Comparable)((Object)renderType.getDefault()));
    }

    public EnumFacing getFront();

    default public EnumFacing getElectricInputDirection() {
        return null;
    }

    default public EnumFacing getElectricOutputDirection() {
        return null;
    }

    default public EnumFacing getPipeInputDirection() {
        return null;
    }

    default public EnumFacing getPipeOutputDirection() {
        return null;
    }

    default public EnumFacing getCustomDirection() {
        return null;
    }

    default public boolean setSide(MachineSide sideToSet, Face newSide) {
        if (this.getConfigurationType() == IMachineSidesProperties.NOT_CONFIGURABLE) {
            return false;
        }
        for (MachineSidePack msp : this.getAllMachineSides()) {
            if (!msp.test(sideToSet)) continue;
            msp.set(newSide);
            return true;
        }
        return false;
    }

    default public boolean setSide(int index, Face newSide) {
        if (this.getConfigurationType() == IMachineSidesProperties.NOT_CONFIGURABLE) {
            return false;
        }
        MachineSidePack[] msps = this.getAllMachineSides();
        if (index >= 0 && index < msps.length) {
            msps[index].set(newSide);
            return true;
        }
        return false;
    }

    default public Face getSide(int index) {
        MachineSidePack[] msps = this.getAllMachineSides();
        if (index >= 0 && index < msps.length) {
            return msps[index].get();
        }
        return Face.NOT_CONFIGURABLE;
    }

    default public Face getSide(MachineSide sideToGet) {
        for (MachineSidePack msp : this.getAllMachineSides()) {
            if (!msp.test(sideToGet)) continue;
            return msp.get();
        }
        return Face.NOT_CONFIGURABLE;
    }

    default public Face getAllowedSide(int index) {
        Face test = this.getSide(index);
        for (Face face : this.allowableFaces()) {
            if (face != test) continue;
            return test;
        }
        return this.listDefaultFaces()[index];
    }

    default public boolean isValidForSide(MachineSide sideToSet, Face newSide) {
        for (MachineSidePack msp : this.getAllMachineSides()) {
            if (!msp.test(sideToSet)) continue;
            return Arrays.asList(this.allowableFaces()).contains((Object)newSide);
        }
        return false;
    }

    default public MachineSide textureTypeLeft() {
        for (MachineSidePack msp : this.getAllMachineSides()) {
            if (msp.get() != Face.LEFT) continue;
            return msp.getRenderType();
        }
        return MachineSide.PLAIN;
    }

    default public MachineSide textureTypeRight() {
        for (MachineSidePack msp : this.getAllMachineSides()) {
            if (msp.get() != Face.RIGHT) continue;
            return msp.getRenderType();
        }
        return MachineSide.PLAIN;
    }

    default public MachineSide textureTypeRear() {
        for (MachineSidePack msp : this.getAllMachineSides()) {
            if (msp.get() != Face.REAR) continue;
            return msp.getRenderType();
        }
        return MachineSide.PLAIN;
    }

    default public MachineSide textureTypeTop() {
        for (MachineSidePack msp : this.getAllMachineSides()) {
            if (msp.get() != Face.TOP) continue;
            return msp.getRenderType();
        }
        return MachineSide.TOP;
    }

    default public MachineSide textureTypeBase() {
        for (MachineSidePack msp : this.getAllMachineSides()) {
            if (msp.get() != Face.BOTTOM) continue;
            return msp.getRenderType();
        }
        return MachineSide.BASE;
    }

    default public IMachineSidesProperties.MachineSidesModel buildBlockStateProperty() {
        int length = this.listConfigurableSides().length;
        switch (length) {
            case 1: {
                return IMachineSidesProperties.getModelForOneFace(this.getAllowedSide(0)).validFor(this.getConfigurationType());
            }
        }
        return IMachineSidesProperties.getModelForTwoFaces(this.getAllowedSide(0), this.getAllowedSide(1)).validFor(this.getConfigurationType());
    }

    default public void nextSideConfiguration(TileEntity te) {
        if (this.getConfigurationType() == IMachineSidesProperties.NOT_CONFIGURABLE) {
            return;
        }
        int length = this.listConfigurableSides().length;
        switch (length) {
            case 1: {
                this.setSide(0, this.getSide(0).next());
                break;
            }
            case 2: {
                Face leadingSide = this.getSide(0);
                if (this.getSide(1) != leadingSide.next()) {
                    this.setSide(1, leadingSide.prior());
                    this.setSide(0, leadingSide.next());
                    break;
                }
                this.setSide(1, leadingSide.prior());
                break;
            }
        }
        if (te.func_145831_w().field_72995_K) {
            te.func_145831_w().func_175704_b(te.func_174877_v(), te.func_174877_v());
        } else {
            this.updateAllInDimension();
        }
    }

    public MachineSide[] listConfigurableSides();

    public Face[] listDefaultFaces();

    default public Face[] allowableFaces() {
        return this.getConfigurationType().allowableFaces();
    }

    public IMachineSidesProperties getConfigurationType();

    default public void initialiseSides() {
        int length = this.listConfigurableSides().length;
        this.setupMachineSides(length);
        for (int i = 0; i < length; ++i) {
            this.getAllMachineSides()[i] = new MachineSidePack(this.listConfigurableSides()[i], this.listDefaultFaces()[i]);
        }
    }

    public MachineSidePack[] getAllMachineSides();

    public void setupMachineSides(int var1);

    default public void addMachineSidesToNBT(NBTTagCompound par1nbtTagCompound) {
        NBTTagList tagList = new NBTTagList();
        for (MachineSidePack msp : this.getAllMachineSides()) {
            NBTTagCompound tag = new NBTTagCompound();
            msp.writeToNBT(tag);
            tagList.func_74742_a((NBTBase)tag);
        }
        par1nbtTagCompound.func_74782_a("macsides", (NBTBase)tagList);
    }

    default public void readMachineSidesFromNBT(NBTTagCompound par1nbtTagCompound) {
        NBTTagList tagList = par1nbtTagCompound.func_150295_c("macsides", 10);
        MachineSidePack[] msps = this.getAllMachineSides();
        if (tagList.func_74745_c() == msps.length) {
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                msps[i].readFromNBT(tagList.func_150305_b(i));
            }
        }
    }

    @Override
    default public void buildDataPacket(int[] data) {
        MachineSidePack[] msps = this.getAllMachineSides();
        for (int i = 0; i < msps.length; ++i) {
            data[i] = msps[i].get().ordinal();
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    default public void updateClient(List<Object> data) {
        MachineSidePack[] msps = this.getAllMachineSides();
        for (int i = 0; i < msps.length; ++i) {
            msps[i].set((Integer)data.get(i + 1));
        }
        BlockPos pos = ((TileEntity)this).func_174877_v();
        ((TileEntity)this).func_145831_w().func_175704_b(pos, pos);
    }

    public static class MachineSidePack {
        private final MachineSide theSide;
        private Face currentFace;

        public MachineSidePack(MachineSide type, Face defaultFace) {
            assert (type != null);
            this.theSide = type;
            this.set(defaultFace);
        }

        public void writeToNBT(NBTTagCompound tag) {
            tag.func_74768_a("ts", this.theSide.ordinal());
            tag.func_74768_a("cf", this.currentFace.ordinal());
        }

        public void readFromNBT(NBTTagCompound tag) {
            int ts = -1;
            int cf = -1;
            if (tag.func_74764_b("ts")) {
                ts = tag.func_74762_e("ts");
            }
            if (tag.func_74764_b("cf")) {
                cf = tag.func_74762_e("cf");
            }
            if (ts == this.theSide.ordinal() && cf >= 0 && cf < Face.values().length) {
                this.currentFace = Face.values()[cf];
            }
        }

        public void set(Face face) {
            this.currentFace = face == null ? Face.NOT_SET : face;
        }

        public void set(int index) {
            if (index >= 0 && index < Face.values().length) {
                this.currentFace = Face.values()[index];
            }
        }

        public Face get() {
            return this.currentFace;
        }

        public MachineSide getRenderType() {
            return this.theSide;
        }

        public boolean test(MachineSide type) {
            return this.theSide == type;
        }
    }

    public static enum MachineSide {
        FRONT("front"),
        REARDECO("reardeco"),
        PLAIN("plain"),
        TOP("top"),
        BASE("bottom"),
        ELECTRIC_IN("elec_in"),
        ELECTRIC_OUT("elec_out"),
        PIPE_IN("pipe_in"),
        PIPE_OUT("pipe_out"),
        CUSTOM("custom");

        private final String name;

        private MachineSide(String newname) {
            this.name = newname;
        }
    }

    public static enum Face {
        LEFT("l", 2, 1),
        RIGHT("r", 0, 2),
        REAR("b", 1, 0),
        TOP("u", 4, 4),
        BOTTOM("d", 3, 3),
        NOT_SET("n", 5, 5),
        NOT_CONFIGURABLE("fail", 6, 6);

        public static Face[] Horizontals;
        public static Face[] AllAvailable;
        private final String name;
        private final int next;
        private final int prior;

        private Face(String newname, int theNext, int thePrior) {
            this.name = newname;
            this.next = theNext;
            this.prior = thePrior;
        }

        public String getName() {
            return this.name;
        }

        public Face next() {
            return Face.values()[this.next];
        }

        public Face prior() {
            return Face.values()[this.prior];
        }

        static {
            Horizontals = new Face[]{LEFT, REAR, RIGHT};
            AllAvailable = new Face[]{LEFT, REAR, RIGHT, TOP, BOTTOM};
        }
    }
}

