/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.items;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import micdoodle8.mods.galacticraft.core.items.ItemCanisterGeneric;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class ItemCanisterGenericHandler
implements IFluidHandlerItem,
ICapabilityProvider {
    @Nonnull
    protected ItemStack container;

    public ItemCanisterGenericHandler(@Nonnull ItemStack container) {
        this.container = container;
    }

    @Nonnull
    public ItemStack getContainer() {
        return this.container;
    }

    @Nullable
    public FluidStack getFluid() {
        if (this.container.func_190916_E() > 0 && this.container.func_77973_b() instanceof ItemCanisterGeneric) {
            return ((ItemCanisterGeneric)this.container.func_77973_b()).getFluid(this.container);
        }
        return null;
    }

    protected void setFluid(FluidStack fluid) {
        if (this.canFillFluidType(fluid)) {
            this.container.func_77973_b().setDamage(this.container, 1001 - fluid.amount);
        }
    }

    public IFluidTankProperties[] getTankProperties() {
        if (this.container.func_190916_E() > 0 && this.container.func_77973_b() instanceof ItemCanisterGeneric) {
            return new FluidTankProperties[]{new FluidTankProperties(this.getFluid(), 1000)};
        }
        return new FluidTankProperties[0];
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (this.container.func_190916_E() > 0 && this.container.func_77973_b() instanceof ItemCanisterGeneric) {
            return ((ItemCanisterGeneric)this.container.func_77973_b()).fill(this.container, resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (this.container.func_190916_E() > 0 && this.container.func_77973_b() instanceof ItemCanisterGeneric) {
            return ((ItemCanisterGeneric)this.container.func_77973_b()).drain(this.container, maxDrain, doDrain);
        }
        return null;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (this.canDrainFluidType(resource)) {
            return ((ItemCanisterGeneric)this.container.func_77973_b()).drain(this.container, resource.amount, doDrain);
        }
        return null;
    }

    public boolean canFillFluidType(FluidStack fluid) {
        if (this.container.func_190916_E() > 0 && this.container.func_77973_b() instanceof ItemCanisterGeneric && fluid != null && fluid.getFluid() != null) {
            return ((ItemCanisterGeneric)this.container.func_77973_b()).getAllowedFluid().equalsIgnoreCase(fluid.getFluid().getName());
        }
        return false;
    }

    public boolean canDrainFluidType(FluidStack fluid) {
        return this.canFillFluidType(fluid);
    }

    protected void setContainerToEmpty() {
        if (this.container.func_190916_E() > 0 && this.container.func_77973_b() instanceof ItemCanisterGeneric) {
            this.container.func_77973_b().setDamage(this.container, 1001);
        }
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY;
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)(capability == CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY ? this : null);
    }
}

