/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.items;

import java.util.HashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.items.ISortableItem;
import micdoodle8.mods.galacticraft.core.proxy.ClientProxyCore;
import micdoodle8.mods.galacticraft.core.util.EnumSortCategoryItem;
import micdoodle8.mods.galacticraft.core.util.FluidUtil;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Items;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBucket;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemBucketGC
extends ItemBucket
implements ISortableItem,
ICapabilityProvider {
    private static final HashMap<String, ItemBucketGC> allFluids = new HashMap();
    public Fluid accepts;

    public ItemBucketGC(Block block, Fluid fluid) {
        super(block);
        this.func_77642_a(Items.field_151133_ar);
        this.accepts = fluid;
        allFluids.put(fluid.getName(), this);
    }

    public static ItemBucketGC getBucketForFluid(Fluid fluid) {
        return allFluids.get(fluid.getName());
    }

    public static ItemStack fillBucketFrom(IFluidHandler fluidHandler) {
        ItemBucketGC test;
        FluidStack liquid = fluidHandler.drain(1000, false);
        if (liquid != null && liquid.amount == 1000 && (test = ItemBucketGC.getBucketForFluid(liquid.getFluid())) != null) {
            fluidHandler.drain(1000, true);
            return new ItemStack((Item)test);
        }
        return null;
    }

    public ItemStack drainBucketTo(IFluidHandler fluidHandler) {
        FluidStack fs = new FluidStack(this.accepts, 1000);
        int transferred = fluidHandler.fill(fs, false);
        if (transferred == 1000) {
            fluidHandler.fill(fs, true);
            return new ItemStack(Items.field_151133_ar);
        }
        return ItemStack.field_190927_a;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack par1ItemStack) {
        return ClientProxyCore.galacticraftItem;
    }

    @SideOnly(value=Side.CLIENT)
    public CreativeTabs func_77640_w() {
        return GalacticraftCore.galacticraftItemsTab;
    }

    @Override
    public EnumSortCategoryItem getCategory(int meta) {
        return EnumSortCategoryItem.BUCKET;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new FluidHandlerBucketGC(stack);
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY;
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)(capability == CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY ? this : null);
    }

    public static class FluidHandlerBucketGC
    implements IFluidHandlerItem,
    ICapabilityProvider {
        public static final String FLUID_NBT_KEY = "Fluid";
        private final ItemBucketGC item;
        @Nonnull
        protected ItemStack container;
        protected int capacity;

        public FluidHandlerBucketGC(@Nonnull ItemStack container) {
            container.func_190920_e(1);
            this.container = container;
            this.item = (ItemBucketGC)container.func_77973_b();
            this.capacity = 1000;
        }

        @Nonnull
        public ItemStack getContainer() {
            return this.container;
        }

        @Nullable
        public FluidStack getFluid() {
            return new FluidStack(this.item.accepts, this.capacity);
        }

        protected void setFluid(FluidStack fluid) {
        }

        public IFluidTankProperties[] getTankProperties() {
            return new IFluidTankProperties[]{new FluidTankProperties(this.getFluid(), this.capacity)};
        }

        public int fill(FluidStack resource, boolean doFill) {
            return 0;
        }

        public FluidStack drain(FluidStack resource, boolean doDrain) {
            if (resource == null || !this.canDrainFluidType(resource)) {
                return null;
            }
            return this.drain(resource.amount, doDrain);
        }

        public FluidStack drain(int maxDrain, boolean doDrain) {
            if (maxDrain < this.capacity) {
                return null;
            }
            if (doDrain) {
                this.container = new ItemStack(Items.field_151133_ar);
            }
            return this.getFluid();
        }

        public boolean canFillFluidType(FluidStack fluid) {
            return false;
        }

        public boolean canDrainFluidType(FluidStack fluid) {
            return FluidUtil.fluidsSame(this.item.accepts, fluid.getFluid(), true);
        }

        protected void setContainerToEmpty() {
            this.container = new ItemStack(Items.field_151133_ar);
        }

        public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
            return capability == CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY;
        }

        @Nullable
        public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
            return (T)(capability == CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY ? this : null);
        }
    }
}

