/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.energy.tile;

import micdoodle8.mods.galacticraft.api.power.IEnergyStorageGC;
import net.minecraft.nbt.NBTTagCompound;

public class EnergyStorage
implements IEnergyStorageGC {
    protected float energy;
    protected float capacity;
    protected float maxReceive;
    protected float maxExtract;
    protected float maxExtractRemaining;

    public EnergyStorage(float capacity) {
        this(capacity, 60.0f, 30.0f);
    }

    public EnergyStorage(float capacity, float maxTransfer) {
        this(capacity, 2.5f * maxTransfer, maxTransfer);
    }

    public EnergyStorage(float capacity, float maxReceive, float maxExtract) {
        this.capacity = capacity;
        this.maxReceive = maxReceive;
        this.maxExtract = maxExtract;
        this.maxExtractRemaining = maxExtract;
    }

    public EnergyStorage readFromNBT(NBTTagCompound nbt) {
        this.energy = nbt.func_74760_g("EnergyF");
        return this;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        if (this.energy < 0.0f) {
            this.energy = 0.0f;
        }
        nbt.func_74776_a("EnergyF", Math.min(this.energy, this.capacity));
        return nbt;
    }

    public void setCapacity(float capacity) {
        this.capacity = capacity;
        if (this.energy > capacity) {
            this.energy = capacity;
        }
    }

    public void setEnergyStored(float energy) {
        this.energy = Math.max(0.0f, Math.min(energy, this.capacity));
    }

    public float getMaxReceive() {
        return this.maxReceive;
    }

    public void setMaxReceive(float maxReceive) {
        this.maxReceive = maxReceive;
    }

    public float getMaxExtract() {
        return this.maxExtract;
    }

    public void setMaxExtract(float maxExtract) {
        this.maxExtract = maxExtract;
        this.maxExtractRemaining = maxExtract;
        this.maxReceive = 2.5f * maxExtract;
    }

    @Override
    public float receiveEnergyGC(float maxReceive, boolean simulate) {
        float energyReceived = Math.min(this.capacity - this.energy, Math.min(this.maxReceive, maxReceive));
        if (!simulate) {
            this.energy += energyReceived;
        }
        return energyReceived;
    }

    public float receiveEnergyGC(float amount) {
        float energyReceived = Math.min(this.capacity - this.energy, Math.min(this.maxReceive, amount));
        this.energy += energyReceived;
        return energyReceived;
    }

    @Override
    public float extractEnergyGC(float amount, boolean simulate) {
        float energyExtracted = Math.min(this.energy, Math.min(this.maxExtractRemaining, amount));
        if (!simulate) {
            this.energy -= energyExtracted;
        }
        return energyExtracted;
    }

    public float extractEnergyGCnoMax(float amount, boolean simulate) {
        float energyExtracted = Math.min(this.energy, amount);
        if (!simulate) {
            this.energy -= energyExtracted;
        }
        return energyExtracted;
    }

    @Override
    public float getEnergyStoredGC() {
        return this.energy;
    }

    @Override
    public float getCapacityGC() {
        return this.capacity;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof EnergyStorage) {
            EnergyStorage storage = (EnergyStorage)obj;
            return storage.getEnergyStoredGC() == this.energy && storage.getCapacityGC() == this.capacity && storage.getMaxReceive() == this.maxReceive && storage.getMaxExtract() == this.maxExtract;
        }
        return false;
    }
}

