/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.client.screen;

import java.nio.FloatBuffer;
import micdoodle8.mods.galacticraft.api.GalacticraftRegistry;
import micdoodle8.mods.galacticraft.api.client.IScreenManager;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.core.util.MapUtil;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.WorldProvider;
import net.minecraftforge.fml.client.FMLClientHandler;
import org.lwjgl.opengl.GL11;

public class DrawGameScreen
implements IScreenManager {
    private static final FloatBuffer colorBuffer = GLAllocation.func_74529_h((int)16);
    private static final int texCount = 1;
    public static DynamicTexture reusableMap;
    private final TextureManager renderEngine;
    private final float scaleX;
    private final float scaleZ;
    public boolean initialise;
    public boolean initialiseLast;
    public TileEntity driver;
    public Class telemetryLastClass;
    public String telemetryLastName;
    public Entity telemetryLastEntity;
    public Render telemetryLastRender;
    public int[] localMap;
    public boolean mapDone;
    public boolean mapFirstTick;
    private float tickDrawn;
    private boolean readyToInitialise;
    private int tileCount;
    private int callCount;
    private int tickMapDone;

    public DrawGameScreen(float scaleXparam, float scaleZparam, TileEntity te) {
        this.renderEngine = FMLClientHandler.instance().getClient().field_71446_o;
        this.initialise = true;
        this.initialiseLast = false;
        this.localMap = null;
        this.mapDone = false;
        this.mapFirstTick = false;
        this.tickDrawn = -1.0f;
        this.readyToInitialise = false;
        this.tileCount = 0;
        this.callCount = 0;
        this.tickMapDone = -1;
        this.scaleX = scaleXparam;
        this.scaleZ = scaleZparam;
        this.driver = te;
        this.mapFirstTick = true;
    }

    public boolean check(float scaleXparam, float scaleZparam) {
        if (this.mapDone) {
            return this.scaleX == scaleXparam && this.scaleZ == scaleZparam;
        }
        return false;
    }

    private void makeMap() {
        if (this.mapDone || reusableMap == null || GCCoreUtil.getDimensionID(this.driver.func_145831_w()) != 0) {
            return;
        }
        this.localMap = new int[123904];
        boolean result = MapUtil.getMap(this.localMap, this.driver.func_145831_w(), this.driver.func_174877_v());
        if (result) {
            TextureUtil.func_110988_a((int)reusableMap.func_110552_b(), (int[])this.localMap, (int)352, (int)352);
            this.mapDone = true;
        }
    }

    public void drawScreen(int type, float ticks, boolean cornerBlock) {
        if (type >= GalacticraftRegistry.getMaxScreenTypes()) {
            System.out.println("Wrong gamescreen type detected - this is a bug." + type);
            return;
        }
        if (cornerBlock) {
            if ((this.mapFirstTick || (int)ticks % 99 == 0) && !this.mapDone && this.tickMapDone != (int)ticks) {
                this.tickMapDone = (int)ticks;
                this.makeMap();
                this.mapFirstTick = false;
            }
            this.doDraw(type, ticks);
            this.initialise = true;
            this.initialiseLast = false;
            return;
        }
        if (this.initialise) {
            if (!this.initialiseLast) {
                this.tickDrawn = ticks;
                this.readyToInitialise = false;
                this.initialiseLast = true;
                return;
            }
            if (!this.readyToInitialise && ticks == this.tickDrawn) {
                return;
            }
            if (!this.readyToInitialise) {
                this.readyToInitialise = true;
                this.tickDrawn = ticks;
                this.tileCount = 1;
                return;
            }
            if (ticks == this.tickDrawn) {
                ++this.tileCount;
                return;
            }
            this.initialise = false;
            this.initialiseLast = false;
            this.readyToInitialise = false;
        }
        if (++this.callCount < this.tileCount) {
            if (this.callCount == 1 || this.tickDrawn == ticks) {
                this.tickDrawn = ticks;
                return;
            }
            this.initialise = true;
        }
        if (this.callCount == this.tileCount) {
            this.callCount = 0;
            if (this.tileCount > 1 && ticks != this.tickDrawn) {
                this.initialise = true;
            }
        }
        this.tickDrawn = ticks;
        this.doDraw(type, ticks);
    }

    private void doDraw(int type, float ticks) {
        float lightMapSaveX = OpenGlHelper.lastBrightnessX;
        float lightMapSaveY = OpenGlHelper.lastBrightnessY;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        if (type > 0) {
            GL11.glDisable((int)2896);
        }
        GalacticraftRegistry.getGameScreen(type).render(type, ticks, this.scaleX, this.scaleZ, this);
        if (type > 0) {
            GL11.glEnable((int)2896);
        }
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lightMapSaveX, (float)lightMapSaveY);
    }

    @Override
    public WorldProvider getWorldProvider() {
        if (this.driver != null) {
            return this.driver.func_145831_w().field_73011_w;
        }
        return null;
    }

    public float getScaleZ() {
        return this.scaleZ;
    }

    public float getScaleX() {
        return this.scaleX;
    }
}

