/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.client.gui.element;

import micdoodle8.mods.galacticraft.core.util.ColorUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ChatAllowedCharacters;
import net.minecraftforge.fml.client.FMLClientHandler;
import org.lwjgl.input.Keyboard;

public class GuiElementTextBox
extends GuiButton {
    private final int maxLength;
    private final ITextBoxCallback parentGui;
    private final Minecraft mc = FMLClientHandler.instance().getClient();
    public String text;
    public boolean numericOnly;
    public boolean centered;
    public long timeBackspacePressed;
    public int cursorPulse;
    public int backspacePressed;
    public boolean isTextFocused = false;
    public int incorrectUseTimer;

    public GuiElementTextBox(int id, ITextBoxCallback parentGui, int x, int y, int width, int height, String initialText, boolean numericOnly, int maxLength, boolean centered) {
        super(id, x, y, width, height, initialText);
        this.parentGui = parentGui;
        this.numericOnly = numericOnly;
        this.maxLength = maxLength;
        this.centered = centered;
    }

    public boolean keyTyped(char keyChar, int keyID) {
        if (this.isTextFocused) {
            if (keyID == 14) {
                if (this.text.length() > 0) {
                    if (this.parentGui.canPlayerEdit(this, (EntityPlayer)this.mc.field_71439_g)) {
                        String toBeParsed = this.text.substring(0, this.text.length() - 1);
                        if (this.isValid(toBeParsed)) {
                            this.text = toBeParsed;
                            this.timeBackspacePressed = System.currentTimeMillis();
                        } else {
                            this.text = "";
                        }
                    } else {
                        this.incorrectUseTimer = 10;
                        this.parentGui.onIntruderInteraction(this);
                    }
                }
            } else if (keyChar == '\u0016') {
                String pastestring = GuiScreen.func_146277_j();
                if (pastestring == null) {
                    pastestring = "";
                }
                if (this.isValid(this.text + pastestring)) {
                    if (this.parentGui.canPlayerEdit(this, (EntityPlayer)this.mc.field_71439_g)) {
                        this.text = this.text + pastestring;
                        this.text = this.text.substring(0, Math.min(this.text.length(), this.maxLength));
                    } else {
                        this.incorrectUseTimer = 10;
                        this.parentGui.onIntruderInteraction(this);
                    }
                }
            } else if (this.isValid(this.text + keyChar)) {
                if (this.parentGui.canPlayerEdit(this, (EntityPlayer)this.mc.field_71439_g)) {
                    this.text = this.text + keyChar;
                    this.text = this.text.substring(0, Math.min(this.text.length(), this.maxLength));
                } else {
                    this.incorrectUseTimer = 10;
                    this.parentGui.onIntruderInteraction(this);
                }
            }
            this.parentGui.onTextChanged(this, this.text);
            return true;
        }
        return false;
    }

    public void func_191745_a(Minecraft par1Minecraft, int par2, int par3, float partial) {
        if (this.text == null) {
            this.text = this.parentGui.getInitialText(this);
            this.parentGui.onTextChanged(this, this.text);
        }
        if (this.field_146125_m) {
            Gui.func_73734_a((int)this.field_146128_h, (int)this.field_146129_i, (int)(this.field_146128_h + this.field_146120_f), (int)(this.field_146129_i + this.field_146121_g), (int)ColorUtil.to32BitColor(140, 140, 140, 140));
            Gui.func_73734_a((int)(this.field_146128_h + 1), (int)(this.field_146129_i + 1), (int)(this.field_146128_h + this.field_146120_f - 1), (int)(this.field_146129_i + this.field_146121_g - 1), (int)ColorUtil.to32BitColor(255, 0, 0, 0));
            ++this.cursorPulse;
            if (this.timeBackspacePressed > 0L) {
                if (Keyboard.isKeyDown((int)14) && this.text.length() > 0) {
                    if ((float)(System.currentTimeMillis() - this.timeBackspacePressed) > 200.0f / (1.0f + (float)this.backspacePressed * 0.3f) && this.parentGui.canPlayerEdit(this, (EntityPlayer)this.mc.field_71439_g)) {
                        String toBeParsed = this.text.substring(0, this.text.length() - 1);
                        if (this.isValid(toBeParsed)) {
                            this.text = toBeParsed;
                            this.parentGui.onTextChanged(this, this.text);
                        } else {
                            this.text = "";
                        }
                        this.timeBackspacePressed = System.currentTimeMillis();
                        ++this.backspacePressed;
                    } else if (!this.parentGui.canPlayerEdit(this, (EntityPlayer)this.mc.field_71439_g)) {
                        this.incorrectUseTimer = 10;
                        this.parentGui.onIntruderInteraction(this);
                    }
                } else {
                    this.timeBackspacePressed = 0L;
                    this.backspacePressed = 0;
                }
            }
            if (this.incorrectUseTimer > 0) {
                --this.incorrectUseTimer;
            }
            int xPos = this.field_146128_h + 4;
            if (this.centered) {
                xPos = this.field_146128_h + this.field_146120_f / 2 - this.mc.field_71466_p.func_78256_a(this.text) / 2;
            }
            this.func_73731_b(this.mc.field_71466_p, this.text + (this.cursorPulse / 24 % 2 == 0 && this.isTextFocused ? "_" : ""), xPos, this.field_146129_i + this.field_146121_g / 2 - 4, this.incorrectUseTimer > 0 ? ColorUtil.to32BitColor(255, 255, 20, 20) : this.parentGui.getTextColor(this));
        }
    }

    public int getIntegerValue() {
        try {
            return Integer.parseInt(this.text.equals("") ? "0" : this.text);
        }
        catch (Exception e) {
            return -1;
        }
    }

    public boolean isValid(String string) {
        if (this.numericOnly) {
            if (string.length() > 0 && ChatAllowedCharacters.func_71566_a((char)string.charAt(string.length() - 1))) {
                try {
                    Integer.parseInt(string);
                    return true;
                }
                catch (Exception e) {
                    return false;
                }
            }
            return false;
        }
        if (string.length() <= 0) {
            return false;
        }
        return ChatAllowedCharacters.func_71566_a((char)string.charAt(string.length() - 1));
    }

    public boolean func_146116_c(Minecraft par1Minecraft, int par2, int par3) {
        if (super.func_146116_c(par1Minecraft, par2, par3)) {
            Gui.func_73734_a((int)this.field_146128_h, (int)this.field_146129_i, (int)(this.field_146128_h + this.field_146120_f), (int)(this.field_146129_i + this.field_146121_g), (int)-6250336);
            this.isTextFocused = true;
            this.text = this.parentGui.getInitialText(this);
            this.parentGui.onTextChanged(this, this.text);
            return true;
        }
        this.isTextFocused = false;
        return false;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public static interface ITextBoxCallback {
        public boolean canPlayerEdit(GuiElementTextBox var1, EntityPlayer var2);

        public void onTextChanged(GuiElementTextBox var1, String var2);

        public String getInitialText(GuiElementTextBox var1);

        public int getTextColor(GuiElementTextBox var1);

        public void onIntruderInteraction(GuiElementTextBox var1);
    }
}

